/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.EncryptionControlManager;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ConfigurationControlManager {
    public static final ConfigResource DEFAULT_NODE = new ConfigResource(ConfigResource.Type.BROKER, "");
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final KafkaConfigSchema configSchema;
    private final Consumer<ConfigResource> existenceChecker;
    private final Optional<AlterConfigPolicy> alterConfigPolicy;
    private final ConfigurationValidator validator;
    private final TimelineHashMap<ConfigResource, TimelineHashMap<String, String>> configData;
    private final Map<String, Object> staticConfig;
    private final ConfigResource currentController;
    private final EncryptionControlManager encryptionControl;
    private final Supplier<Iterator<UsableBroker>> usableBrokers;
    private final Supplier<Boolean> isTopicPlacementSupported;

    private ConfigurationControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry, KafkaConfigSchema configSchema, Consumer<ConfigResource> existenceChecker, Optional<AlterConfigPolicy> alterConfigPolicy, ConfigurationValidator validator, Map<String, Object> staticConfig, int nodeId, EncryptionControlManager encryptionControl, Supplier<Iterator<UsableBroker>> usableBrokers, Supplier<Boolean> isTopicPlacementSupported) {
        this.log = logContext.logger(ConfigurationControlManager.class);
        this.snapshotRegistry = snapshotRegistry;
        this.configSchema = configSchema;
        this.existenceChecker = existenceChecker;
        this.alterConfigPolicy = alterConfigPolicy;
        this.validator = validator;
        this.configData = new TimelineHashMap(snapshotRegistry, 0);
        this.staticConfig = Collections.unmodifiableMap(new HashMap<String, Object>(staticConfig));
        this.encryptionControl = encryptionControl;
        this.usableBrokers = usableBrokers;
        this.isTopicPlacementSupported = isTopicPlacementSupported;
        this.currentController = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(nodeId));
    }

    SnapshotRegistry snapshotRegistry() {
        return this.snapshotRegistry;
    }

    ControllerResult<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        HashMap<ConfigResource, ApiError> outputResults = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> resourceEntry : configChanges.entrySet()) {
            ApiError apiError = this.incrementalAlterConfigResource(resourceEntry.getKey(), resourceEntry.getValue(), newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, principal);
            outputResults.put(resourceEntry.getKey(), apiError);
        }
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, outputResults);
    }

    ControllerResult<ApiError> incrementalAlterConfig(ConfigResource configResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> keyToOps, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        ApiError apiError = this.incrementalAlterConfigResource(configResource, keyToOps, newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, principal);
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, apiError);
    }

    private ApiError incrementalAlterConfigResource(ConfigResource configResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> keysToOps, boolean newlyCreatedResource, List<ApiMessageAndVersion> outputRecords, KafkaPrincipal principal) {
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> keysToOpsEntry : keysToOps.entrySet()) {
            String key = keysToOpsEntry.getKey();
            String currentValue = null;
            TimelineHashMap currentConfigs = (TimelineHashMap)this.configData.get((Object)configResource);
            if (currentConfigs != null) {
                currentValue = (String)currentConfigs.get((Object)key);
            }
            String newValue = currentValue;
            Map.Entry<AlterConfigOp.OpType, String> opTypeAndNewValue = keysToOpsEntry.getValue();
            AlterConfigOp.OpType opType = opTypeAndNewValue.getKey();
            String opValue = opTypeAndNewValue.getValue();
            switch (opType) {
                case SET: {
                    newValue = opValue;
                    break;
                }
                case DELETE: {
                    newValue = null;
                    break;
                }
                case APPEND: 
                case SUBTRACT: {
                    if (!this.configSchema.isSplittable(configResource.type(), key)) {
                        return new ApiError(Errors.INVALID_CONFIG, "Can't " + opType + " to key " + key + " because its type is not LIST.");
                    }
                    List<String> oldValueList = this.getParts(newValue, key, configResource);
                    if (opType == AlterConfigOp.OpType.APPEND) {
                        for (String value : opValue.split(",")) {
                            if (oldValueList.contains(value)) continue;
                            oldValueList.add(value);
                        }
                    } else {
                        for (String value : opValue.split(",")) {
                            oldValueList.remove(value);
                        }
                    }
                    newValue = String.join((CharSequence)",", oldValueList);
                }
            }
            if (Objects.equals(currentValue, newValue) && !configResource.type().equals((Object)ConfigResource.Type.BROKER)) continue;
            newRecords.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(newValue), 0));
        }
        ApiError error = this.validateAlterConfig(configResource, newRecords, Collections.emptyList(), newlyCreatedResource, principal);
        if (error.isFailure()) {
            return error;
        }
        this.addOutputRecordsWithEncryptionIfNeeded(this.encryptionControl.encryptor(), outputRecords, newRecords);
        return ApiError.NONE;
    }

    private void addOutputRecordsWithEncryptionIfNeeded(MetadataEncryptor encryptor, List<ApiMessageAndVersion> outputRecords, List<ApiMessageAndVersion> newRecords) {
        for (ApiMessageAndVersion messageAndVersion : newRecords) {
            ConfigRecord record = (ConfigRecord)messageAndVersion.message();
            ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
            if (this.configSchema.isSensitive(type, record.name())) {
                outputRecords.add(encryptor.encrypt(messageAndVersion));
                continue;
            }
            outputRecords.add(messageAndVersion);
        }
    }

    private ApiError validateAlterConfig(ConfigResource configResource, List<ApiMessageAndVersion> recordsExplicitlyAltered, List<ApiMessageAndVersion> recordsImplicitlyDeleted, boolean newlyCreatedResource, KafkaPrincipal principal) {
        ConfigRecord configRecord;
        HashMap<String, String> allConfigs = new HashMap<String, String>();
        HashMap<String, String> alteredConfigsForAlterConfigPolicyCheck = new HashMap<String, String>();
        TimelineHashMap existingConfigs = (TimelineHashMap)this.configData.get((Object)configResource);
        if (existingConfigs != null) {
            allConfigs.putAll((Map<String, String>)existingConfigs);
        }
        for (ApiMessageAndVersion newRecord : recordsExplicitlyAltered) {
            configRecord = (ConfigRecord)newRecord.message();
            if (configRecord.value() == null) {
                allConfigs.remove(configRecord.name());
            } else {
                allConfigs.put(configRecord.name(), configRecord.value());
            }
            alteredConfigsForAlterConfigPolicyCheck.put(configRecord.name(), configRecord.value());
        }
        for (ApiMessageAndVersion recordImplicitlyDeleted : recordsImplicitlyDeleted) {
            configRecord = (ConfigRecord)recordImplicitlyDeleted.message();
            allConfigs.remove(configRecord.name());
        }
        try {
            this.validator.validate(configResource, allConfigs);
            if (!newlyCreatedResource) {
                this.existenceChecker.accept(configResource);
                if (configResource.type().equals((Object)ConfigResource.Type.TOPIC)) {
                    this.validateTopicConfigChange(configResource, allConfigs);
                }
            }
            if (!(!this.alterConfigPolicy.isPresent() || configResource.type().equals((Object)ConfigResource.Type.CLUSTER_LINK) && newlyCreatedResource)) {
                this.alterConfigPolicy.get().validate(new AlterConfigPolicy.RequestMetadata(configResource, alteredConfigsForAlterConfigPolicyCheck, principal));
            }
        }
        catch (ConfigException e) {
            return new ApiError(Errors.INVALID_CONFIG, e.getMessage());
        }
        catch (Throwable e) {
            ApiError apiError = ApiError.fromThrowable((Throwable)e);
            if (apiError.error() == Errors.UNKNOWN_SERVER_ERROR) {
                this.log.error("Unknown server error validating Alter Configs", e);
            }
            return apiError;
        }
        return ApiError.NONE;
    }

    private void validateTopicConfigChange(ConfigResource configResource, Map<String, String> newConfigs) {
        Map topicConfigs = (Map)this.configData.get((Object)configResource);
        if (topicConfigs == null) {
            topicConfigs = Collections.emptyMap();
        }
        Map<String, String> prevResolvedConfig = this.configSchema.resolveEffectiveTopicConfigsToStrings(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), topicConfigs);
        Map<String, String> newResolvedConfig = this.configSchema.resolveEffectiveTopicConfigsToStrings(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), newConfigs);
        this.validator.validateTopicConfigChange(prevResolvedConfig, newResolvedConfig, this.usableBrokers.get(), this.isTopicPlacementSupported.get());
    }

    ControllerResult<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean newlyCreatedResource) {
        return this.legacyAlterConfigs(newConfigs, newlyCreatedResource, null);
    }

    ControllerResult<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> newConfigs, boolean newlyCreatedResource, KafkaPrincipal principal) {
        BoundedList outputRecords = BoundedList.newArrayBacked((int)10000);
        HashMap<ConfigResource, ApiError> outputResults = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, String>> resourceEntry : newConfigs.entrySet()) {
            this.legacyAlterConfigResource(resourceEntry.getKey(), resourceEntry.getValue(), newlyCreatedResource, (List<ApiMessageAndVersion>)outputRecords, outputResults, principal);
        }
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)outputRecords, outputResults);
    }

    private void legacyAlterConfigResource(ConfigResource configResource, Map<String, String> newConfigs, boolean newlyCreatedResource, List<ApiMessageAndVersion> outputRecords, Map<ConfigResource, ApiError> outputResults, KafkaPrincipal principal) {
        ArrayList<ApiMessageAndVersion> recordsExplicitlyAltered = new ArrayList<ApiMessageAndVersion>();
        Map currentConfigs = (Map)this.configData.get((Object)configResource);
        if (currentConfigs == null) {
            currentConfigs = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : newConfigs.entrySet()) {
            String key = entry.getKey();
            String newValue = entry.getValue();
            String currentValue = (String)currentConfigs.get(key);
            if (Objects.equals(currentValue, newValue) && !configResource.type().equals((Object)ConfigResource.Type.BROKER)) continue;
            recordsExplicitlyAltered.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(newValue), 0));
        }
        ArrayList<ApiMessageAndVersion> recordsImplicitlyDeleted = new ArrayList<ApiMessageAndVersion>();
        for (String key : currentConfigs.keySet()) {
            if (newConfigs.containsKey(key)) continue;
            recordsImplicitlyDeleted.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(key).setValue(null), 0));
        }
        ApiError apiError = this.validateAlterConfig(configResource, recordsExplicitlyAltered, recordsImplicitlyDeleted, newlyCreatedResource, principal);
        if (apiError.isFailure()) {
            outputResults.put(configResource, apiError);
            return;
        }
        MetadataEncryptor encryptor = this.encryptionControl.encryptor();
        this.addOutputRecordsWithEncryptionIfNeeded(encryptor, outputRecords, recordsExplicitlyAltered);
        this.addOutputRecordsWithEncryptionIfNeeded(encryptor, outputRecords, recordsImplicitlyDeleted);
        outputResults.put(configResource, ApiError.NONE);
    }

    private List<String> getParts(String value, String key, ConfigResource configResource) {
        String[] splitValues;
        if (value == null) {
            value = this.configSchema.getDefault(configResource.type(), key);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (value == null) {
            return parts;
        }
        for (String splitValue : splitValues = value.split(",")) {
            if (splitValue.isEmpty()) continue;
            parts.add(splitValue);
        }
        return parts;
    }

    public void replay(ConfigRecord record) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
        ConfigResource configResource = new ConfigResource(type, record.resourceName());
        TimelineHashMap configs = (TimelineHashMap)this.configData.get((Object)configResource);
        if (configs == null) {
            configs = new TimelineHashMap(this.snapshotRegistry, 0);
            this.configData.put((Object)configResource, (Object)configs);
        }
        if (record.value() == null) {
            configs.remove((Object)record.name());
        } else {
            configs.put((Object)record.name(), (Object)record.value());
        }
        if (configs.isEmpty()) {
            this.configData.remove((Object)configResource);
        }
        if (this.configSchema.isSensitive(record)) {
            this.log.info("{}: set configuration {} to {}", new Object[]{configResource, record.name(), "[hidden]"});
        } else {
            this.log.info("{}: set configuration {} to {}", new Object[]{configResource, record.name(), record.value()});
        }
    }

    Map<String, String> getConfigs(ConfigResource configResource) {
        Map map = (Map)this.configData.get((Object)configResource);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap(map));
    }

    public Map<ConfigResource, ResultOrError<Map<String, String>>> describeConfigs(long lastCommittedOffset, Map<ConfigResource, Collection<String>> resources) {
        HashMap<ConfigResource, ResultOrError<Map<String, String>>> results = new HashMap<ConfigResource, ResultOrError<Map<String, String>>>();
        for (Map.Entry<ConfigResource, Collection<String>> resourceEntry : resources.entrySet()) {
            ConfigResource resource = resourceEntry.getKey();
            try {
                this.validator.validate(resource);
            }
            catch (Throwable e) {
                results.put(resource, new ResultOrError<ApiError>(ApiError.fromThrowable((Throwable)e)));
                continue;
            }
            HashMap foundConfigs = new HashMap();
            TimelineHashMap configs = (TimelineHashMap)this.configData.get((Object)resource, lastCommittedOffset);
            if (configs != null) {
                Collection<String> targetConfigs = resourceEntry.getValue();
                if (targetConfigs.isEmpty()) {
                    for (Map.Entry entry : configs.entrySet(lastCommittedOffset)) {
                        foundConfigs.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    for (String key : targetConfigs) {
                        String value = (String)configs.get((Object)key, lastCommittedOffset);
                        if (value == null) continue;
                        foundConfigs.put(key, value);
                    }
                }
            }
            results.put(resource, new ResultOrError(foundConfigs));
        }
        return results;
    }

    Map<String, String> getTopicConfigs(String topicName) {
        Map configs = (Map)this.configData.get((Object)new ConfigResource(ConfigResource.Type.TOPIC, topicName));
        if (configs == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(configs);
    }

    public String getEffectiveTopicConfigValue(String configKey, String topicName) {
        Map<String, ConfigEntry> entries = this.configSchema.resolveEffectiveTopicConfigs(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), this.getTopicConfigs(topicName));
        ConfigEntry entry = entries.get(configKey);
        return entry != null ? entry.value() : null;
    }

    void deleteTopicConfigs(String name) {
        this.configData.remove((Object)new ConfigResource(ConfigResource.Type.TOPIC, name));
    }

    void deleteClusterLinkConfigs(String linkName) {
        this.configData.remove((Object)new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName));
    }

    Optional<TopicPlacement> topicPlacementConfig(String topicName) {
        Map<String, String> topicConfigs = this.getTopicConfigs(topicName);
        String topicPlacementStr = topicConfigs.get("confluent.placement.constraints");
        try {
            return TopicPlacement.parse((String)topicPlacementStr);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Failed to parse topic placement {} for topic {}.", new Object[]{topicPlacementStr, topicName, e});
            throw e;
        }
    }

    boolean uncleanLeaderElectionEnabledForTopic(String name) {
        return false;
    }

    Map<String, ConfigEntry> computeEffectiveTopicConfigs(Map<String, String> creationConfigs) {
        return this.configSchema.resolveEffectiveTopicConfigs(this.staticConfig, this.clusterConfig(), this.currentControllerConfig(), creationConfigs);
    }

    Map<String, String> clusterConfig() {
        Map result = (Map)this.configData.get((Object)DEFAULT_NODE);
        return result == null ? Collections.emptyMap() : result;
    }

    Map<String, String> currentControllerConfig() {
        Map result = (Map)this.configData.get((Object)this.currentController);
        return result == null ? Collections.emptyMap() : result;
    }

    EncryptionControlManager encryptionControl() {
        return this.encryptionControl;
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private KafkaConfigSchema configSchema = KafkaConfigSchema.EMPTY;
        private Consumer<ConfigResource> existenceChecker = __ -> {};
        private Optional<AlterConfigPolicy> alterConfigPolicy = Optional.empty();
        private ConfigurationValidator validator = ConfigurationValidator.NO_OP;
        private Map<String, Object> staticConfig = Collections.emptyMap();
        private int nodeId = 0;
        private EncryptionControlManager encryptionControl = null;
        private Supplier<Iterator<UsableBroker>> usableBrokers;
        private Supplier<Boolean> isTopicPlacementSupported;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setKafkaConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        Builder setExistenceChecker(Consumer<ConfigResource> existenceChecker) {
            this.existenceChecker = existenceChecker;
            return this;
        }

        Builder setAlterConfigPolicy(Optional<AlterConfigPolicy> alterConfigPolicy) {
            this.alterConfigPolicy = alterConfigPolicy;
            return this;
        }

        Builder setValidator(ConfigurationValidator validator) {
            this.validator = validator;
            return this;
        }

        Builder setStaticConfig(Map<String, Object> staticConfig) {
            this.staticConfig = staticConfig;
            return this;
        }

        Builder setNodeId(int nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        Builder setEncryptionControlManager(EncryptionControlManager encryptionControl) {
            this.encryptionControl = encryptionControl;
            return this;
        }

        Builder setUsableBrokers(Supplier<Iterator<UsableBroker>> usableBrokers) {
            this.usableBrokers = usableBrokers;
            return this;
        }

        Builder setIsTopicPlacementSupport(Supplier<Boolean> isTopicPlacementSupported) {
            this.isTopicPlacementSupported = isTopicPlacementSupported;
            return this;
        }

        ConfigurationControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.encryptionControl == null) {
                this.encryptionControl = new EncryptionControlManager(this.logContext, this.snapshotRegistry, Collections.emptyMap());
            }
            return new ConfigurationControlManager(this.logContext, this.snapshotRegistry, this.configSchema, this.existenceChecker, this.alterConfigPolicy, this.validator, this.staticConfig, this.nodeId, this.encryptionControl, this.usableBrokers, this.isTopicPlacementSupported);
        }
    }
}

