/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class QuorumControllerMetrics
implements ControllerMetrics {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName FENCED_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName BROKERS_WITH_DEGRADED_HEALTH_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "BrokersWithDegradedHealthCount");
    private static final MetricName GLOBAL_TOPIC_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName GLOBAL_OFFLINE_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName GLOBAL_UNDER_MIN_ISR_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalUnderMinIsrPartitionCount");
    private static final MetricName GLOBAL_PARTITION_AVAILABILITY = QuorumControllerMetrics.getMetricName("KafkaController", "PartitionAvailability");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private static final MetricName BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "BrokersExcludedForReplicaPlacementCount");
    private final MetricsRegistry registry;
    private volatile boolean active;
    private volatile int fencedBrokerCount;
    private volatile int activeBrokerCount;
    private volatile int brokersWithDegradedHealthCount;
    private volatile int globalTopicCount;
    private final Map<String, TenantPartitionMetrics> tenantPartitionMetricsMap = new ConcurrentHashMap<String, TenantPartitionMetrics>();
    private volatile int globalPartitionCount;
    private volatile int globalOfflinePartitionCount;
    private volatile int globalUnderMinIsrCount;
    private volatile double globalPartitionAvailability;
    private volatile int excludedBrokerCount;
    private volatile int preferredReplicaImbalanceCount;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final Gauge<Integer> activeControllerCount;
    private final Gauge<Integer> fencedBrokerCountGauge;
    private final Gauge<Integer> activeBrokerCountGauge;
    private final Gauge<Integer> brokersWithDegradedHealthCountGauge;
    private final Gauge<Integer> globalTopicCountGauge;
    private final Gauge<Integer> globalPartitionCountGauge;
    private final Gauge<Integer> globalOfflinePartitionCountGauge;
    private final Gauge<Integer> globalUnderMinIsrCountGauge;
    private final Gauge<Double> globalPartitionAvailabilityGauge;
    private final Gauge<Integer> excludedBrokerCountGauge;
    private final Gauge<Integer> preferredReplicaImbalanceCountGauge;
    private final Gauge<Long> lastAppliedRecordOffsetGauge;
    private final Gauge<Long> lastCommittedRecordOffsetGauge;
    private final Gauge<Long> lastAppliedRecordTimestampGauge;
    private final Gauge<Long> lastAppliedRecordLagMsGauge;
    private final Histogram eventQueueTime;
    private final Histogram eventQueueProcessingTime;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);
    private final Metrics kafkaMetrics;
    private final Sensor controllerLoadSensor;

    public QuorumControllerMetrics(MetricsRegistry registry, final Time time, Metrics kafkaMetrics) {
        this.registry = Objects.requireNonNull(registry);
        this.active = false;
        this.fencedBrokerCount = 0;
        this.activeBrokerCount = 0;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.globalOfflinePartitionCount = 0;
        this.globalUnderMinIsrCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        this.activeControllerCount = registry.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        });
        this.eventQueueTime = registry.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTime = registry.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        this.kafkaMetrics = kafkaMetrics;
        this.controllerLoadSensor = kafkaMetrics.sensor("ControllerLoadTime");
        this.controllerLoadSensor.add(kafkaMetrics.metricName("controller-load-time-max", "controller-metrics", "The max time it took to load the controller"), (MeasurableStat)new Max());
        this.controllerLoadSensor.add(kafkaMetrics.metricName("controller-load-time-avg", "controller-metrics", "The average time it took to load the controller"), (MeasurableStat)new Avg());
        this.fencedBrokerCountGauge = registry.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.fencedBrokerCount;
            }
        });
        this.activeBrokerCountGauge = registry.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.activeBrokerCount;
            }
        });
        this.brokersWithDegradedHealthCountGauge = registry.newGauge(BROKERS_WITH_DEGRADED_HEALTH_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.brokersWithDegradedHealthCount;
            }
        });
        this.globalTopicCountGauge = registry.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalTopicCount;
            }
        });
        this.globalPartitionCountGauge = registry.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalPartitionCount;
            }
        });
        this.globalOfflinePartitionCountGauge = registry.newGauge(GLOBAL_OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalOfflinePartitionCount;
            }
        });
        this.globalUnderMinIsrCountGauge = registry.newGauge(GLOBAL_UNDER_MIN_ISR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalUnderMinIsrCount;
            }
        });
        this.globalPartitionAvailabilityGauge = registry.newGauge(GLOBAL_PARTITION_AVAILABILITY, (Gauge)new Gauge<Double>(){

            public Double value() {
                return QuorumControllerMetrics.this.globalPartitionAvailability;
            }
        });
        this.excludedBrokerCountGauge = registry.newGauge(BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.excludedBrokerCount;
            }
        });
        this.preferredReplicaImbalanceCountGauge = registry.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.preferredReplicaImbalanceCount;
            }
        });
        this.lastAppliedRecordOffsetGauge = registry.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset.get();
            }
        });
        this.lastCommittedRecordOffsetGauge = registry.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset.get();
            }
        });
        this.lastAppliedRecordTimestampGauge = registry.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp.get();
            }
        });
        this.lastAppliedRecordLagMsGauge = registry.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return time.milliseconds() - QuorumControllerMetrics.this.lastAppliedRecordTimestamp.get();
            }
        });
    }

    @Override
    public void recordControllerLoadTime(long startMs, long endMs) {
        this.controllerLoadSensor.record((double)(endMs - startMs), endMs, false);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTime.update(durationMs);
    }

    @Override
    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTime.update(durationMs);
    }

    @Override
    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount = brokerCount;
    }

    @Override
    public int fencedBrokerCount() {
        return this.fencedBrokerCount;
    }

    @Override
    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount = brokerCount;
    }

    @Override
    public int activeBrokerCount() {
        return this.activeBrokerCount;
    }

    @Override
    public void setBrokersWithDegradedHealthCount(int degradedCount) {
        this.brokersWithDegradedHealthCount = degradedCount;
    }

    @Override
    public int brokersWithDegradedHealthCount() {
        return this.brokersWithDegradedHealthCount;
    }

    @Override
    public void setGlobalTopicCount(int topicCount) {
        this.globalTopicCount = topicCount;
    }

    @Override
    public int globalTopicCount() {
        return this.globalTopicCount;
    }

    @Override
    public void setGlobalPartitionCount(int partitionCount) {
        this.globalPartitionCount = partitionCount;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    @Override
    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    @Override
    public void setGlobalOfflinePartitionCount(int offlinePartitions) {
        this.globalOfflinePartitionCount = offlinePartitions;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    @Override
    public int globalOfflinePartitionCount() {
        return this.globalOfflinePartitionCount;
    }

    @Override
    public double globalPartitionAvailability() {
        return this.globalPartitionAvailability;
    }

    @Override
    public void setGlobalUnderMinIsrCount(int count) {
        this.globalUnderMinIsrCount = count;
        this.updateGlobalPartitionAvailabilitySLO();
    }

    @Override
    public int globalUnderMinIsrCount() {
        return this.globalUnderMinIsrCount;
    }

    @Override
    public void setTenantPartitionCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setPartitionCount(count);
        }
    }

    @Override
    public void setTenantOfflinePartitionCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setOfflinePartitionCount(count);
        }
    }

    @Override
    public void setTenantUnderMinIsrCount(String tenant, int count) {
        TenantPartitionMetrics metrics = this.getOrCreateTenantMetrics(tenant);
        if (metrics != null) {
            metrics.setUnderMinIsrCount(count);
        }
    }

    @Override
    public void removeTenant(String tenant) {
        this.removeTenantMetric(tenant);
        this.tenantPartitionMetricsMap.remove(tenant);
    }

    @Override
    public void setExcludedBrokerCount(int excludedBrokerCount) {
        this.excludedBrokerCount = excludedBrokerCount;
    }

    @Override
    public int excludedBrokerCount() {
        return this.excludedBrokerCount;
    }

    @Override
    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalanceCount = replicaImbalances;
    }

    @Override
    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    @Override
    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    @Override
    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    @Override
    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    @Override
    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    @Override
    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    @Override
    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    @Override
    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.addAndGet(1L);
    }

    @Override
    public void setTimedOutHeartbeats(long heartbeats) {
        this.timedOutHeartbeats.set(heartbeats);
    }

    @Override
    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    @Override
    public void close() {
        Arrays.asList(ACTIVE_CONTROLLER_COUNT, FENCED_BROKER_COUNT, ACTIVE_BROKER_COUNT, BROKERS_WITH_DEGRADED_HEALTH_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, GLOBAL_OFFLINE_PARTITION_COUNT, GLOBAL_UNDER_MIN_ISR_COUNT, GLOBAL_PARTITION_AVAILABILITY, PREFERRED_REPLICA_IMBALANCE_COUNT, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS, BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        this.tenantPartitionMetricsMap.keySet().forEach(this::removeTenantMetric);
        this.tenantPartitionMetricsMap.clear();
        Arrays.asList(this.controllerLoadSensor).stream().map(Sensor::name).forEach(arg_0 -> ((Metrics)this.kafkaMetrics).removeSensor(arg_0));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    private static MetricName getTenantMetricName(String tenant) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("tenant", tenant);
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"TenantPartitionAvailability", tags);
    }

    private static double computePartitionAvailabilitySLO(double partitionCount, double offlineCount, double underMinIsrCount) {
        return partitionCount == 0.0 ? 1.0 : (partitionCount - underMinIsrCount - offlineCount) / partitionCount;
    }

    private void updateGlobalPartitionAvailabilitySLO() {
        this.globalPartitionAvailability = QuorumControllerMetrics.computePartitionAvailabilitySLO(this.globalPartitionCount, this.globalOfflinePartitionCount, this.globalUnderMinIsrCount);
    }

    Map<String, TenantPartitionMetrics> getTenantPartitionMetricsMap() {
        return this.tenantPartitionMetricsMap;
    }

    Double getTenantPartitionAvailabilitySLO(String tenant) {
        return this.getOrCreateTenantMetrics(tenant).getPartitionAvailability();
    }

    private TenantPartitionMetrics getOrCreateTenantMetrics(String tenant) {
        if (tenant == null) {
            return null;
        }
        return this.tenantPartitionMetricsMap.computeIfAbsent(tenant, x$0 -> new TenantPartitionMetrics((String)x$0));
    }

    private void removeTenantMetric(String tenant) {
        this.registry.removeMetric(QuorumControllerMetrics.getTenantMetricName(tenant));
    }

    class TenantPartitionMetrics {
        private volatile double partitionAvailability = 0.0;
        private volatile int underMinIsrCount = 0;
        private volatile int partitionCount = 0;
        private volatile int offlinePartitionCount = 0;

        public double getPartitionAvailability() {
            return this.partitionAvailability;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public int getOfflinePartitionCount() {
            return this.offlinePartitionCount;
        }

        public int getUnderMinIsrPartitionsCount() {
            return this.underMinIsrCount;
        }

        private TenantPartitionMetrics(String tenant) {
            this.createGauge(QuorumControllerMetrics.getTenantMetricName(tenant), this);
        }

        private void setPartitionCount(int count) {
            this.partitionCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void setOfflinePartitionCount(int count) {
            this.offlinePartitionCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void setUnderMinIsrCount(int count) {
            this.underMinIsrCount = count;
            this.updatePartitionAvailabilitySLO();
        }

        private void updatePartitionAvailabilitySLO() {
            this.partitionAvailability = QuorumControllerMetrics.computePartitionAvailabilitySLO(this.partitionCount, this.offlinePartitionCount, this.underMinIsrCount);
        }

        private void createGauge(MetricName metric, final TenantPartitionMetrics obj) {
            QuorumControllerMetrics.this.registry.newGauge(metric, (Gauge)new Gauge<Double>(){

                public Double value() {
                    return obj.getPartitionAvailability();
                }
            });
        }
    }
}

