/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineObject;
import org.slf4j.Logger;

public class FeatureControlManager {
    private final Logger log;
    private final QuorumFeatures quorumFeatures;
    private final TimelineHashMap<String, Short> finalizedVersions;
    private final TimelineObject<MetadataVersion> metadataVersion;
    private final TimelineObject<ZkMigrationState> migrationControlState;
    private final MetadataVersion minimumBootstrapVersion;

    private FeatureControlManager(LogContext logContext, QuorumFeatures quorumFeatures, SnapshotRegistry snapshotRegistry, MetadataVersion metadataVersion, MetadataVersion minimumBootstrapVersion) {
        this.log = logContext.logger(FeatureControlManager.class);
        this.quorumFeatures = quorumFeatures;
        this.finalizedVersions = new TimelineHashMap(snapshotRegistry, 0);
        this.metadataVersion = new TimelineObject(snapshotRegistry, (Object)metadataVersion);
        this.minimumBootstrapVersion = minimumBootstrapVersion;
        this.migrationControlState = new TimelineObject(snapshotRegistry, (Object)ZkMigrationState.NONE);
    }

    ControllerResult<Map<String, ApiError>> updateFeatures(Map<String, Short> updates, Map<String, FeatureUpdate.UpgradeType> upgradeTypes, Map<Integer, Map<String, VersionRange>> brokerFeatures, boolean validateOnly) {
        TreeMap<String, ApiError> results = new TreeMap<String, ApiError>();
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        for (Map.Entry<String, Short> entry : updates.entrySet()) {
            results.put(entry.getKey(), this.updateFeature(entry.getKey(), entry.getValue(), upgradeTypes.getOrDefault(entry.getKey(), FeatureUpdate.UpgradeType.UPGRADE), brokerFeatures, (List<ApiMessageAndVersion>)records));
        }
        if (validateOnly) {
            return ControllerResult.of(Collections.emptyList(), results);
        }
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)records, results);
    }

    MetadataVersion metadataVersion() {
        return (MetadataVersion)this.metadataVersion.get();
    }

    ZkMigrationState zkMigrationState() {
        return (ZkMigrationState)((Object)this.migrationControlState.get());
    }

    boolean isTopicPlacementSupported() {
        return this.metadataVersion().isTopicPlacementSupported();
    }

    private ApiError updateFeature(String featureName, short newVersion, FeatureUpdate.UpgradeType upgradeType, Map<Integer, Map<String, VersionRange>> brokersAndFeatures, List<ApiMessageAndVersion> records) {
        if (upgradeType.equals((Object)FeatureUpdate.UpgradeType.UNKNOWN)) {
            return this.invalidUpdateVersion(featureName, newVersion, "The controller does not support the given upgrade type.");
        }
        if (featureName.equals("metadata.version")) {
            featureName = "confluent.metadata.version";
            if (newVersion != 0) {
                MetadataVersion mv;
                try {
                    mv = MetadataVersion.fromApacheFeatureLevel((short)newVersion);
                }
                catch (IllegalArgumentException e) {
                    return this.invalidApacheMetadataVersion(newVersion, "Unknown metadata.version.");
                }
                this.log.info("Remapping metadata.version {} to confluent.metadata.version {}.", (Object)newVersion, (Object)mv.confluentFeatureLevel());
                newVersion = mv.confluentFeatureLevel();
            }
        }
        short currentVersion = featureName.equals("confluent.metadata.version") ? ((MetadataVersion)this.metadataVersion.get()).confluentFeatureLevel() : ((Short)this.finalizedVersions.getOrDefault((Object)featureName, (Object)0)).shortValue();
        if (newVersion < 0) {
            return this.invalidUpdateVersion(featureName, newVersion, "A feature version cannot be less than 0.");
        }
        Optional<String> reasonNotSupported = this.quorumFeatures.reasonNotSupported(featureName, newVersion);
        if (reasonNotSupported.isPresent()) {
            return this.invalidUpdateVersion(featureName, newVersion, reasonNotSupported.get());
        }
        for (Map.Entry<Integer, Map<String, VersionRange>> brokerEntry : brokersAndFeatures.entrySet()) {
            VersionRange brokerRange = brokerEntry.getValue().get(featureName);
            if (brokerRange == null) {
                return this.invalidUpdateVersion(featureName, newVersion, "Broker " + brokerEntry.getKey() + " does not support this feature.");
            }
            if (brokerRange.contains(newVersion)) continue;
            return this.invalidUpdateVersion(featureName, newVersion, "Broker " + brokerEntry.getKey() + " does not support the given version. It supports " + brokerRange.min() + " to " + brokerRange.max() + ".");
        }
        if (newVersion < currentVersion) {
            if (upgradeType.equals((Object)FeatureUpdate.UpgradeType.UPGRADE)) {
                return this.invalidUpdateVersion(featureName, newVersion, "Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade.");
            }
        } else if (newVersion > currentVersion && !upgradeType.equals((Object)FeatureUpdate.UpgradeType.UPGRADE)) {
            return this.invalidUpdateVersion(featureName, newVersion, "Can't downgrade to a newer version.");
        }
        if (featureName.equals("confluent.metadata.version")) {
            return this.updateMetadataVersion(newVersion, upgradeType.equals((Object)FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE), records::add);
        }
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setFeatureLevel(newVersion), 0));
        return ApiError.NONE;
    }

    private ApiError invalidUpdateVersion(String feature, short version, String message) {
        String errorMessage = String.format("Invalid update version %d for feature %s. %s", version, feature, message);
        this.log.debug(errorMessage);
        return new ApiError(Errors.INVALID_UPDATE_VERSION, errorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApiError updateMetadataVersion(short newVersionLevel, boolean allowUnsafeDowngrade, Consumer<ApiMessageAndVersion> recordConsumer) {
        block8: {
            MetadataVersion newVersion;
            MetadataVersion currentVersion = this.metadataVersion();
            ZkMigrationState zkMigrationState = this.zkMigrationState();
            try {
                newVersion = MetadataVersion.fromConfluentFeatureLevel((short)newVersionLevel);
            }
            catch (IllegalArgumentException e) {
                return this.invalidConfluentMetadataVersion(newVersionLevel, "Unknown confluent.metadata.version.");
            }
            if (zkMigrationState.inProgress()) {
                return this.invalidUpdateVersion("confluent.metadata.version", newVersionLevel, "Unable to modify confluent.metadata.version while a ZK migration is in progress.");
            }
            if (newVersion.isLessThan(this.minimumBootstrapVersion)) {
                return this.invalidConfluentMetadataVersion(newVersionLevel, "Unable to set a confluent.metadata.version less than " + this.minimumBootstrapVersion);
            }
            if (newVersion.isLessThan(currentVersion)) {
                boolean metadataChanged = MetadataVersion.checkIfMetadataChanged((MetadataVersion)currentVersion, (MetadataVersion)newVersion);
                if (!metadataChanged) {
                    this.log.info("Downgrading metadata.version from {} to {}.", (Object)currentVersion, (Object)newVersion);
                    break block8;
                } else {
                    if (allowUnsafeDowngrade) {
                        return this.invalidConfluentMetadataVersion(newVersionLevel, "Unsafe metadata downgrade is not supported in this version.");
                    }
                    return this.invalidConfluentMetadataVersion(newVersionLevel, "Refusing to perform the requested downgrade because it might delete metadata information. Retry using UNSAFE_DOWNGRADE if you want to force the downgrade to proceed.");
                }
            }
            this.log.info("Upgrading metadata.version from {} to {}.", (Object)currentVersion, (Object)newVersion);
        }
        recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(newVersionLevel), MetadataRecordType.FEATURE_LEVEL_RECORD.lowestSupportedVersion()));
        return ApiError.NONE;
    }

    private ApiError invalidApacheMetadataVersion(short version, String message) {
        String errorMessage = String.format("Invalid metadata.version %d. %s", version, message);
        this.log.error(errorMessage);
        return new ApiError(Errors.INVALID_UPDATE_VERSION, errorMessage);
    }

    private ApiError invalidConfluentMetadataVersion(short version, String message) {
        String errorMessage = String.format("Invalid confluent.metadata.version %d. %s", version, message);
        this.log.error(errorMessage);
        return new ApiError(Errors.INVALID_UPDATE_VERSION, errorMessage);
    }

    FinalizedControllerFeatures finalizedFeatures(long epoch) {
        HashMap<String, Short> features = new HashMap<String, Short>();
        features.put("confluent.metadata.version", ((MetadataVersion)this.metadataVersion.get(epoch)).confluentFeatureLevel());
        for (Map.Entry entry : this.finalizedVersions.entrySet(epoch)) {
            features.put((String)entry.getKey(), (Short)entry.getValue());
        }
        return new FinalizedControllerFeatures(features, epoch);
    }

    boolean inPreMigrationMode() {
        return ((ZkMigrationState)((Object)this.migrationControlState.get())).equals((Object)ZkMigrationState.PRE_MIGRATION);
    }

    public void replay(FeatureLevelRecord record) {
        VersionRange range = this.quorumFeatures.localSupportedFeature(record.name());
        if (!range.contains(record.featureLevel())) {
            throw new RuntimeException("Tried to apply FeatureLevelRecord " + record + ", but this controller only supports versions " + range);
        }
        if (record.name().equals("confluent.metadata.version")) {
            if (record.featureLevel() > 0 && record.featureLevel() <= 7) {
                MetadataVersion mv = MetadataVersion.fromApacheFeatureLevel((short)record.featureLevel());
                this.log.info("Reading legacy pre-KMETA-451 feature level and setting confluent.metadata.version to {}", (Object)mv);
            } else {
                MetadataVersion mv = MetadataVersion.fromConfluentFeatureLevel((short)record.featureLevel());
                this.log.info("Setting confluent.metadata.version to {}", (Object)mv);
            }
            this.metadataVersion.set((Object)MetadataVersion.fromConfluentFeatureLevel((short)record.featureLevel()));
        } else if (record.name().equals("metadata.version")) {
            MetadataVersion mv = MetadataVersion.fromApacheFeatureLevel((short)record.featureLevel());
            this.log.info("Read Apache metadata.version at level {}, interpreting as confluent.metadata.version {}", (Object)record.featureLevel(), (Object)mv);
            this.metadataVersion.set((Object)mv);
        } else if (record.featureLevel() == 0) {
            this.log.info("Removing feature {}", (Object)record.name());
            this.finalizedVersions.remove((Object)record.name());
        } else {
            this.log.info("Setting feature {} to {}", (Object)record.name(), (Object)record.featureLevel());
            this.finalizedVersions.put((Object)record.name(), (Object)record.featureLevel());
        }
    }

    public void replay(ZkMigrationStateRecord record) {
        ZkMigrationState recordState = ZkMigrationState.of(record.zkMigrationState());
        ZkMigrationState currentState = (ZkMigrationState)((Object)this.migrationControlState.get());
        this.log.info("Transitioning ZK migration state from {} to {}", (Object)currentState, (Object)recordState);
        this.migrationControlState.set((Object)recordState);
    }

    boolean isControllerId(int nodeId) {
        return this.quorumFeatures.isControllerId(nodeId);
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private QuorumFeatures quorumFeatures = null;
        private MetadataVersion metadataVersion = MetadataVersion.latest();
        private MetadataVersion minimumBootstrapVersion = MetadataVersion.MINIMUM_BOOTSTRAP_VERSION;

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setQuorumFeatures(QuorumFeatures quorumFeatures) {
            this.quorumFeatures = quorumFeatures;
            return this;
        }

        Builder setMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        Builder setMinimumBootstrapVersion(MetadataVersion minimumBootstrapVersion) {
            this.minimumBootstrapVersion = minimumBootstrapVersion;
            return this;
        }

        public FeatureControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.quorumFeatures == null) {
                this.quorumFeatures = new QuorumFeatures(0, new ApiVersions(), QuorumFeatures.defaultFeatureMap(), Collections.emptyList());
            }
            return new FeatureControlManager(this.logContext, this.quorumFeatures, this.snapshotRegistry, this.metadataVersion, this.minimumBootstrapVersion);
        }
    }
}

