/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.server.mutable.BoundedListTooLongException;

public class ControllerExceptions {
    public static boolean isTimeoutException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof ExecutionException && (exception = exception.getCause()) == null) {
            return false;
        }
        return exception instanceof TimeoutException;
    }

    public static boolean isNotControllerException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof ExecutionException && (exception = exception.getCause()) == null) {
            return false;
        }
        return exception instanceof NotControllerException;
    }

    public static NotControllerException newPreMigrationException(OptionalInt controllerId) {
        if (controllerId.isPresent()) {
            return new NotControllerException("The controller is in pre-migration mode.");
        }
        return new NotControllerException("No controller appears to be active.");
    }

    public static NotControllerException newWrongControllerException(OptionalInt controllerId) {
        if (controllerId.isPresent()) {
            return new NotControllerException("The active controller appears to be node " + controllerId.getAsInt() + ".");
        }
        return new NotControllerException("No controller appears to be active.");
    }

    public static boolean isExpected(Throwable exception) {
        if (exception instanceof ApiException) {
            return true;
        }
        if (exception instanceof NotLeaderException) {
            return true;
        }
        if (exception instanceof RejectedExecutionException) {
            return true;
        }
        if (exception instanceof BoundedListTooLongException) {
            return true;
        }
        if (exception instanceof InterruptedException) {
            return false;
        }
        return false;
    }

    public static Throwable toExternalException(Throwable exception, Supplier<OptionalInt> latestControllerSupplier) {
        if (exception instanceof ApiException) {
            return exception;
        }
        if (exception instanceof NotLeaderException) {
            return ControllerExceptions.newWrongControllerException(latestControllerSupplier.get());
        }
        if (exception instanceof RejectedExecutionException) {
            return new TimeoutException("The controller is shutting down.", exception);
        }
        if (exception instanceof BoundedListTooLongException) {
            return new PolicyViolationException("Unable to perform excessively large batch operation.");
        }
        if (exception instanceof InterruptedException) {
            return new UnknownServerException("The controller was interrupted.");
        }
        return new UnknownServerException(exception);
    }
}

