/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.SerdeFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.avro.AvroDataTranslator;
import io.confluent.ksql.serde.avro.AvroProperties;
import io.confluent.ksql.serde.avro.AvroSRSchemaDataTranslator;
import io.confluent.ksql.serde.avro.AvroSchemaTranslator;
import io.confluent.ksql.serde.avro.AvroUtil;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.DataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.tls.ThreadLocalDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

@Immutable
class KsqlAvroSerdeFactory
implements SerdeFactory {
    private final String fullSchemaName;
    private final AvroProperties properties;

    KsqlAvroSerdeFactory(AvroProperties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.fullSchemaName = Objects.requireNonNull(properties.getFullSchemaName(), "fullSchemaName").trim();
        if (this.fullSchemaName.isEmpty()) {
            throw new IllegalArgumentException("the schema name cannot be empty");
        }
    }

    KsqlAvroSerdeFactory(ImmutableMap<String, String> properties) {
        this(new AvroProperties((Map<String, String>)properties));
    }

    @Override
    public <T> Serde<T> createSerde(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        AvroUtil.throwOnInvalidSchema(schema);
        Optional<Schema> physicalSchema = this.properties.getSchemaId().isPresent() ? Optional.of(SerdeUtils.getAndTranslateSchemaById(srFactory, this.properties.getSchemaId().get(), new AvroSchemaTranslator(this.properties))) : Optional.empty();
        Supplier<Serializer<T>> serializerSupplier = this.createConnectSerializer(schema, ksqlConfig, srFactory, targetType, physicalSchema, isKey);
        Supplier<Deserializer<T>> deserializerSupplier = this.createConnectDeserializer(schema, ksqlConfig, srFactory, targetType, physicalSchema, isKey);
        serializerSupplier.get();
        deserializerSupplier.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer<T>(serializerSupplier), new ThreadLocalDeserializer<T>(deserializerSupplier));
    }

    private <T> Supplier<Serializer<T>> createConnectSerializer(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, Optional<Schema> physicalSchema, boolean isKey) {
        return () -> {
            DataTranslator translator = this.createAvroTranslator(schema, physicalSchema, false);
            Schema compatibleSchema = translator instanceof AvroDataTranslator ? ((AvroDataTranslator)translator).getAvroCompatibleSchema() : ((ConnectDataTranslator)translator).getSchema();
            AvroConverter avroConverter = KsqlAvroSerdeFactory.getAvroConverter((SchemaRegistryClient)srFactory.get(), ksqlConfig, this.properties.getSchemaId(), isKey);
            return new KsqlConnectSerializer(compatibleSchema, translator, (Converter)avroConverter, targetType);
        };
    }

    private <T> Supplier<Deserializer<T>> createConnectDeserializer(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, Optional<Schema> physicalSchema, boolean isKey) {
        return () -> {
            DataTranslator translator = this.createAvroTranslator(schema, physicalSchema, true);
            AvroConverter avroConverter = KsqlAvroSerdeFactory.getAvroConverter((SchemaRegistryClient)srFactory.get(), ksqlConfig, Optional.empty(), isKey);
            return new KsqlConnectDeserializer((Converter)avroConverter, translator, targetType);
        };
    }

    private DataTranslator createAvroTranslator(Schema schema, Optional<Schema> physicalSchema, boolean isDeserializer) {
        return physicalSchema.map(value -> isDeserializer ? new ConnectDataTranslator(schema) : new AvroSRSchemaDataTranslator((Schema)value)).orElseGet(() -> new AvroDataTranslator(schema, this.fullSchemaName));
    }

    private static AvroConverter getAvroConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig, Optional<Integer> schemaId, boolean isKey) {
        AvroConverter avroConverter = new AvroConverter(schemaRegistryClient);
        Map avroConfig = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        avroConfig.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        avroConfig.put("connect.meta.data", true);
        if (schemaId.isPresent()) {
            avroConfig.put("auto.register.schemas", false);
            avroConfig.put("use.schema.id", schemaId.get());
        }
        avroConverter.configure(avroConfig, isKey);
        return avroConverter;
    }
}

