/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.util.KsqlException;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class ConnectSRSchemaDataTranslator
extends ConnectDataTranslator {
    public ConnectSRSchemaDataTranslator(Schema schema) {
        super(schema);
    }

    protected void validate(Schema originalSchema, Schema connectSchema) {
        if (originalSchema.type() != this.getSchema().type()) {
            return;
        }
        if (originalSchema.type() != Schema.Type.STRUCT) {
            return;
        }
        for (Field field : originalSchema.fields()) {
            if (connectSchema.fields().stream().anyMatch(f -> field.name().equals(f.name()))) continue;
            throw new KsqlException("Schema from Schema Registry misses field with name: " + field.name());
        }
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        if (ksqlData instanceof Struct) {
            Schema schema = this.getSchema();
            this.validate(((Struct)ksqlData).schema(), schema);
            Struct struct = new Struct(schema);
            Struct source = (Struct)ksqlData;
            for (Field sourceField : source.schema().fields()) {
                Object value = source.get(sourceField);
                struct.put(sourceField.name(), value);
            }
            return struct;
        }
        return ksqlData;
    }
}

