/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.serde.SerdeFactory;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.DataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.protobuf.ProtobufDataTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRConverter;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRProperties;
import io.confluent.ksql.serde.tls.ThreadLocalDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.data.Schema;

public final class ProtobufNoSRSerdeFactory
implements SerdeFactory {
    private final ProtobufNoSRProperties properties;

    ProtobufNoSRSerdeFactory(ProtobufNoSRProperties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public ProtobufNoSRSerdeFactory(ImmutableMap<String, String> formatProperties) {
        this(new ProtobufNoSRProperties((Map<String, String>)formatProperties));
    }

    @Override
    public <T> Serde<T> createSerde(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        ProtobufNoSRSerdeFactory.validate(schema);
        Supplier serializer = () -> this.createSerializer(schema, targetType, isKey);
        Supplier deserializer = () -> this.createDeserializer(schema, targetType, isKey);
        serializer.get();
        deserializer.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer(serializer), new ThreadLocalDeserializer(deserializer));
    }

    private static void validate(Schema schema) {
        SchemaWalker.visit((Schema)schema, (SchemaWalker.Visitor)new SchemaValidator());
    }

    public <T> KsqlConnectSerializer<T> createSerializer(Schema schema, Class<T> targetType, boolean isKey) {
        ProtobufNoSRConverter converter = this.getConverter(schema, isKey);
        DataTranslator translator = this.getDataTranslator(schema);
        Schema compatibleSchema = translator instanceof ProtobufDataTranslator ? ((ProtobufDataTranslator)translator).getSchema() : ((ConnectDataTranslator)translator).getSchema();
        return new KsqlConnectSerializer<T>(compatibleSchema, translator, converter, targetType);
    }

    private <T> KsqlConnectDeserializer<T> createDeserializer(Schema schema, Class<T> targetType, boolean isKey) {
        return new KsqlConnectDeserializer<T>(this.getConverter(schema, isKey), this.getDataTranslator(schema), targetType);
    }

    private DataTranslator getDataTranslator(Schema schema) {
        return new ConnectDataTranslator(schema);
    }

    private ProtobufNoSRConverter getConverter(Schema schema, boolean isKey) {
        HashMap protobufConfig = new HashMap();
        protobufConfig.putAll(ImmutableMap.of((Object)"wrapper.for.raw.primitives", (Object)this.properties.getUnwrapPrimitives(), (Object)"optional.for.nullables", (Object)this.properties.isNullableAsOptional(), (Object)"wrapper.for.nullables", (Object)this.properties.isNullableAsWrapper()));
        ProtobufNoSRConverter converter = new ProtobufNoSRConverter(schema);
        converter.configure(protobufConfig, isKey);
        return converter;
    }

    private static class SchemaValidator
    implements SchemaWalker.Visitor<Void, Void> {
        private SchemaValidator() {
        }

        public Void visitMap(Schema schema, Void key, Void value) {
            if (schema.keySchema().type() != Schema.Type.STRING) {
                throw new KsqlException("PROTOBUF format only supports MAP types with STRING keys. See https://github.com/confluentinc/ksql/issues/6177.");
            }
            return null;
        }

        public Void visitSchema(Schema schema) {
            return null;
        }
    }
}

