/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AccessControlEntryRecord
implements ApiMessage {
    Uuid id;
    byte resourceType;
    String resourceName;
    byte patternType;
    String principal;
    String host;
    byte operation;
    byte permissionType;
    Uuid clusterLinkId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("id", (Type)Type.UUID, "The unique ID of this ACL."), new Field("resource_type", (Type)Type.INT8, "The resource type."), new Field("resource_name", (Type)Type.COMPACT_STRING, "The resource name."), new Field("pattern_type", (Type)Type.INT8, "The resource name pattern type."), new Field("principal", (Type)Type.COMPACT_STRING, "The principal name."), new Field("host", (Type)Type.COMPACT_STRING, "The host name."), new Field("operation", (Type)Type.INT8, "The AclOperation."), new Field("permission_type", (Type)Type.INT8, "The AclPermissionType."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("cluster_link_id", (Type)Type.UUID, "Cluster link ID to associate with the link if this ACL was migrated from a source cluster by a cluster link.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AccessControlEntryRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public AccessControlEntryRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AccessControlEntryRecord() {
        this.id = Uuid.ZERO_UUID;
        this.resourceType = 0;
        this.resourceName = "";
        this.patternType = 0;
        this.principal = "";
        this.host = "";
        this.operation = 0;
        this.permissionType = 0;
        this.clusterLinkId = Uuid.ZERO_UUID;
    }

    public short apiKey() {
        return 18;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.id = _readable.readUuid();
        this.resourceType = _readable.readByte();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field resourceName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field resourceName had invalid length " + length);
        }
        this.resourceName = _readable.readString(length);
        this.patternType = _readable.readByte();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field principal was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field principal had invalid length " + length);
        }
        this.principal = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field host was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field host had invalid length " + length);
        }
        this.host = _readable.readString(length);
        this.operation = _readable.readByte();
        this.permissionType = _readable.readByte();
        this.clusterLinkId = Uuid.ZERO_UUID;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 10000: {
                    this.clusterLinkId = _readable.readUuid();
                    continue block3;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.id);
        _writable.writeByte(this.resourceType);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.resourceName);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.patternType);
        _stringBytes = _cache.getSerializedValue((Object)this.principal);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.host);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.operation);
        _writable.writeByte(this.permissionType);
        if (!this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, 10000);
        if (!this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(16);
            _writable.writeUuid(this.clusterLinkId);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        _size.addBytes(1);
        byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'resourceName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.resourceName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(1);
        _stringBytes = this.principal.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'principal' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.principal, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'host' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.host, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(1);
        _size.addBytes(1);
        if (!this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(16);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessControlEntryRecord)) {
            return false;
        }
        AccessControlEntryRecord other = (AccessControlEntryRecord)obj;
        if (!this.id.equals((Object)other.id)) {
            return false;
        }
        if (this.resourceType != other.resourceType) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        if (this.patternType != other.patternType) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        if (this.permissionType != other.permissionType) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.id.hashCode();
        hashCode = 31 * hashCode + this.resourceType;
        hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        hashCode = 31 * hashCode + this.patternType;
        hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
        hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
        hashCode = 31 * hashCode + this.operation;
        hashCode = 31 * hashCode + this.permissionType;
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        return hashCode;
    }

    public AccessControlEntryRecord duplicate() {
        AccessControlEntryRecord _duplicate = new AccessControlEntryRecord();
        _duplicate.id = this.id;
        _duplicate.resourceType = this.resourceType;
        _duplicate.resourceName = this.resourceName;
        _duplicate.patternType = this.patternType;
        _duplicate.principal = this.principal;
        _duplicate.host = this.host;
        _duplicate.operation = this.operation;
        _duplicate.permissionType = this.permissionType;
        _duplicate.clusterLinkId = this.clusterLinkId;
        return _duplicate;
    }

    public String toString() {
        return "AccessControlEntryRecord(id=" + this.id.toString() + ", resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ", clusterLinkId=" + this.clusterLinkId.toString() + ")";
    }

    public Uuid id() {
        return this.id;
    }

    public byte resourceType() {
        return this.resourceType;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public byte patternType() {
        return this.patternType;
    }

    public String principal() {
        return this.principal;
    }

    public String host() {
        return this.host;
    }

    public byte operation() {
        return this.operation;
    }

    public byte permissionType() {
        return this.permissionType;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AccessControlEntryRecord setId(Uuid v) {
        this.id = v;
        return this;
    }

    public AccessControlEntryRecord setResourceType(byte v) {
        this.resourceType = v;
        return this;
    }

    public AccessControlEntryRecord setResourceName(String v) {
        this.resourceName = v;
        return this;
    }

    public AccessControlEntryRecord setPatternType(byte v) {
        this.patternType = v;
        return this;
    }

    public AccessControlEntryRecord setPrincipal(String v) {
        this.principal = v;
        return this;
    }

    public AccessControlEntryRecord setHost(String v) {
        this.host = v;
        return this;
    }

    public AccessControlEntryRecord setOperation(byte v) {
        this.operation = v;
        return this;
    }

    public AccessControlEntryRecord setPermissionType(byte v) {
        this.permissionType = v;
        return this;
    }

    public AccessControlEntryRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }
}

