/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.authorizer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.security.AuthObjectType;
import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlBackendAccessValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.security.authorizer.AuthorizationDecisionMaker;
import io.confluent.ksql.security.authorizer.KsqlSchemaRegistryPermissionsValidator;
import io.confluent.security.authorizer.AuthorizeResult;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlAuthorizationProviderImpl
implements KsqlAuthorizationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlAuthorizationProviderImpl.class);
    private static final KsqlAccessValidator KAFKA_BACKEND_VALIDATOR = new KsqlBackendAccessValidator();
    private static final String CONTRIBUTE = "Contribute";
    private static final String TERMINATE = "Terminate";
    private static final Map<String, String> ENDPOINT_OPERATION_MAP = new ImmutableMap.Builder().put((Object)"/ksql/terminate", (Object)"Terminate").build();
    private final AuthorizationDecisionMaker authorizationDecisionMaker;
    private final KsqlAccessValidator kafkaPermissionsValidator;
    private final Optional<KsqlSchemaRegistryPermissionsValidator> schemaRegistryPermissionsValidator;

    public KsqlAuthorizationProviderImpl(AuthorizationDecisionMaker authorizationDecisionMaker, Optional<KsqlSchemaRegistryPermissionsValidator> schemaRegistryPermissionsValidator) {
        this(authorizationDecisionMaker, KAFKA_BACKEND_VALIDATOR, schemaRegistryPermissionsValidator);
    }

    @VisibleForTesting
    KsqlAuthorizationProviderImpl(AuthorizationDecisionMaker authorizationDecisionMaker, KsqlAccessValidator kafkaPermissionsValidator, Optional<KsqlSchemaRegistryPermissionsValidator> schemaRegistryPermissionsValidator) {
        this.authorizationDecisionMaker = authorizationDecisionMaker;
        this.kafkaPermissionsValidator = kafkaPermissionsValidator;
        this.schemaRegistryPermissionsValidator = schemaRegistryPermissionsValidator;
    }

    @VisibleForTesting
    public Optional<KsqlSchemaRegistryPermissionsValidator> getSchemaRegistryPermissionsValidator() {
        return this.schemaRegistryPermissionsValidator;
    }

    public void checkEndpointAccess(Principal principal, String method, String path) {
        if (this.isServerInfoEndpoint(path)) {
            return;
        }
        String operation = ENDPOINT_OPERATION_MAP.getOrDefault(path.toLowerCase(), CONTRIBUTE);
        LOG.debug("Checking authorization for principal '{}' to perform '{}' on endpoint '{}'", new Object[]{principal.getName(), operation, path});
        AuthorizeResult authorizeResult = this.authorizationDecisionMaker.checkAuthorization(principal, "KsqlCluster", "", operation);
        if (authorizeResult != AuthorizeResult.ALLOWED) {
            LOG.warn("User:{} is Denied operation = {} on endpoint = \"{} {}\"", new Object[]{principal.getName(), operation, method, path});
            throw new AuthorizationException("You are forbidden from using this cluster.");
        }
        LOG.info("User:{} is Allowed operation = {} on endpoint = \"{} {}\"", new Object[]{principal.getName(), operation, method, path});
    }

    public void checkPrivileges(KsqlSecurityContext userSecurityContext, AuthObjectType objectType, String objectName, List<AclOperation> privileges) {
        switch (objectType) {
            case TOPIC: {
                privileges.forEach(p -> this.kafkaPermissionsValidator.checkTopicAccess(userSecurityContext, objectName, p));
                break;
            }
            case SUBJECT: {
                this.schemaRegistryPermissionsValidator.ifPresent(validator -> privileges.forEach(p -> validator.checkSubjectAccess(userSecurityContext, objectName, (AclOperation)p)));
                break;
            }
        }
    }

    private boolean isServerInfoEndpoint(String path) {
        return path.equals("/info");
    }
}

