/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.utils;

import com.google.common.collect.ImmutableMap;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.sasl.ConfluentOAuthConfigs;
import io.confluent.ksql.security.DefaultKsqlPrincipal;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.security.Principal;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;

public final class KsqlSecurityUtils {
    private static String principalType(Principal principal) {
        return principal == null ? "null" : principal.getClass().getName();
    }

    public static <T> T toPrincipalType(Principal principal, Class<T> type) {
        if (type.isInstance(principal)) {
            return (T)principal;
        }
        if (principal instanceof DefaultKsqlPrincipal) {
            return KsqlSecurityUtils.toPrincipalType(((DefaultKsqlPrincipal)principal).getOriginalPrincipal(), type);
        }
        throw new KsqlException(String.format("Invalid user principal found. Got: %s Expected: %s.", KsqlSecurityUtils.principalType(principal), type.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getKafkaClusterId(KsqlConfig config) {
        Map adminClientProps = config.getKsqlAdminClientConfigProps();
        try (AdminClient adminClient = AdminClient.create((Map)adminClientProps);){
            String string = (String)adminClient.describeCluster().clusterId().get();
            return string;
        }
        catch (Exception e) {
            throw new KsqlException("Failed to determine Kafka cluster ID", (Throwable)e);
        }
    }

    public static Map<String, Object> getKafkaClientSupplierOAuthProperties(String metadataServerUrl, JwtPrincipal principal) {
        return ImmutableMap.builder().put((Object)"sasl.mechanism", (Object)"OAUTHBEARER").put((Object)"sasl.login.callback.handler.class", (Object)"io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler").put((Object)"sasl.jaas.config", (Object)ConfluentOAuthConfigs.getOAuthBearerLoginModuleJaasConfig((JwtPrincipal)principal, (String)metadataServerUrl)).build();
    }

    public static Map<String, String> getSchemaRegistryClientHttpHeaders(JwtPrincipal principal) {
        return ImmutableMap.builder().put((Object)"Authorization", (Object)("Bearer " + principal.getJwt())).build();
    }
}

