/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.transport;

import io.confluent.auditlog.emitter.errormappers.KafkaTransportException;
import io.confluent.auditlog.emitter.telemetry.NoOpTelemetry;
import io.confluent.auditlog.emitter.telemetry.Telemetry;
import io.confluent.auditlog.emitter.transport.KafkaTransportOptions;
import io.confluent.auditlog.emitter.transport.Transport;
import io.confluent.auditlog.emitter.utils.AuditLoggerUtils;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.exporter.kafka.EventAsyncKafkaExporter;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTransport
implements Transport {
    private static final String FALLBACK_LOGGER = "io.confluent.security.audit.log.fallback";
    private static final Logger fallbackLog = LoggerFactory.getLogger((String)"io.confluent.security.audit.log.fallback");
    private static final Logger log = LoggerFactory.getLogger(KafkaTransport.class);
    private final EventAsyncKafkaExporter eventAsyncKafkaExporter;
    private Telemetry telemetry;
    private String serviceName;

    public KafkaTransport(KafkaTransportOptions params) {
        if (params == null) {
            throw new KafkaTransportException("must provide non-nil params");
        }
        if (params.getConfig() == null) {
            throw new KafkaTransportException("must provide a non-nil config");
        }
        if (StringUtils.isBlank((CharSequence)params.getTopicName())) {
            throw new KafkaTransportException("must provide a topic name");
        }
        this.telemetry = new NoOpTelemetry();
        int topicReplicationFactor = params.getTopicReplicationFactor();
        int topicNumPartitions = params.getTopicNumPartitions();
        if (topicReplicationFactor <= 0) {
            topicReplicationFactor = 3;
        }
        if (topicNumPartitions <= 0) {
            topicNumPartitions = 12;
        }
        HashMap<String, Object> transportConfig = new HashMap<String, Object>(params.getConfig());
        transportConfig.put("topic.name", params.getTopicName());
        transportConfig.put("topic.partitions", topicNumPartitions);
        transportConfig.put("topic.replicas", topicReplicationFactor);
        if (params.getTransportBufferSize() > 0) {
            transportConfig.put("event.queue.size", params.getTransportBufferSize());
        }
        this.eventAsyncKafkaExporter = EventAsyncKafkaExporter.newBuilder(transportConfig).build();
        log.info("Created a kafka producer to transport audit events.");
    }

    @Override
    public void init(Telemetry telemetry, String serviceName) {
        this.telemetry = telemetry;
        this.serviceName = serviceName;
    }

    @Override
    public void log(Event event) {
        log.debug(String.format("[log]: Logging an audit event [id = %s]", event.id()));
        this.telemetry.transportLogCallsCounter.increment("service_name", this.serviceName, "lib", "java");
        this.eventAsyncKafkaExporter.emit((Object)event).whenCompleteAsync((value, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof KafkaException) {
                    log.warn(String.format("[log]: Encountered KafkaException while logging audit event [id = %s]", event.id()), throwable);
                    this.telemetry.transportErrorCounter.increment("error_in", "log", "error_type", "kafka_exception", "service_name", this.serviceName, "lib", "java");
                } else {
                    log.error(String.format("[log]: Encountered unknown error while logging audit event [id = %s]", event.id()), throwable);
                    this.telemetry.transportErrorCounter.increment("error_in", "log", "error_type", "unknown_error", "service_name", this.serviceName, "lib", "java");
                }
                AuditLoggerUtils.logEventInJson(event, fallbackLog);
            }
            if (!value.booleanValue()) {
                AuditLoggerUtils.logEventInJson(event, fallbackLog);
                log.warn(String.format("[log]: Could not log audit event [id = %s]", event.id()));
                this.telemetry.transportErrorCounter.increment("error_in", "log", "error_type", "incomplete_future", "service_name", this.serviceName, "lib", "java");
            } else {
                log.debug(String.format("[log]: Successfully logged audit event [id = %s]", event.id()));
                this.telemetry.transportSuccessCounter.increment("success_in", "log", "service_name", this.serviceName, "lib", "java");
            }
        });
    }

    @Override
    public void close() {
        try {
            this.eventAsyncKafkaExporter.close();
            log.debug("[close]: Successfully closed Kafka exporter");
            this.telemetry.transportSuccessCounter.increment("success_in", "close", "service_name", this.serviceName, "lib", "java");
        }
        catch (Exception e) {
            this.telemetry.transportErrorCounter.increment("error_in", "close", "service_name", this.serviceName, "lib", "java");
            log.error("[close]: Error while closing KafkaExporter - " + e.getMessage());
            throw e;
        }
    }
}

