/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.utils;

import io.confluent.protobuf.events.auditlog.v2.CloudScope;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import java.util.ArrayList;
import java.util.List;

public class CloudResourceBuilder {
    private final List<TypedCloudResourceRef> resources = new ArrayList<TypedCloudResourceRef>();

    public CloudResourceBuilder addResource(TypedCloudResourceRef.ResourceType resourceType, String resourceId, String internalId) {
        this.resources.add(TypedCloudResourceRef.newBuilder().setType(resourceType).setResourceId(resourceId).setInternalId(internalId).build());
        return this;
    }

    public FullyQualifiedCloudResourceRef build() {
        int numResources = this.resources.size();
        if (numResources == 0) {
            return FullyQualifiedCloudResourceRef.getDefaultInstance();
        }
        TypedCloudResourceRef targetResource = this.resources.get(numResources - 1);
        if (numResources == 1) {
            return FullyQualifiedCloudResourceRef.newBuilder().setResource(targetResource).build();
        }
        List<TypedCloudResourceRef> scopeResources = this.resources.subList(0, numResources - 1);
        CloudScope cloudScope = CloudScope.newBuilder().addAllResources(scopeResources).build();
        return FullyQualifiedCloudResourceRef.newBuilder().setScope(cloudScope).setResource(targetResource).build();
    }
}

