/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.utils;

import io.confluent.auditlog.emitter.errormappers.CloudResourceUtilsException;
import io.confluent.auditlog.emitter.utils.CloudResourceBuilder;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.protobuf.events.auditlog.v2.CloudScope;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.authorizer.Scope;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class CloudResourceUtils {
    private static TypedCloudResourceRef.ResourceType getResourceType(String resourceType) throws IllegalArgumentException {
        resourceType = resourceType.replaceAll("-", "_");
        switch (resourceType = resourceType.toUpperCase()) {
            case "KAFKA": {
                return TypedCloudResourceRef.ResourceType.KAFKA_CLUSTER;
            }
            case "KSQL": {
                return TypedCloudResourceRef.ResourceType.KSQL_CLUSTER;
            }
            case "CONNECT": {
                return TypedCloudResourceRef.ResourceType.CONNECT_CLUSTER;
            }
            case "SCHEMA_REGISTRY_CLUSTER": {
                return TypedCloudResourceRef.ResourceType.SCHEMA_REGISTRY;
            }
        }
        return TypedCloudResourceRef.ResourceType.valueOf((String)resourceType);
    }

    public static FullyQualifiedCloudResourceRef BuildCloudResourcesFromCrn(String crn) {
        ConfluentResourceName crnObj;
        try {
            crnObj = ConfluentResourceName.fromString((String)crn);
        }
        catch (CrnSyntaxException e) {
            throw new CloudResourceUtilsException((Exception)((Object)e));
        }
        if (StringUtils.isBlank((CharSequence)crnObj.authority())) {
            throw new CloudResourceUtilsException("authority must be specified in the crn: " + crn);
        }
        CloudResourceBuilder cloudResourceBuilder = new CloudResourceBuilder();
        for (ConfluentResourceName.Element element : crnObj.elements()) {
            TypedCloudResourceRef.ResourceType resourceType;
            try {
                resourceType = CloudResourceUtils.getResourceType(element.resourceType());
            }
            catch (IllegalArgumentException e) {
                throw new CloudResourceUtilsException(String.format("crn: %s contains an invalid resource type: %s", crn, element.resourceType()));
            }
            cloudResourceBuilder.addResource(resourceType, element.encodedResourceName(), "");
        }
        return cloudResourceBuilder.build();
    }

    public static TypedCloudResourceRef getTypedCloudResourceRef(String resourceType, String resourceId) {
        TypedCloudResourceRef.ResourceType type;
        try {
            type = CloudResourceUtils.getResourceType(resourceType);
        }
        catch (IllegalArgumentException e) {
            throw new CloudResourceUtilsException(e.getMessage());
        }
        return TypedCloudResourceRef.newBuilder().setType(type).setResourceId(resourceId).build();
    }

    public static CloudScope scopeToCloudScope(@Nonnull Scope scope) {
        scope.validate();
        CloudScope.Builder cloudScopeBuilder = CloudScope.newBuilder();
        List path = scope.path();
        if (path != null) {
            for (String each : path) {
                String[] element = each.split("=");
                String resourceId = null;
                try {
                    resourceId = URLDecoder.decode(element[1], StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException e) {
                    throw new CloudResourceUtilsException(e);
                }
                cloudScopeBuilder.addResources(CloudResourceUtils.getTypedCloudResourceRef(element[0], resourceId));
            }
        }
        if (scope.clusters() != null) {
            scope.clusters().forEach((k, v) -> cloudScopeBuilder.addResources(CloudResourceUtils.getTypedCloudResourceRef(k, v)));
        }
        return cloudScopeBuilder.build();
    }
}

