/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.utils;

import io.confluent.auditlog.emitter.errormappers.ServiceIdentityException;
import io.confluent.auditlog.emitter.utils.AuditLoggerUtils;
import io.confluent.auditlog.emitter.utils.IdentityParams;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.protobuf.events.auditlog.v2.ServiceLocation;
import java.util.regex.Pattern;
import lombok.NonNull;

public class ServiceIdentity {
    Pattern pattern = Pattern.compile("^[-_a-z0-9]*$");
    private final String serviceNameCrn;
    private final String internalServiceNameCrn;
    private final ServiceLocation serviceLocation;
    private final ConfluentResourceName.Builder intlCrnBuilder = ConfluentResourceName.newBuilder();

    private void checkAndAdd(ResourceParams resourceParam, String resourceValue, ErrorCode error) {
        if (resourceValue == null || resourceValue.equals("")) {
            return;
        }
        if (!this.pattern.matcher(resourceValue).matches()) {
            throw new ServiceIdentityException("service identity param " + (Object)((Object)resourceParam) + " must be dashes, underscores, or lower-case alphanumeric", error);
        }
        try {
            this.intlCrnBuilder.addElement(resourceParam.toString(), resourceValue);
        }
        catch (CrnSyntaxException e) {
            throw new ServiceIdentityException(e.getMessage(), e);
        }
    }

    public ServiceIdentity(@NonNull IdentityParams params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (params.getServiceName().equals("")) {
            throw new ServiceIdentityException("service identity param ServiceName is required", ErrorCode.nil_service_name);
        }
        this.intlCrnBuilder.setAuthority("confluent.cloud");
        String service = params.getServiceName();
        this.checkAndAdd(ResourceParams.service, service, ErrorCode.invalid_service_name);
        String provider = params.getCloudProvider();
        this.checkAndAdd(ResourceParams.cloud, provider, ErrorCode.invalid_cloud_provider);
        String region = params.getRegion();
        this.checkAndAdd(ResourceParams.region, region, ErrorCode.invalid_region);
        this.checkAndAdd(ResourceParams.k8s, params.getKubernetesCluster(), ErrorCode.invalid_kubernetes_cluster);
        this.checkAndAdd(ResourceParams.ns, params.getKubernetesNamespace(), ErrorCode.invalid_kubernetes_namespace);
        this.checkAndAdd(ResourceParams.pod, params.getKubernetesPod(), ErrorCode.invalid_kubernetes_pod);
        ServiceLocation.Builder serviceLocationBuilder = ServiceLocation.newBuilder();
        if (provider != null && !provider.equals("")) {
            serviceLocationBuilder.setProvider(provider);
        }
        if (region != null && !region.equals("")) {
            serviceLocationBuilder.setRegion(region);
        }
        this.serviceLocation = serviceLocationBuilder.build();
        this.serviceNameCrn = AuditLoggerUtils.formalServiceName(service);
        try {
            this.internalServiceNameCrn = this.intlCrnBuilder.build().toString();
        }
        catch (CrnSyntaxException e) {
            throw new ServiceIdentityException(e.getMessage(), e);
        }
    }

    public String getServiceNameCrn() {
        return this.serviceNameCrn;
    }

    public String getInternalServiceNameCrn() {
        return this.internalServiceNameCrn;
    }

    public ServiceLocation getServiceLocation() {
        return this.serviceLocation;
    }

    public static enum ErrorCode {
        nil_service_name,
        invalid_service_name,
        invalid_cloud_provider,
        invalid_region,
        invalid_kubernetes_cluster,
        invalid_kubernetes_namespace,
        invalid_kubernetes_pod;

    }

    private static enum ResourceParams {
        service,
        cloud,
        region,
        k8s,
        ns,
        pod;

    }
}

