/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.kubernetes.client.Exec;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.fault.CloudNetworkFaultSpec;
import org.apache.kafka.trogdor.fault.Kube;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudNetworkFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(CloudNetworkFaultWorker.class);
    private static CoreV1Api k8sCoreApi;
    private final String id;
    private final Map<String, CloudNetworkFaultSpec.NetworkSpec> nodeSpecs;
    private WorkerStatusTracker status;
    private List<K8sLossFault> faults;
    private ApiClient client;
    private Exec exec;

    public CloudNetworkFaultWorker(String id, Map<String, CloudNetworkFaultSpec.NetworkSpec> nodeSpecs) {
        this.id = id;
        this.nodeSpecs = nodeSpecs;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) throws IOException, ApiException, InterruptedException {
        log.info("Activating CloudNetworkFaultWorker {}.", (Object)this.id);
        this.status = status;
        this.status.update((JsonNode)new TextNode("enabling traffic control " + this.id));
        Node curNode = platform.curNode();
        CloudNetworkFaultSpec.NetworkSpec nodeSpec = this.nodeSpecs.get(curNode.name());
        if (nodeSpec != null) {
            this.client = Config.defaultClient();
            Configuration.setDefaultApiClient((ApiClient)this.client);
            k8sCoreApi = new CoreV1Api();
            this.faults = this.createListOfFaultObjects(nodeSpec);
            this.executeOne(this.faults);
            this.status.update((JsonNode)new TextNode("Traffic control enabled " + this.id));
        }
    }

    @Override
    public void stop(Platform platform) throws IOException, ApiException, InterruptedException {
        this.status.update((JsonNode)new TextNode("disabling traffic control " + this.id));
        log.info("Deactivating CloudNetworkFaultWorker {}.", (Object)this.id);
        Node curNode = platform.curNode();
        CloudNetworkFaultSpec.NetworkSpec nodeSpec = this.nodeSpecs.get(curNode.name());
        if (nodeSpec != null) {
            for (K8sLossFault oneFault : this.faults) {
                String srcNamespace = oneFault.srcNamespace;
                String srcPodName = oneFault.srcPodName;
                String networkDevice = oneFault.networkDevice;
                String[] removeTC = new String[]{"tc", "qdisc", "del", "dev", networkDevice, "root"};
                Kube.execute(srcNamespace, srcPodName, removeTC, null, this.exec, false);
            }
        }
        this.status.update((JsonNode)new TextNode("Disabled traffic control " + this.id));
    }

    public List<K8sLossFault> createListOfFaultObjects(CloudNetworkFaultSpec.NetworkSpec faultSpec) throws ApiException {
        log.info("creating fault objects " + this.id);
        ArrayList<K8sLossFault> faultsList = new ArrayList<K8sLossFault>();
        K8sLossFault lossFault = new K8sLossFault(faultSpec.srcNamespace(), faultSpec.srcPodName(), faultSpec.dstNamespace(), faultSpec.dstPodName(), Integer.toString(faultSpec.lossPercentage()), faultSpec.networkDevice());
        faultsList.add(lossFault);
        log.trace("successfully created fault objects " + this.id);
        return faultsList;
    }

    public String getNamespacedPodIp(String namespace, String podName) throws ApiException {
        V1Pod pod = (V1Pod)k8sCoreApi.listNamespacedPod(namespace, null, null, null, "metadata.name=" + podName, null, null, null, null, null, null).getItems().get(0);
        return pod.getStatus().getPodIP();
    }

    public void executeOne(List<K8sLossFault> lossFaults) throws IOException, ApiException, InterruptedException {
        this.exec = new Exec();
        K8sLossFault oneFault = lossFaults.get(0);
        String srcNamespace = oneFault.srcNamespace;
        String srcPodName = oneFault.srcPodName;
        String dstNamespace = oneFault.dstNamespace;
        String dstPodName = oneFault.dstPodName;
        String percentageString = oneFault.lossPercentage + "%";
        log.info("Installing iputils-ping and iproute2 on {}/{}", (Object)srcNamespace, (Object)srcPodName);
        Kube.execute(srcNamespace, srcPodName, new String[]{"apt-get", "update"}, null, this.exec, false);
        Kube.execute(srcNamespace, srcPodName, new String[]{"apt-get", "install", "iputils-ping", "--yes"}, null, this.exec, false);
        Kube.execute(srcNamespace, srcPodName, new String[]{"apt-get", "install", "iproute2", "--yes"}, null, this.exec, false);
        log.info("Installed iputils-ping and iproute2 on {}/{}", (Object)srcNamespace, (Object)srcPodName);
        if (oneFault.toAll()) {
            String[] command = new String[]{"tc", "qdisc", "add", "dev", oneFault.networkDevice, "root", "netem", "loss", percentageString};
            Kube.execute(srcNamespace, srcPodName, command, null, this.exec, false);
            log.info("Injected {} packet loss to all outgoing connections from {}/{}", new Object[]{percentageString, srcNamespace, srcPodName});
        } else {
            String[] command = new String[]{"tc", "qdisc", "add", "dev", "eth0", "root", "handle", "1:", "prio"};
            Kube.execute(srcNamespace, srcPodName, command, null, this.exec, false);
            String ip = this.getNamespacedPodIp(dstNamespace, dstPodName);
            String mask = ip + "/32";
            log.info("Got IP of the destination pod {}/{} - {}", new Object[]{dstNamespace, dstPodName, ip});
            command = new String[]{"tc", "qdisc", "add", "dev", oneFault.networkDevice, "parent", "1:1", "handle", "10:", "netem", "loss", percentageString};
            Kube.execute(srcNamespace, srcPodName, command, null, this.exec, false);
            log.info("Created root of tc tree on {}/{}", (Object)srcPodName, (Object)srcNamespace);
            command = new String[]{"tc", "filter", "add", "dev", oneFault.networkDevice, "protocol", "ip", "parent", "1:0", "prio", "1", "u32", "match", "ip", "dst", mask, "flowid", "1:1"};
            Kube.execute(srcNamespace, srcPodName, command, null, this.exec, false);
            log.info("Injected {} packet loss to outgoing connection from {}/{} to {}/{} - {}", new Object[]{percentageString, srcNamespace, srcPodName, dstNamespace, dstPodName, mask});
        }
    }

    public static class K8sLossFault
    implements Comparable<K8sLossFault> {
        private final String srcNamespace;
        private final String srcPodName;
        private final String dstNamespace;
        private final String dstPodName;
        private final String lossPercentage;
        private final String networkDevice;

        K8sLossFault(String srcNamespace, String srcPodName, String dstNamespace, String dstPodName, String lossPercentage, String networkDevice) throws ApiException {
            this.srcPodName = srcPodName;
            this.srcNamespace = srcNamespace;
            this.dstPodName = dstPodName;
            this.dstNamespace = dstNamespace;
            this.lossPercentage = lossPercentage;
            this.networkDevice = networkDevice;
        }

        public boolean toAll() {
            return this.dstNamespace.equals("all");
        }

        @Override
        public int compareTo(K8sLossFault other) {
            String src = this.srcNamespace + this.srcPodName;
            String dst = this.dstNamespace + this.dstPodName;
            String otherSrc = other.srcNamespace + other.srcPodName;
            String otherDst = other.dstNamespace + other.dstPodName;
            int cmpSrc = src.compareTo(otherSrc);
            return cmpSrc < 0 ? cmpSrc : dst.compareTo(otherDst);
        }
    }
}

