/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Shell;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.RestProxyProduceV3CurlWorkloadSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestProxyProduceV3CurlWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(RestProxyProduceV3CurlWorker.class);
    private static final Time TIME = Time.SYSTEM;
    public static final List<String> MESSAGE_TYPES = Collections.unmodifiableList(Arrays.asList("BINARY", "JSON"));
    public static final ObjectMapper RESPONSE_OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String STREAMING_PROCESS_TYPE = "STREAMING";
    public static final String NON_STREAMING_PROCESS_TYPE = "NON_STREAMING";
    private final String id;
    private final RestProxyProduceV3CurlWorkloadSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    volatile List<RestProxyProduceV3Process> clientProcesses;

    public RestProxyProduceV3CurlWorker(String id, RestProxyProduceV3CurlWorkloadSpec spec) {
        this.id = Objects.requireNonNull(id);
        this.spec = Objects.requireNonNull(spec);
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException(this + " is already running");
        }
        log.info("{}: Activating with {}", (Object)this, (Object)this.spec);
        try {
            this.validateConfigs();
        }
        catch (ConfigException e) {
            WorkerUtils.abort(log, this.toString(), e, doneFuture);
        }
        try {
            this.status = status;
            this.doneFuture = doneFuture;
            this.workerExecutor = Executors.newSingleThreadExecutor(ThreadUtils.createThreadFactory((String)"RestProxyWorker%d", (boolean)false));
            this.workerExecutor.submit(new ProcessCoordinator());
            this.statusUpdaterExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
            this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.workerExecutor.shutdown();
            this.workerExecutor = null;
            this.statusUpdaterExecutor.shutdown();
            this.statusUpdaterExecutor = null;
            WorkerUtils.abort(log, this.toString(), e, doneFuture);
        }
    }

    private void validateConfigs() {
        if (this.spec.targetCallsPerSec() <= 0) {
            throw new ConfigException("Can't have targetCallsPerSec <= 0.");
        }
        if (this.spec.restProxyUrl() == null || this.spec.restProxyUrl().length() == 0) {
            throw new ConfigException("restProxyUrl can't be empty.");
        }
        if (this.spec.numMessages() <= 0L) {
            throw new ConfigException("Can't have numMessages <= 0.");
        }
        if (this.spec.numClients() <= 0) {
            throw new ConfigException("Can't have numClients <= 0.");
        }
        if (this.spec.messageSize() < 1) {
            throw new ConfigException("Can't have messageSize < 1.");
        }
        if (!MESSAGE_TYPES.contains(this.spec.messageType())) {
            throw new ConfigException("Unknown message type: " + this.spec.messageType());
        }
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException(this + " is not running.");
        }
        log.info("{}: Deactivating", (Object)this);
        this.doneFuture.complete((Object)"");
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        this.statusUpdaterExecutor = null;
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        new StatusUpdater().run();
        this.workerExecutor = null;
        this.doneFuture = null;
        log.info("{}: Deactivated.", (Object)this);
    }

    public String toString() {
        return String.format("RestProxyProduceV3Worker{id='%s'}", this.id);
    }

    protected RestProxyProduceV3Process startStreamingProcess(String[] execCmd) throws IOException {
        String clientId = UUID.randomUUID().toString();
        RestProxyProduceV3StreamingProcess currentProcess = new RestProxyProduceV3StreamingProcess(clientId, execCmd);
        return currentProcess;
    }

    protected RestProxyProduceV3Process startProcess(String[] execCmd) throws IOException {
        String clientId = UUID.randomUUID().toString();
        RestProxyProduceV3NonStreamingProcess currentProcess = new RestProxyProduceV3NonStreamingProcess(clientId, execCmd);
        return currentProcess;
    }

    private static File createTempFile(String prefix, String name) throws IOException {
        File tempFile = File.createTempFile(prefix, name);
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private final Process process;
        private final AtomicBoolean completed;

        public ShellTimeoutTimerTask(Process process, AtomicBoolean completed) {
            this.process = process;
            this.completed = completed;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.process.exitValue();
                }
                catch (Exception e) {
                    if (this.process == null || this.completed.get()) break block2;
                    this.process.destroy();
                }
            }
        }
    }

    private static class ProduceResponse {
        @JsonProperty(value="offset")
        private long offset = -1L;
        @JsonProperty(value="error_code")
        private int errorCode = -1;

        private ProduceResponse() {
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }
    }

    private class RestProxyProduceV3NonStreamingProcess
    extends RestProxyProduceV3Process {
        public RestProxyProduceV3NonStreamingProcess(String clientId, String[] execString) {
            this.clientId = clientId;
            this.completed = new AtomicBoolean(false);
            this.execString = execString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean produce(String message) throws IOException, InterruptedException {
            String[] processArgs = Arrays.copyOf(this.execString, this.execString.length + 1);
            File tempFile = null;
            if (RestProxyProduceV3CurlWorker.this.spec.messageSize() > 100000) {
                tempFile = RestProxyProduceV3CurlWorker.createTempFile(UUID.randomUUID().toString(), String.valueOf(message.length()));
                Files.write(tempFile.toPath(), message.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                processArgs[this.execString.length] = "@" + tempFile.getPath();
            } else {
                processArgs[this.execString.length] = message;
            }
            ProcessBuilder builder = new ProcessBuilder(processArgs);
            for (Reader reader : Arrays.asList(this.errReader, this.outReader)) {
                if (reader == null) continue;
                reader.close();
            }
            for (Thread thread : Arrays.asList(this.errThread, this.outThread)) {
                if (thread == null) continue;
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.process = builder.start();
                this.errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));
                this.outReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
                this.errThread = ReaderThreadProvider.getStderrReader(this.errReader, this.toString(), this.clientId, this.completed);
                this.outThread = ReaderThreadProvider.getStdoutReader(this.outReader, this.toString(), this.clientId, this.completed, this.responses, this.responseStartTimeMs, this.responseEndTimeMs, this.failedCalls, this.completedCalls);
                this.process.waitFor(10000L, TimeUnit.MILLISECONDS);
                try {
                    this.errThread.join();
                }
                catch (InterruptedException ie) {
                    log.warn(this + " errThread interrupted while reading stream", (Throwable)ie);
                }
                try {
                    this.outThread.join();
                }
                catch (InterruptedException ie) {
                    log.warn(this + " outThread interrupted while reading stream", (Throwable)ie);
                }
            }
            catch (Throwable t) {
                log.error("Error processing workload", t);
            }
            finally {
                this.errThread.interrupt();
                this.outThread.interrupt();
                try {
                    this.errReader.close();
                }
                catch (IOException ioe) {
                    log.warn(this + " error while closing stream", (Throwable)ioe);
                }
                try {
                    this.outReader.close();
                }
                catch (IOException ioe) {
                    log.warn(this + " error while closing stream", (Throwable)ioe);
                }
                if (tempFile != null && !tempFile.delete()) {
                    log.error("Error deleting temporary message file: {}", (Object)tempFile.getPath());
                }
            }
            return this.process.exitValue() == 0;
        }

        @Override
        public void run() {
            try {
                int perPeriod = WorkerUtils.perSecToPerPeriod(RestProxyProduceV3CurlWorker.this.spec.targetCallsPerSec(), RestProxyProduceV3CurlWorker.this.spec.throttlePeriodMs());
                Throttle throttle = new Throttle(perPeriod, RestProxyProduceV3CurlWorker.this.spec.throttlePeriodMs());
                this.submissionsStartTimeMs.set(TIME.milliseconds());
                for (long messageCounter = 0L; messageCounter < RestProxyProduceV3CurlWorker.this.spec.numMessages(); ++messageCounter) {
                    String message = MessageProvider.getMessage(RestProxyProduceV3CurlWorker.this.spec.messageType(), RestProxyProduceV3CurlWorker.this.spec.messageSize());
                    boolean success = this.produce(message);
                    if (!success) {
                        this.failedCalls.getAndIncrement();
                    }
                    this.submittedCalls.getAndIncrement();
                    throttle.increment();
                }
                this.submissionEndTimeMs.set(TIME.milliseconds());
                this.completeProcess();
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, this.toString(), e, (KafkaFutureImpl<String>)RestProxyProduceV3CurlWorker.this.doneFuture);
            }
        }

        protected void completeProcess() {
            this.completed.set(true);
        }

        public String toString() {
            return String.format("RestProxyProduceV3Process{clientId='%s'}", this.clientId);
        }
    }

    private class RestProxyProduceV3StreamingProcess
    extends RestProxyProduceV3Process {
        private BufferedWriter inWriter;
        private Timer timeoutTimer;
        private final long processStartTime;

        public RestProxyProduceV3StreamingProcess(String clientId, String[] execString) throws IOException {
            this.timeoutTimer = new Timer();
            this.clientId = clientId;
            this.completed = new AtomicBoolean(false);
            this.execString = execString;
            this.processStartTime = TIME.milliseconds();
            this.establishConnection();
        }

        private void establishConnection() throws IOException {
            ProcessBuilder builder = new ProcessBuilder(this.execString);
            for (Reader reader : Arrays.asList(this.errReader, this.outReader)) {
                if (reader == null) continue;
                reader.close();
                Object var3_5 = null;
            }
            if (this.inWriter != null) {
                this.inWriter.close();
                this.inWriter = null;
            }
            for (Thread thread : Arrays.asList(this.errThread, this.outThread)) {
                if (thread != null) {
                    thread.interrupt();
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Object var3_8 = null;
            }
            this.process = builder.start();
            this.timeoutTimer.cancel();
            this.timeoutTimer = null;
            this.timeoutTimer = new Timer();
            this.timeoutTimer.schedule((TimerTask)new ShellTimeoutTimerTask(this.process, this.completed), Math.min(Duration.ofHours(1L).toMillis(), this.processStartTime + RestProxyProduceV3CurlWorker.this.spec.durationMs() - TIME.milliseconds()));
            this.errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));
            this.outReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
            this.inWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), StandardCharsets.UTF_8));
            this.errThread = ReaderThreadProvider.getStderrReader(this.errReader, this.toString(), this.clientId, this.completed);
            this.outThread = ReaderThreadProvider.getStdoutReader(this.outReader, this.toString(), this.clientId, this.completed, this.responses, this.responseStartTimeMs, this.responseEndTimeMs, this.failedCalls, this.completedCalls);
        }

        @Override
        public void run() {
            try {
                int perPeriod = WorkerUtils.perSecToPerPeriod(RestProxyProduceV3CurlWorker.this.spec.targetCallsPerSec(), RestProxyProduceV3CurlWorker.this.spec.throttlePeriodMs());
                Throttle throttle = new Throttle(perPeriod, RestProxyProduceV3CurlWorker.this.spec.throttlePeriodMs());
                this.submissionsStartTimeMs.set(TIME.milliseconds());
                for (long messageCounter = 0L; messageCounter < RestProxyProduceV3CurlWorker.this.spec.numMessages(); ++messageCounter) {
                    String message = MessageProvider.getMessage(RestProxyProduceV3CurlWorker.this.spec.messageType(), RestProxyProduceV3CurlWorker.this.spec.messageSize());
                    boolean success = this.produce(message);
                    if (!success) {
                        this.failedCalls.getAndIncrement();
                    }
                    this.submittedCalls.getAndIncrement();
                    throttle.increment();
                }
                this.submissionEndTimeMs.set(TIME.milliseconds());
                Throttle graceThrottle = new Throttle(1, 1000);
                for (int i = 0; i < RestProxyProduceV3CurlWorker.this.spec.responseGracePeriodSeconds(); ++i) {
                    this.inWriter.write("\n");
                    this.inWriter.flush();
                    graceThrottle.increment();
                }
                this.completeProcess();
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, this.toString(), e, (KafkaFutureImpl<String>)RestProxyProduceV3CurlWorker.this.doneFuture);
            }
        }

        private boolean produce(String message) {
            try {
                if (!this.process.isAlive()) {
                    this.establishConnection();
                }
                this.inWriter.write(message);
                this.inWriter.flush();
            }
            catch (IOException e) {
                log.info(this + " could not produce", (Throwable)e);
                return false;
            }
            return true;
        }

        protected void completeProcess() {
            try {
                this.completed.set(true);
                this.process.destroy();
                try {
                    this.errThread.join();
                }
                catch (InterruptedException ie) {
                    log.warn(this + " errThread interrupted while reading stream", (Throwable)ie);
                }
                try {
                    this.outThread.join();
                }
                catch (InterruptedException ie) {
                    log.warn(this + " outThread interrupted while reading stream", (Throwable)ie);
                }
            }
            finally {
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.cancel();
                }
                if (!this.completed.get()) {
                    this.errThread.interrupt();
                    this.outThread.interrupt();
                }
                try {
                    this.errReader.close();
                }
                catch (IOException ioe) {
                    log.warn(this + " error while closing stream", (Throwable)ioe);
                }
                try {
                    this.outReader.close();
                }
                catch (IOException ioe) {
                    log.warn(this + " error while closing stream", (Throwable)ioe);
                }
                try {
                    this.inWriter.close();
                }
                catch (IOException ioe) {
                    log.warn(this + " error while closing stream", (Throwable)ioe);
                }
            }
        }

        public String toString() {
            return String.format("RestProxyProduceV3StreamingProcess{clientId='%s'}", this.clientId);
        }
    }

    private abstract class RestProxyProduceV3Process
    implements Runnable {
        String[] execString;
        String clientId;
        Process process;
        BufferedReader errReader;
        BufferedReader outReader;
        Thread errThread;
        Thread outThread;
        AtomicBoolean completed;
        AtomicLong submissionsStartTimeMs = new AtomicLong(-1L);
        AtomicLong submissionEndTimeMs = new AtomicLong(-1L);
        AtomicLong responseStartTimeMs = new AtomicLong(-1L);
        AtomicLong responseEndTimeMs = new AtomicLong(-1L);
        AtomicLong submittedCalls = new AtomicLong();
        AtomicLong responses = new AtomicLong();
        AtomicLong completedCalls = new AtomicLong();
        AtomicLong failedCalls = new AtomicLong();

        private RestProxyProduceV3Process() {
        }
    }

    private static class MessageProvider {
        private static final Random RNG = new Random();
        private static final String MESSAGE_TEMPLATE = "{ \"value\" : { \"type\" : \"%s\", \"data\" : \"%s\" }}\n";

        private MessageProvider() {
        }

        private static String getMessage(String messageType, int messageSize) {
            if (messageType.equals("BINARY")) {
                byte[] array = new byte[messageSize];
                RNG.nextBytes(array);
                return String.format(MESSAGE_TEMPLATE, "BINARY", Base64.getEncoder().encodeToString(array));
            }
            if (messageType.equals("JSON")) {
                String value = RNG.ints(97, 123).limit(messageSize).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                return String.format(MESSAGE_TEMPLATE, "JSON", value);
            }
            return "";
        }
    }

    private static class ReaderThreadProvider {
        private ReaderThreadProvider() {
        }

        private static Thread getStderrReader(BufferedReader reader, String processDescription, String clientId, AtomicBoolean completed) {
            KafkaThread errThread = KafkaThread.nonDaemon((String)("kafka-rest-produce-err-thread-" + clientId), () -> {
                try {
                    String line = reader.readLine();
                    while (line != null && !Thread.currentThread().isInterrupted() && !completed.get()) {
                        log.error(processDescription + " clientid: " + clientId + " curl stderr:" + line);
                        line = reader.readLine();
                    }
                }
                catch (IOException ioe) {
                    log.warn(processDescription + " Error reading stderr", (Throwable)ioe);
                }
            });
            errThread.start();
            return errThread;
        }

        private static Thread getStdoutReader(BufferedReader reader, String processDescription, String clientId, AtomicBoolean completed, AtomicLong responses, AtomicLong responseStartTimeMs, AtomicLong responseEndTimeMs, AtomicLong failedCalls, AtomicLong completedCalls) {
            KafkaThread outThread = KafkaThread.nonDaemon((String)("kafka-rest-produce-out-thread-" + clientId), () -> {
                try {
                    String line = reader.readLine();
                    while (line != null && !Thread.currentThread().isInterrupted() && !completed.get()) {
                        log.trace(line);
                        responses.getAndIncrement();
                        if (responseStartTimeMs.get() == -1L) {
                            responseStartTimeMs.set(TIME.milliseconds());
                        }
                        responseEndTimeMs.set(TIME.milliseconds());
                        ProduceResponse response = (ProduceResponse)RESPONSE_OBJECT_MAPPER.readValue(line, ProduceResponse.class);
                        if (response.errorCode != 200) {
                            failedCalls.getAndIncrement();
                        }
                        if (response.offset != -1L) {
                            completedCalls.getAndIncrement();
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException ioe) {
                    log.warn(processDescription + " error reading stdout", (Throwable)ioe);
                }
            });
            outThread.start();
            return outThread;
        }
    }

    public static class StatusData {
        private final long totalSubmittedCalls;
        private final long totalCompletedCalls;
        private final long totalFailedCalls;
        private final long submissionStartTime;
        private final long submissionEndTime;
        private final long responseStartTime;
        private final long responseEndTime;
        private final double submissionsPerSec;
        private final double responsesPerSec;
        private final String restProxyUrl;

        @JsonCreator
        StatusData(@JsonProperty(value="restProxyUrl") String restProxyUrl, @JsonProperty(value="responseEndTime") long responseEndTime, @JsonProperty(value="responsesPerSec") double responsesPerSec, @JsonProperty(value="responseStartTime") long responseStartTime, @JsonProperty(value="submissionEndTime") long submissionEndTime, @JsonProperty(value="submissionsPerSec") double submissionsPerSec, @JsonProperty(value="submissionStartTime") long submissionStartTime, @JsonProperty(value="totalCompletedCalls") long totalCompletedCalls, @JsonProperty(value="totalFailedCalls") long totalFailedCalls, @JsonProperty(value="totalSubmittedCalls") long totalSubmittedCalls) {
            this.restProxyUrl = restProxyUrl;
            this.totalSubmittedCalls = totalSubmittedCalls;
            this.totalCompletedCalls = totalCompletedCalls;
            this.totalFailedCalls = totalFailedCalls;
            this.submissionsPerSec = submissionsPerSec;
            this.submissionStartTime = submissionStartTime;
            this.submissionEndTime = submissionEndTime;
            this.responseStartTime = responseStartTime;
            this.responseEndTime = responseEndTime;
            this.responsesPerSec = responsesPerSec;
        }

        @JsonProperty
        public String restProxyUrl() {
            return this.restProxyUrl;
        }

        @JsonProperty
        public long totalSubmittedCalls() {
            return this.totalSubmittedCalls;
        }

        @JsonProperty
        public long totalCompletedCalls() {
            return this.totalCompletedCalls;
        }

        @JsonProperty
        public long totalFailedCalls() {
            return this.totalFailedCalls;
        }

        @JsonProperty
        public double submissionsPerSec() {
            return this.submissionsPerSec;
        }

        @JsonProperty
        public long submissionStartTime() {
            return this.submissionStartTime;
        }

        @JsonProperty
        public long submissionEndTime() {
            return this.submissionEndTime;
        }

        @JsonProperty
        public long responseStartTime() {
            return this.responseStartTime;
        }

        @JsonProperty
        public long responseEndTime() {
            return this.responseEndTime;
        }

        @JsonProperty
        public double responsesPerSec() {
            return this.responsesPerSec;
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                if (RestProxyProduceV3CurlWorker.this.clientProcesses == null || RestProxyProduceV3CurlWorker.this.clientProcesses.isEmpty()) {
                    return;
                }
                long minSubmissionTime = Long.MAX_VALUE;
                long maxSubmissionTime = -1L;
                long minResponseTime = Long.MAX_VALUE;
                long maxResponseTime = -1L;
                long totalSubmittedCalls = 0L;
                long totalResponses = 0L;
                long completedCalls = 0L;
                long failedCalls = 0L;
                for (RestProxyProduceV3Process process : RestProxyProduceV3CurlWorker.this.clientProcesses) {
                    minSubmissionTime = Math.min(process.submissionsStartTimeMs.get(), minSubmissionTime);
                    maxSubmissionTime = Math.max(process.submissionEndTimeMs.get(), maxSubmissionTime);
                    minResponseTime = Math.min(process.responseStartTimeMs.get(), minResponseTime);
                    maxResponseTime = Math.max(process.responseEndTimeMs.get(), maxResponseTime);
                    totalSubmittedCalls += process.submittedCalls.get();
                    totalResponses += process.responses.get();
                    completedCalls += process.completedCalls.get();
                    failedCalls += process.failedCalls.get();
                }
                long submissionLastTimeMs = maxSubmissionTime == -1L ? Time.SYSTEM.milliseconds() : maxSubmissionTime;
                long responseLastTimeMs = maxResponseTime == -1L ? Time.SYSTEM.milliseconds() : maxResponseTime;
                JsonNode node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(RestProxyProduceV3CurlWorker.this.spec.restProxyUrl(), maxResponseTime, (double)totalResponses * 1000.0 / (double)(responseLastTimeMs - minResponseTime), minResponseTime, maxSubmissionTime, (double)totalSubmittedCalls * 1000.0 / (double)(submissionLastTimeMs - minSubmissionTime), minSubmissionTime, completedCalls, failedCalls, totalSubmittedCalls));
                RestProxyProduceV3CurlWorker.this.status.update(node);
            }
            catch (Exception e) {
                log.warn(this + " failed to update status, this will be retried", (Throwable)e);
            }
        }

        public String toString() {
            return "StatusUpdater{}";
        }
    }

    class ProcessCoordinator
    implements Runnable {
        ProcessCoordinator() {
        }

        @Override
        public void run() {
            try {
                this.setup();
                ArrayList processThreads = new ArrayList();
                RestProxyProduceV3CurlWorker.this.clientProcesses = Collections.unmodifiableList(IntStream.range(0, RestProxyProduceV3CurlWorker.this.spec.numClients()).mapToObj(index -> {
                    try {
                        if (RestProxyProduceV3CurlWorker.this.spec.processType().equals(RestProxyProduceV3CurlWorker.STREAMING_PROCESS_TYPE)) {
                            log.info("Creating Streaming process");
                            RestProxyProduceV3Process process = RestProxyProduceV3CurlWorker.this.startStreamingProcess(this.getStreamingCommand());
                            Thread processThread = new Thread(process);
                            processThread.start();
                            processThreads.add(processThread);
                            return process;
                        }
                        if (RestProxyProduceV3CurlWorker.this.spec.processType().equals(RestProxyProduceV3CurlWorker.NON_STREAMING_PROCESS_TYPE)) {
                            log.info("Creating Non Streaming process");
                            RestProxyProduceV3Process process = RestProxyProduceV3CurlWorker.this.startProcess(this.getNonStreamingCommand());
                            Thread processThread = new Thread(process);
                            processThread.start();
                            processThreads.add(processThread);
                            return process;
                        }
                    }
                    catch (IOException e) {
                        WorkerUtils.abort(log, this.toString(), e, (KafkaFutureImpl<String>)RestProxyProduceV3CurlWorker.this.doneFuture);
                    }
                    return null;
                }).filter(process -> process != null).collect(Collectors.toList()));
                for (Thread runningProcess : processThreads) {
                    runningProcess.join();
                }
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, this.toString(), e, (KafkaFutureImpl<String>)RestProxyProduceV3CurlWorker.this.doneFuture);
            }
            RestProxyProduceV3CurlWorker.this.doneFuture.complete((Object)"");
        }

        private String[] getStreamingCommand() {
            String url = String.format("%s/v3/clusters/%s/topics/%s/records", RestProxyProduceV3CurlWorker.this.spec.restProxyUrl(), RestProxyProduceV3CurlWorker.this.spec.clusterId(), RestProxyProduceV3CurlWorker.this.spec.topicName());
            ArrayList<String> commandArgs = new ArrayList<String>();
            commandArgs.addAll(Arrays.asList("curl", "-s", "-N", "-X", "POST", "-H", "Content-Type: application/json", "-H", "Transfer-Encoding: chunked"));
            if (!RestProxyProduceV3CurlWorker.this.spec.userCredential().isEmpty()) {
                commandArgs.addAll(Arrays.asList("-u", RestProxyProduceV3CurlWorker.this.spec.userCredential()));
            }
            commandArgs.addAll(Arrays.asList(url, "-T-"));
            return commandArgs.toArray(new String[0]);
        }

        private String[] getNonStreamingCommand() {
            String url = String.format("%s/v3/clusters/%s/topics/%s/records", RestProxyProduceV3CurlWorker.this.spec.restProxyUrl(), RestProxyProduceV3CurlWorker.this.spec.clusterId(), RestProxyProduceV3CurlWorker.this.spec.topicName());
            ArrayList<String> commandArgs = new ArrayList<String>();
            commandArgs.addAll(Arrays.asList("curl", "-s", "-N", "-X", "POST", "-H", "Content-Type: application/json"));
            if (!RestProxyProduceV3CurlWorker.this.spec.userCredential().isEmpty()) {
                commandArgs.addAll(Arrays.asList("-u", RestProxyProduceV3CurlWorker.this.spec.userCredential()));
            }
            commandArgs.addAll(Arrays.asList(url, "-d"));
            return commandArgs.toArray(new String[0]);
        }

        private void setup() throws IOException {
            log.info(this + " Creating topic {} with replication factor {}  and {} partitions.", new Object[]{RestProxyProduceV3CurlWorker.this.spec.topicName(), RestProxyProduceV3CurlWorker.this.spec.numReplicas(), RestProxyProduceV3CurlWorker.this.spec.numPartitions()});
            Shell.execCommand((String[])this.getTopicCreateCommand());
        }

        private String[] getTopicCreateCommand() throws JsonProcessingException {
            String url = String.format("%s/v3/clusters/%s/topics", RestProxyProduceV3CurlWorker.this.spec.restProxyUrl(), RestProxyProduceV3CurlWorker.this.spec.clusterId());
            HashMap<String, String> topicRequestElements = new HashMap<String, String>(){
                {
                    this.put("topic_name", RestProxyProduceV3CurlWorker.this.spec.topicName());
                    if (RestProxyProduceV3CurlWorker.this.spec.numPartitions() != -1) {
                        this.put("partitions_count", String.valueOf(RestProxyProduceV3CurlWorker.this.spec.numPartitions()));
                    }
                    if (RestProxyProduceV3CurlWorker.this.spec.numReplicas() != -1) {
                        this.put("replication_factor", String.valueOf(RestProxyProduceV3CurlWorker.this.spec.numReplicas()));
                    }
                }
            };
            String topicRequest = new ObjectMapper().writeValueAsString((Object)topicRequestElements);
            ArrayList<String> commandArgs = new ArrayList<String>();
            commandArgs.addAll(Arrays.asList("curl", "-X", "POST", "-H", "Content-Type:application/json", "-d", topicRequest));
            if (!RestProxyProduceV3CurlWorker.this.spec.userCredential().isEmpty()) {
                commandArgs.addAll(Arrays.asList("-u", RestProxyProduceV3CurlWorker.this.spec.userCredential()));
            }
            commandArgs.add(url);
            return commandArgs.toArray(new String[0]);
        }

        public String toString() {
            return "ProcessCoordinator{}";
        }
    }
}

