/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.RestProxyProduceV3CurlWorker;

public class RestProxyProduceV3CurlWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String restProxyUrl;
    private final String clusterId;
    private final String topicName;
    private final int numPartitions;
    private final int numReplicas;
    private final long numMessages;
    private final int numClients;
    private final int messageSize;
    private final String messageType;
    private final int targetCallsPerSec;
    private final int responseGracePeriodSeconds;
    private final int throttlePeriodMs;
    private final String userCredential;
    private final String processType;

    @JsonCreator
    public RestProxyProduceV3CurlWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="restProxyUrl") String restProxyUrl, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="numPartitions") int numPartitions, @JsonProperty(value="numReplicas") int numReplicas, @JsonProperty(value="numMessages") long numMessages, @JsonProperty(value="numClients") int numClients, @JsonProperty(value="messageSize") int messageSize, @JsonProperty(value="messageType") String messageType, @JsonProperty(value="targetCallsPerSec") int targetCallsPerSec, @JsonProperty(value="responseGracePeriodSeconds") int responseGracePeriodSeconds, @JsonProperty(value="throttlePeriodMs") int throttlePeriodMs, @JsonProperty(value="userCredential") String userCredential, @JsonProperty(value="processType") String processType) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.restProxyUrl = restProxyUrl;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.numMessages = numMessages;
        this.numClients = numClients;
        this.messageSize = messageSize;
        this.targetCallsPerSec = targetCallsPerSec;
        this.numPartitions = numPartitions;
        this.numReplicas = numReplicas;
        this.messageType = messageType;
        this.responseGracePeriodSeconds = responseGracePeriodSeconds;
        this.throttlePeriodMs = throttlePeriodMs;
        this.userCredential = userCredential == null ? "" : userCredential;
        this.processType = processType;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public int targetCallsPerSec() {
        return this.targetCallsPerSec;
    }

    @JsonProperty
    public long numMessages() {
        return this.numMessages;
    }

    @JsonProperty
    public int numClients() {
        return this.numClients;
    }

    @JsonProperty
    public int messageSize() {
        return this.messageSize;
    }

    @JsonProperty
    public String messageType() {
        return this.messageType;
    }

    @JsonProperty
    public String clusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public String topicName() {
        return this.topicName;
    }

    @JsonProperty
    public String restProxyUrl() {
        return this.restProxyUrl;
    }

    @JsonProperty
    public int numPartitions() {
        return this.numPartitions;
    }

    @JsonProperty
    public int numReplicas() {
        return this.numReplicas;
    }

    @JsonProperty
    public int responseGracePeriodSeconds() {
        return this.responseGracePeriodSeconds;
    }

    @JsonProperty
    public int throttlePeriodMs() {
        return this.throttlePeriodMs;
    }

    @JsonProperty
    public String userCredential() {
        return this.userCredential;
    }

    @JsonProperty
    public String processType() {
        return this.processType;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new RestProxyProduceV3CurlWorker(id, this);
    }
}

