/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizerNotReadyException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.AclCache;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthorizerData {
    public static final String WILDCARD = "*";
    public static final String WILDCARD_PRINCIPAL = "User:*";
    public static final KafkaPrincipal WILDCARD_KAFKA_PRINCIPAL = new KafkaPrincipal("User", "*");
    final Logger log;
    final Logger auditLog;
    final AclMutator aclMutator;
    final boolean loadingComplete;
    private final Set<String> superUsers;
    private final DefaultRule noAclRule;
    private volatile AclCache aclCache;
    private static final Set<AclOperation> IMPLIES_DESCRIBE = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER));
    private static final Set<AclOperation> IMPLIES_DESCRIBE_CONFIGS = Collections.unmodifiableSet(EnumSet.of(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));

    private static Logger createLogger(int nodeId) {
        return new LogContext("[StandardAuthorizer " + nodeId + "] ").logger(StandardAuthorizerData.class);
    }

    private static Logger auditLogger() {
        return LoggerFactory.getLogger((String)"kafka.authorizer.logger");
    }

    static StandardAuthorizerData createEmpty() {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(-1), null, false, Collections.emptySet(), AuthorizationResult.DENIED, new AclCache());
    }

    private StandardAuthorizerData(Logger log, AclMutator aclMutator, boolean loadingComplete, Set<String> superUsers, AuthorizationResult defaultResult, AclCache aclCache) {
        this.log = log;
        this.auditLog = StandardAuthorizerData.auditLogger();
        this.aclMutator = aclMutator;
        this.loadingComplete = loadingComplete;
        this.superUsers = superUsers;
        this.noAclRule = new DefaultRule(defaultResult);
        this.aclCache = aclCache;
    }

    StandardAuthorizerData copyWithNewAclMutator(AclMutator newAclMutator) {
        return new StandardAuthorizerData(this.log, newAclMutator, this.loadingComplete, this.superUsers, this.noAclRule.result, this.aclCache);
    }

    StandardAuthorizerData copyWithNewLoadingComplete(boolean newLoadingComplete) {
        return new StandardAuthorizerData(this.log, this.aclMutator, newLoadingComplete, this.superUsers, this.noAclRule.result, this.aclCache);
    }

    StandardAuthorizerData copyWithNewConfig(int nodeId, Set<String> newSuperUsers, AuthorizationResult newDefaultResult) {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(nodeId), this.aclMutator, this.loadingComplete, newSuperUsers, newDefaultResult, this.aclCache);
    }

    StandardAuthorizerData copyWithNewAcls(AclCache aclCache) {
        StandardAuthorizerData newData = new StandardAuthorizerData(this.log, this.aclMutator, this.loadingComplete, this.superUsers, this.noAclRule.result, aclCache);
        this.log.info("Initialized with {} acl(s).", (Object)aclCache.count());
        return newData;
    }

    void addAcl(Uuid id, ConfluentStandardAcl acl) {
        try {
            ConfluentStandardAcl prevAcl = this.aclCache.getAcl(id);
            AclCache aclCachesSnapshot = this.aclCache;
            if (prevAcl != null) {
                if (prevAcl.equals(acl)) {
                    throw new RuntimeException("Same ACL with ID " + id + " already exists.");
                }
                aclCachesSnapshot = this.aclCache.removeAcl(id);
            }
            this.aclCache = aclCachesSnapshot.addAcl(id, acl);
            this.log.trace("Added ACL {}: {}", (Object)id, (Object)acl);
        }
        catch (Throwable e) {
            this.log.error("addAcl error", e);
            throw e;
        }
    }

    void removeAcl(Uuid id) {
        try {
            AclCache aclCacheSnapshot = this.aclCache.removeAcl(id);
            this.log.trace("Removed ACL {}: {}", (Object)id, (Object)this.aclCache.getAcl(id));
            this.aclCache = aclCacheSnapshot;
        }
        catch (Throwable e) {
            this.log.error("removeAcl error", e);
            throw e;
        }
    }

    Set<String> superUsers() {
        return this.superUsers;
    }

    AuthorizationResult defaultResult() {
        return this.noAclRule.result;
    }

    int aclCount() {
        return this.aclCache.count();
    }

    public AuthorizationResult authorize(AuthorizableRequestContext requestContext, Action action) {
        MatchingRule rule;
        if (action.resourcePattern().patternType() != PatternType.LITERAL) {
            throw new IllegalArgumentException("Only literal resources are supported. Got: " + action.resourcePattern().patternType());
        }
        KafkaPrincipal principal = StandardAuthorizerData.baseKafkaPrincipal(requestContext);
        if (this.superUsers.contains(principal.toString())) {
            rule = SuperUserRule.INSTANCE;
        } else {
            if (!this.loadingComplete) {
                throw new AuthorizerNotReadyException();
            }
            rule = this.findAclRule(StandardAuthorizerData.matchingPrincipals(requestContext), requestContext.clientAddress().getHostAddress(), action);
        }
        this.logAuditMessage(principal, requestContext, action, rule);
        return rule.result();
    }

    public List<StandardAcl> findRulesByResourceType(ResourceType resourceType, AclOperation operation, Set<KafkaPrincipal> matchingPrincipals, String host) {
        StandardAcl exemplar = new StandardAcl(resourceType, "", PatternType.UNKNOWN, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        ArrayList<StandardAcl> matchingAcls = new ArrayList<StandardAcl>();
        for (KafkaPrincipal principal : matchingPrincipals) {
            for (SortedSet acls : Arrays.asList(this.aclCache.allowAclsByPrincipal(principal), this.aclCache.denyAclsByPrincipal(principal))) {
                matchingAcls.addAll(this.findRuleByResourceType(acls, resourceType, operation, host, exemplar));
            }
        }
        return matchingAcls;
    }

    private List<StandardAcl> findRuleByResourceType(SortedSet<StandardAcl> acls, ResourceType resourceType, AclOperation operation, String host, StandardAcl exemplar) {
        StandardAcl candidateAcl;
        ArrayList<StandardAcl> matchingAcls = new ArrayList<StandardAcl>();
        SortedSet<StandardAcl> candidateAcls = acls.headSet(exemplar);
        Iterator iterator = candidateAcls.iterator();
        while (iterator.hasNext() && (candidateAcl = (StandardAcl)iterator.next()).resourceType() == resourceType) {
            if (candidateAcl.operation() != AclOperation.ALL && candidateAcl.operation() != operation || !candidateAcl.host().equals(WILDCARD) && !candidateAcl.host().equals(host)) continue;
            matchingAcls.add(candidateAcl);
        }
        return matchingAcls;
    }

    private String buildAuditMessage(KafkaPrincipal principal, AuthorizableRequestContext context, Action action, MatchingRule rule) {
        StringBuilder bldr = new StringBuilder();
        bldr.append("Principal = ").append(principal);
        bldr.append(" is ").append(rule.result() == AuthorizationResult.ALLOWED ? "Allowed" : "Denied");
        bldr.append(" operation = ").append(action.operation());
        bldr.append(" from host = ").append(context.clientAddress().getHostAddress());
        bldr.append(" on resource = ");
        this.appendResourcePattern(action.resourcePattern(), bldr);
        bldr.append(" for request = ").append(ApiKeys.forId((int)context.requestType()).name);
        bldr.append(" with resourceRefCount = ").append(action.resourceReferenceCount());
        bldr.append(" based on rule ").append(rule);
        return bldr.toString();
    }

    private void appendResourcePattern(ResourcePattern resourcePattern, StringBuilder bldr) {
        bldr.append(SecurityUtils.resourceTypeName((ResourceType)resourcePattern.resourceType())).append(":").append(resourcePattern.patternType()).append(":").append(resourcePattern.name());
    }

    private void logAuditMessage(KafkaPrincipal principal, AuthorizableRequestContext requestContext, Action action, MatchingRule rule) {
        switch (rule.result()) {
            case ALLOWED: {
                if (action.logIfAllowed() && this.auditLog.isDebugEnabled()) {
                    this.auditLog.debug(this.buildAuditMessage(principal, requestContext, action, rule));
                } else if (this.auditLog.isTraceEnabled()) {
                    this.auditLog.trace(this.buildAuditMessage(principal, requestContext, action, rule));
                }
                return;
            }
            case DENIED: {
                if (action.logIfDenied()) {
                    this.auditLog.info(this.buildAuditMessage(principal, requestContext, action, rule));
                    break;
                }
                if (!this.auditLog.isTraceEnabled()) break;
                this.auditLog.trace(this.buildAuditMessage(principal, requestContext, action, rule));
            }
        }
    }

    public MatchingRule findAclRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        AclCache aclCachesSnapshot = this.aclCache;
        MatchingRuleBuilder matchingRuleBuilder = new MatchingRuleBuilder(this.noAclRule);
        this.checkDenySection(aclCachesSnapshot, action, matchingPrincipals, host, matchingRuleBuilder);
        if (matchingRuleBuilder.foundDeny()) {
            return matchingRuleBuilder.build();
        }
        this.checkAllowSection(aclCachesSnapshot, action, matchingPrincipals, host, matchingRuleBuilder);
        if (!matchingRuleBuilder.hasAclsForResource) {
            matchingRuleBuilder.hasAclsForResource = this.checkAclsForResource(aclCachesSnapshot, action.resourcePattern());
        }
        return matchingRuleBuilder.build();
    }

    private List<StandardAcl> aclMatchingPatternForAction(Action action) {
        StandardAcl initialLiteralAndPrefixExemplar = new StandardAcl(action.resourcePattern().resourceType(), action.resourcePattern().name(), PatternType.UNKNOWN, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        StandardAcl wildcardExemplar = new StandardAcl(action.resourcePattern().resourceType(), WILDCARD, PatternType.LITERAL, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
        return Arrays.asList(initialLiteralAndPrefixExemplar, wildcardExemplar);
    }

    static int matchesUpTo(String resource, String pattern) {
        int i;
        for (i = 0; resource.length() != i && pattern.length() != i && resource.charAt(i) == pattern.charAt(i); ++i) {
        }
        return i;
    }

    private void checkDenySection(AclCache aclCache, Action action, Set<KafkaPrincipal> matchingPrincipals, String host, MatchingRuleBuilder matchingRuleBuilder) {
        KafkaPrincipal matchingPrincipal;
        SortedSet<StandardAcl> aclSet;
        Iterator<KafkaPrincipal> iterator = matchingPrincipals.iterator();
        while (iterator.hasNext() && !this.checkSection(aclSet = aclCache.denyAclsByPrincipal(matchingPrincipal = iterator.next()), action, host, matchingRuleBuilder)) {
        }
    }

    private void checkAllowSection(AclCache aclCache, Action action, Set<KafkaPrincipal> matchingPrincipals, String host, MatchingRuleBuilder matchingRuleBuilder) {
        KafkaPrincipal matchingPrincipal;
        SortedSet<StandardAcl> aclSet;
        Iterator<KafkaPrincipal> iterator = matchingPrincipals.iterator();
        while (iterator.hasNext() && !this.checkSection(aclSet = aclCache.allowAclsByPrincipal(matchingPrincipal = iterator.next()), action, host, matchingRuleBuilder)) {
        }
    }

    private boolean checkAclsForResource(AclCache aclCaches, ResourcePattern resourcePattern) {
        MatchingRuleBuilder mrb = new MatchingRuleBuilder(this.noAclRule);
        this.checkSection(aclCaches.allAcls(), Action.anyActionForResourcePattern((ResourcePattern)resourcePattern), WILDCARD, mrb);
        return mrb.hasAclsForResource;
    }

    private boolean checkSection(SortedSet<StandardAcl> aclSet, Action action, String host, MatchingRuleBuilder matchingRuleBuilder) {
        List<StandardAcl> aclExemplars = this.aclMatchingPatternForAction(action);
        String resourceName = action.resourcePattern().name();
        for (StandardAcl exemplar : aclExemplars) {
            StandardAcl acl;
            SortedSet<StandardAcl> tailSet = aclSet.tailSet(exemplar);
            Iterator iterator = tailSet.iterator();
            while (iterator.hasNext() && (acl = (StandardAcl)iterator.next()).resourceType().equals((Object)action.resourcePattern().resourceType())) {
                int matchesUpTo = StandardAuthorizerData.matchesUpTo(resourceName, acl.resourceName());
                if (matchesUpTo == acl.resourceName().length()) {
                    if (acl.patternType() == PatternType.LITERAL && matchesUpTo != resourceName.length()) {
                        continue;
                    }
                } else if (!acl.resourceName().equals(WILDCARD) || acl.patternType() != PatternType.LITERAL) {
                    exemplar = new StandardAcl(exemplar.resourceType(), exemplar.resourceName().substring(0, matchesUpTo), exemplar.patternType(), exemplar.principal(), exemplar.host(), exemplar.operation(), exemplar.permissionType());
                    tailSet = aclSet.tailSet(exemplar);
                    iterator = tailSet.iterator();
                    continue;
                }
                matchingRuleBuilder.hasAclsForResource = true;
                AuthorizationResult result = StandardAuthorizerData.findResult(action, host, acl);
                if (AuthorizationResult.ALLOWED == result) {
                    matchingRuleBuilder.allowAcl = acl;
                    return true;
                }
                if (AuthorizationResult.DENIED != result) continue;
                matchingRuleBuilder.denyAcl = acl;
                return true;
            }
        }
        return false;
    }

    boolean validateAclMaps() {
        return this.aclCache.validateAclCache();
    }

    static AuthorizationResult findResult(Action action, AuthorizableRequestContext requestContext, StandardAcl acl) {
        return StandardAuthorizerData.findResult(action, StandardAuthorizerData.matchingPrincipals(requestContext), requestContext.clientAddress().getHostAddress(), acl);
    }

    static KafkaPrincipal baseKafkaPrincipal(AuthorizableRequestContext context) {
        KafkaPrincipal sessionPrincipal = context.principal();
        return sessionPrincipal.getClass().equals(KafkaPrincipal.class) ? sessionPrincipal : new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName());
    }

    static Set<KafkaPrincipal> matchingPrincipals(AuthorizableRequestContext context) {
        KafkaPrincipal sessionPrincipal = context.principal();
        KafkaPrincipal basePrincipal = sessionPrincipal.getClass().equals(KafkaPrincipal.class) ? sessionPrincipal : new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName());
        return Utils.mkSet((Object[])new KafkaPrincipal[]{basePrincipal, WILDCARD_KAFKA_PRINCIPAL});
    }

    static AuthorizationResult findResult(Action action, Set<KafkaPrincipal> matchingPrincipals, String host, StandardAcl acl) {
        if (!matchingPrincipals.contains(acl.kafkaPrincipal())) {
            return null;
        }
        return StandardAuthorizerData.findResult(action, host, acl);
    }

    static AuthorizationResult findResult(Action action, String host, StandardAcl acl) {
        block9: {
            block10: {
                if (!acl.host().equals(WILDCARD) && !acl.host().equals(host)) {
                    return null;
                }
                if (acl.operation() == AclOperation.ALL || action.operation() == AclOperation.ANY) break block9;
                if (!acl.permissionType().equals((Object)AclPermissionType.ALLOW)) break block10;
                switch (action.operation()) {
                    case DESCRIBE: {
                        if (!IMPLIES_DESCRIBE.contains(acl.operation())) {
                            return null;
                        }
                        break block9;
                    }
                    case DESCRIBE_CONFIGS: {
                        if (!IMPLIES_DESCRIBE_CONFIGS.contains(acl.operation())) {
                            return null;
                        }
                        break block9;
                    }
                    default: {
                        if (action.operation() != acl.operation()) {
                            return null;
                        }
                        break block9;
                    }
                }
            }
            if (action.operation() != acl.operation()) {
                return null;
            }
        }
        return acl.permissionType().equals((Object)AclPermissionType.ALLOW) ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    Iterable<AclBinding> acls(AclBindingFilter filter) {
        AclCache aclCachesSnapshot = this.aclCache;
        return aclCachesSnapshot.acls(filter);
    }

    void clear() {
        this.aclCache = this.aclCache.clear();
        this.superUsers.clear();
    }

    AclCache getAclCache() {
        return this.aclCache;
    }

    public static class AclLinks {
        final StandardAcl acl;
        final Set<Uuid> linkIds;

        public AclLinks(StandardAcl acl, Set<Uuid> linkIds) {
            this.acl = acl;
            this.linkIds = Collections.unmodifiableSet(linkIds);
        }

        public AclLinks copyAndAddLinkId(Optional<Uuid> linkId) {
            if (this.linkIds.contains(linkId.orElse(Uuid.ZERO_UUID))) {
                throw new IllegalStateException("aclsByResource already contains " + linkId + " for " + this.acl);
            }
            HashSet<Uuid> linkIds = new HashSet<Uuid>(this.linkIds);
            linkIds.add(linkId.orElse(Uuid.ZERO_UUID));
            return new AclLinks(this.acl, Collections.unmodifiableSet(linkIds));
        }

        public AclLinks copyAndRemoveLinkId(Optional<Uuid> linkId) {
            if (!this.linkIds.contains(linkId.orElse(Uuid.ZERO_UUID))) {
                throw new RuntimeException("Link ID for ACL " + this.acl + " not found in aclsByResource");
            }
            HashSet<Uuid> newLinkIds = new HashSet<Uuid>(this.linkIds);
            newLinkIds.remove(linkId.orElse(Uuid.ZERO_UUID));
            return new AclLinks(this.acl, Collections.unmodifiableSet(newLinkIds));
        }

        public boolean isEmpty() {
            return this.linkIds.isEmpty();
        }

        public Collection<Uuid> aclBindingLinksIds() {
            ArrayList<Uuid> copy = new ArrayList<Uuid>(this.linkIds);
            if (copy.size() == 1 && ((Uuid)copy.get(0)).equals((Object)Uuid.ZERO_UUID)) {
                return Collections.emptyList();
            }
            return copy;
        }
    }

    private static class MatchingRuleBuilder {
        private static final DefaultRule DENY_RULE = new DefaultRule(AuthorizationResult.DENIED);
        private final DefaultRule noAclRule;
        private StandardAcl denyAcl;
        private StandardAcl allowAcl;
        private boolean hasAclsForResource;

        private MatchingRuleBuilder(DefaultRule noAclRule) {
            this.noAclRule = noAclRule;
        }

        boolean foundDeny() {
            return this.denyAcl != null;
        }

        MatchingRule build() {
            if (this.denyAcl != null) {
                return new MatchingAclRule(this.denyAcl, AuthorizationResult.DENIED);
            }
            if (this.allowAcl != null) {
                return new MatchingAclRule(this.allowAcl, AuthorizationResult.ALLOWED);
            }
            if (!this.hasAclsForResource) {
                return this.noAclRule;
            }
            return DENY_RULE;
        }
    }

    public static class MatchingAclRule
    implements MatchingRule {
        private final StandardAcl acl;
        private final AuthorizationResult result;

        public MatchingAclRule(StandardAcl acl, AuthorizationResult result) {
            this.acl = acl;
            this.result = result;
        }

        public StandardAcl acl() {
            return this.acl;
        }

        @Override
        public AuthorizationResult result() {
            return this.result;
        }

        public String toString() {
            return "MatchingAcl(acl=" + this.acl + ")";
        }
    }

    public static class DefaultRule
    implements MatchingRule {
        private final AuthorizationResult result;

        public DefaultRule(AuthorizationResult result) {
            this.result = result;
        }

        @Override
        public AuthorizationResult result() {
            return this.result;
        }

        public String toString() {
            return this.result == AuthorizationResult.ALLOWED ? "DefaultAllow" : "DefaultDeny";
        }
    }

    public static class SuperUserRule
    implements MatchingRule {
        private static final SuperUserRule INSTANCE = new SuperUserRule();

        @Override
        public AuthorizationResult result() {
            return AuthorizationResult.ALLOWED;
        }

        public String toString() {
            return "SuperUser";
        }
    }

    public static interface MatchingRule {
        public AuthorizationResult result();
    }
}

