/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public final class JwtIssuerKey
extends AuthKey {
    private final String issuer;
    private final String providerId;

    public JwtIssuerKey(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="providerId") String providerId) {
        this.issuer = Objects.requireNonNull(issuer, "Argument `issuer` must not be null");
        this.providerId = providerId;
    }

    public JwtIssuerKey(String issuer) {
        this(issuer, null);
    }

    @JsonProperty
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty
    public String providerId() {
        return this.providerId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.JWT_ISSUER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtIssuerKey that = (JwtIssuerKey)o;
        return this.issuer.equals(that.issuer) && Objects.equals(this.providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.issuer, this.providerId);
    }

    public String toString() {
        return String.format("JwtIssuerKey{\n\tissuer=%s,\n\tproviderId=%s\n}", this.issuer, this.providerId);
    }

    public String cacheKey() {
        return JwtIssuerKey.cacheKey(this.providerId, this.issuer);
    }

    public static String cacheKey(String providerId, String issuer) {
        if (providerId == null || providerId.trim().equals("")) {
            return issuer;
        }
        return providerId;
    }
}

