/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.test.model.KsqlVersion;
import io.confluent.ksql.test.tools.VersionBounds;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionBoundsNode {
    private final Optional<KsqlVersion> min;
    private final Optional<KsqlVersion> max;

    public VersionBoundsNode(@JsonProperty(value="min") Optional<String> min, @JsonProperty(value="max") Optional<String> max) {
        this.min = Objects.requireNonNull(min, "min").map(KsqlVersion::parse);
        this.max = Objects.requireNonNull(max, "max").map(KsqlVersion::parse);
    }

    static VersionBoundsNode allVersions() {
        return new VersionBoundsNode(Optional.empty(), Optional.empty());
    }

    public VersionBounds build() {
        return VersionBounds.of(this.min, this.max);
    }
}

