/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools.command;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.Required;
import io.confluent.ksql.tools.test.command.TestOptionsParser;
import java.io.IOException;
import java.util.Optional;

@Command(name="ksql-test-runner", description="The KSQL testing tool")
public class TestOptions {
    @Once
    @Option(name={"--input-file", "-i"}, description="A JSON file containing the input records.")
    private String inputFile;
    @Required
    @Once
    @Option(name={"--output-file", "-o"}, description="A JSON file containing the expected output records.")
    private String outputFile;
    @Required
    @Once
    @Option(name={"--sql-file", "-s"}, description="A SQL file containing KSQL statements to be tested.")
    private String statementsFile;
    @Once
    @Option(name={"--extension-dir", "-e"}, description="A directory containing extensions.")
    private String extensionDir;

    public static TestOptions parse(String ... args) throws IOException {
        return (TestOptions)TestOptionsParser.parse((String[])args, TestOptions.class);
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getStatementsFile() {
        return this.statementsFile;
    }

    public Optional<String> getExtensionDir() {
        return Optional.ofNullable(this.extensionDir);
    }
}

