/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools.exceptions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

@SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"})
public class KsqlExpectedException {
    public final List<Matcher<?>> matchers = new ArrayList();

    public static KsqlExpectedException none() {
        return new KsqlExpectedException();
    }

    public void expect(Class<? extends Throwable> type) {
        this.matchers.add(CoreMatchers.instanceOf(type));
    }

    public void expect(Matcher<?> matcher) {
        this.matchers.add(matcher);
    }

    public void expectMessage(String substring) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)substring));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.matchers.add(UnloggedMessageMatcher.hasMessage(matcher));
    }

    public Matcher<Throwable> build() {
        return CoreMatchers.allOf(new ArrayList(this.matchers));
    }

    public static class UnloggedMessageMatcher<T extends Throwable>
    extends TypeSafeMatcher<T> {
        private final Matcher<String> matcher;

        public UnloggedMessageMatcher(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("exception with message or unloggedDetails ");
            description.appendDescriptionOf(this.matcher);
        }

        protected boolean matchesSafely(T item) {
            boolean matches = this.matcher.matches((Object)((Throwable)item).getMessage());
            return matches || item instanceof KsqlStatementException && this.matcher.matches((Object)((KsqlStatementException)((Object)item)).getUnloggedMessage());
        }

        protected void describeMismatchSafely(T item, Description description) {
            description.appendText("message ");
            this.matcher.describeMismatch((Object)((Throwable)item).getMessage(), description);
            if (item instanceof KsqlStatementException) {
                description.appendText("unloggedDetails ");
                this.matcher.describeMismatch((Object)((KsqlStatementException)((Object)item)).getUnloggedMessage(), description);
            }
        }

        @Factory
        public static <T extends Throwable> Matcher<T> hasMessage(Matcher<String> matcher) {
            return new UnloggedMessageMatcher<T>(matcher);
        }
    }
}

