/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestDataJsonConverter;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePartitionsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(CreatePartitionsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        CreatePartitionsRequestData createPartitionsRequestData = CreatePartitionsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        CreatePartitionsResponseData createPartitionsResponseData = CreatePartitionsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean validateOnly = createPartitionsRequestData.validateOnly();
        for (CreatePartitionsRequestData.CreatePartitionsTopic createPartitionsTopic : createPartitionsRequestData.topics()) {
            String topicName = createPartitionsTopic.name();
            CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult = CreatePartitionsRequestAuditExtractor.creatableTopicResult(createPartitionsResponseData, topicName);
            boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(createPartitionsTopicResult.errorCode());
            Struct requestData = CreatePartitionsRequestAuditExtractor.requestData(createPartitionsTopic, requestEvent, validateOnly);
            Result.Status status = CreatePartitionsRequestAuditExtractor.status(createPartitionsTopicResult);
            Struct resultData = CreatePartitionsRequestAuditExtractor.resultData(createPartitionsTopicResult);
            List<TypedCloudResourceRef> typedCloudResourceRefList = CreatePartitionsRequestAuditExtractor.typedCloudResourceRefList(requestEvent, topicName);
            ResourcePattern resourcePattern = new ResourcePattern("Topic", topicName, PatternType.LITERAL);
            String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
            AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
            extractedAuditLogs.add(auditLog);
        }
        return extractedAuditLogs;
    }

    private static CreatePartitionsResponseData.CreatePartitionsTopicResult creatableTopicResult(CreatePartitionsResponseData createPartitionsResponseData, String topicName) {
        for (CreatePartitionsResponseData.CreatePartitionsTopicResult result : createPartitionsResponseData.results()) {
            if (!topicName.equals(result.name())) continue;
            return result;
        }
        throw new IllegalStateException("Missing creatableTopicResult result for topicName " + topicName);
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.TOPIC).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(CreatePartitionsRequestData.CreatePartitionsTopic creatableTopic, KafkaRequestEvent requestEvent, boolean validateOnly) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)CreatePartitionsRequestDataJsonConverter.CreatePartitionsTopicJsonConverter.write((CreatePartitionsRequestData.CreatePartitionsTopic)creatableTopic, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)validateOnly));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult) {
        if (createPartitionsTopicResult.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(createPartitionsTopicResult.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(createPartitionsTopicResult.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)createPartitionsTopicResult.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

