/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class UtcTimeSyntaxChecker
extends SyntaxChecker {
    private static final String UTC_TIME_PATTERN = "^\\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])([0-5]\\d)(([0-5]\\d)?(Z|([+-]([01]\\d|2[0-3])[0-5]\\d))?)$";
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])([01]\\d|2[0-3])([0-5]\\d)(([0-5]\\d)?(Z|([+-]([01]\\d|2[0-3])[0-5]\\d))?)$");
    public static final UtcTimeSyntaxChecker INSTANCE = new UtcTimeSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.53");

    private UtcTimeSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() < 11) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        boolean result = DATE_PATTERN.matcher(strValue).find();
        if (result) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<UtcTimeSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.53");
        }

        @Override
        public UtcTimeSyntaxChecker build() {
            return new UtcTimeSyntaxChecker(this.oid);
        }
    }
}

