/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import com.yammer.metrics.core.MetricName;
import io.confluent.security.auth.cloud.CloudAuthCache;
import io.confluent.security.auth.dataplane.DataplaneAuthReader;
import io.confluent.security.auth.dataplane.DataplaneAuthWriter;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.LatencyRecordKey;
import io.confluent.security.auth.store.data.LatencyRecordValue;
import io.confluent.security.auth.utils.AuthStoreMetrics;
import io.confluent.security.auth.utils.MetricsUtils;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.ConsumerListener;
import io.confluent.security.store.kafka.clients.DeserializationErrorHandlingJsonSerde;
import io.confluent.security.store.kafka.clients.JsonSerde;
import io.confluent.security.store.kafka.clients.StatusListener;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataplaneBaseAuthStore
implements AuthStore,
ConsumerListener<AuthKey, AuthValue> {
    protected static final Logger log = LoggerFactory.getLogger(DataplaneBaseAuthStore.class);
    private static final String METRIC_TYPE = DataplaneBaseAuthStore.class.getSimpleName();
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    private final AbstractAuthCache authCache;
    private final JsonSerde<AuthKey> keySerde;
    private final JsonSerde<AuthValue> valueSerde;
    private final Set<MetricName> metricNames;
    private final AuthStoreMetrics authStoreMetrics;
    private final LatencyRecordListener latencyRecordListener;
    protected KafkaStoreConfig clientConfig;
    protected final Time time;
    protected final int numAuthTopicPartitions;
    protected final StoreStatusListener statusListener;
    protected String sessionUuid;
    protected DataplaneAuthReader<AuthKey, AuthValue> reader;

    protected DataplaneBaseAuthStore(RbacRoles rbacRoles, Time time, Scope scope, Metrics metrics, int numAuthTopicPartitions) {
        this.authCache = new CloudAuthCache(rbacRoles, scope);
        this.time = time;
        this.numAuthTopicPartitions = numAuthTopicPartitions;
        this.statusListener = new StoreStatusListener();
        this.keySerde = DataplaneBaseAuthStore.keySerde();
        this.valueSerde = DataplaneBaseAuthStore.valueSerde();
        this.authStoreMetrics = new AuthStoreMetrics(metrics, this.authCache);
        this.metricNames = new HashSet<MetricName>();
        this.metricNames.add(MetricsUtils.newGauge("confluent.metadata", METRIC_TYPE, "reader-failure-start-seconds-ago", Collections.emptyMap(), this.statusListener::secondsAfterReaderFailure));
        this.latencyRecordListener = new LatencyRecordListener();
    }

    public static JsonSerde<AuthKey> keySerde() {
        return DeserializationErrorHandlingJsonSerde.serde(AuthKey.class, true, DeserializerErrorForKey::new);
    }

    public static JsonSerde<AuthValue> valueSerde() {
        return DeserializationErrorHandlingJsonSerde.serde(AuthValue.class, false, DeserializerErrorForValue::new);
    }

    public AbstractAuthCache authCache() {
        return this.authCache;
    }

    public AbstractAuthCache trustCache() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has not been started for this store");
        }
        return this.authCache;
    }

    public CompletionStage<Void> startReader() {
        return this.reader.start(this.clientConfig.topicCreateTimeout);
    }

    public CompletionStage<Void> startService(Collection<URL> nodeUrls) {
        return CompletableFuture.completedFuture(null);
    }

    public AuthWriter writer() {
        return new DataplaneAuthWriter();
    }

    public boolean isMasterWriter() {
        return false;
    }

    public URL masterWriterUrl(String protocol) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Integer masterWriterId() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void close() {
        log.debug("Closing DataplaneBaseAuthStore");
        this.close(CLOSE_TIMEOUT);
    }

    private void close(Duration closeTimeout) {
        Throwable exception = null;
        if (this.reader != null) {
            try {
                this.reader.close(closeTimeout);
            }
            catch (Throwable e) {
                exception = e;
            }
            this.reader = null;
        }
        MetricsUtils.removeMetrics(this.metricNames);
        if (exception != null) {
            throw new KafkaException("Failed to close DataplaneBaseAuthStore", exception);
        }
        AuthStore.removeInstance((String)this.sessionUuid, (AuthStore)this, (Logger)log);
    }

    @Override
    public void onConsumerRecord(ConsumerRecord<AuthKey, AuthValue> record, AuthValue oldValue) {
        if (((AuthKey)record.key()).entryType() != null) {
            this.authStoreMetrics.recordsProcessedSensors.get(((AuthKey)record.key()).entryType()).record();
        }
        if (record.key() instanceof LatencyRecordKey && this.existingPartitionRecordsRead(new TopicPartition(record.topic(), record.partition()))) {
            this.latencyRecordListener.onLatencyRecord((LatencyRecordKey)record.key(), (LatencyRecordValue)record.value());
        }
    }

    protected boolean existingPartitionRecordsRead(TopicPartition topicPartition) {
        return this.reader.existingRecordsFuture(topicPartition).isDone() && !this.reader.existingRecordsFuture(topicPartition).isCancelled() && !this.reader.existingRecordsFuture(topicPartition).isCompletedExceptionally();
    }

    protected Consumer<AuthKey, AuthValue> createConsumer(Map<String, Object> configs) {
        return new KafkaConsumer(configs, this.keySerde.deserializer(), this.valueSerde.deserializer());
    }

    public static class DeserializerErrorForValue
    extends AuthValue {
        private final DeserializationErrorHandlingJsonSerde.DeserializationError error;

        public DeserializerErrorForValue(DeserializationErrorHandlingJsonSerde.DeserializationError error) {
            this.error = error;
        }

        public DeserializationErrorHandlingJsonSerde.DeserializationError error() {
            return this.error;
        }

        public AuthEntryType entryType() {
            return null;
        }

        public String toString() {
            return "DeserializerErrorForValue{error=" + this.error + '}';
        }
    }

    public static class DeserializerErrorForKey
    extends AuthKey {
        private final DeserializationErrorHandlingJsonSerde.DeserializationError error;

        public DeserializerErrorForKey(DeserializationErrorHandlingJsonSerde.DeserializationError error) {
            this.error = error;
        }

        public DeserializationErrorHandlingJsonSerde.DeserializationError error() {
            return this.error;
        }

        public AuthEntryType entryType() {
            return null;
        }

        public String toString() {
            return "DeserializerErrorForKey{error=" + this.error + '}';
        }
    }

    private class StoreStatusListener
    implements StatusListener {
        private final AtomicLong readerFailureStartMs = new AtomicLong(0L);

        StoreStatusListener() {
        }

        long secondsAfterReaderFailure() {
            return MetricsUtils.elapsedSeconds(DataplaneBaseAuthStore.this.time, this.readerFailureStartMs.get());
        }

        @Override
        public void onReaderSuccess() {
            this.readerFailureStartMs.set(0L);
        }

        @Override
        public boolean onReaderFailure() {
            this.readerFailureStartMs.compareAndSet(0L, DataplaneBaseAuthStore.this.time.milliseconds());
            return this.failed(this.readerFailureStartMs.get());
        }

        @Override
        public void onWriterSuccess(int partition) {
        }

        @Override
        public boolean onWriterFailure(int partition) {
            return false;
        }

        @Override
        public void onProduceSuccess(int partition) {
        }

        @Override
        public void onProduceFailure(int partition) {
        }

        @Override
        public void onRemoteSuccess(int partition) {
        }

        @Override
        public boolean onRemoteFailure(int partition) {
            return false;
        }

        private boolean failed(Long firstFailureMs) {
            if (firstFailureMs == null) {
                return false;
            }
            return DataplaneBaseAuthStore.this.time.milliseconds() > firstFailureMs + DataplaneBaseAuthStore.this.clientConfig.retryTimeout.toMillis();
        }
    }

    private class LatencyRecordListener {
        private final Map<String, Long> latencyRecordLastSeenByApp = new HashMap<String, Long>();

        LatencyRecordListener() {
        }

        protected synchronized Long secondsAfterLastLatencyRecordSeen(String app) {
            Long lastSeenMs = this.latencyRecordLastSeenByApp.getOrDefault(app, -1L);
            return lastSeenMs == -1L ? -1L : TimeUnit.MILLISECONDS.toSeconds(DataplaneBaseAuthStore.this.time.milliseconds() - lastSeenMs);
        }

        public synchronized void onLatencyRecord(LatencyRecordKey latencyRecordKey, LatencyRecordValue latencyRecordValue) {
            long currentTimeMs = DataplaneBaseAuthStore.this.time.milliseconds();
            this.latencyRecordLastSeenByApp.put(latencyRecordKey.app(), currentTimeMs);
            DataplaneBaseAuthStore.this.authStoreMetrics.registerLatencyGauge(latencyRecordKey.app(), () -> this.secondsAfterLastLatencyRecordSeen(latencyRecordKey.app()));
            DataplaneBaseAuthStore.this.authStoreMetrics.recordLatencyMetric(latencyRecordKey, currentTimeMs - latencyRecordValue.timestamp());
        }
    }
}

