/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import java.util.Map;
import javax.net.SocketFactory;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.HostSslSocketFactory;
import org.apache.kafka.common.security.ssl.SslFactory;

public class ConfigurableSslSocketFactory
extends HostSslSocketFactory {
    private static volatile DefaultSslFactoryConfig defaultSslFactoryConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void overrideDefaultSslFactoryConfig(Map<String, ?> sslConfigs, String hostname) {
        Class<ConfigurableSslSocketFactory> clazz = ConfigurableSslSocketFactory.class;
        synchronized (ConfigurableSslSocketFactory.class) {
            defaultSslFactoryConfig = new DefaultSslFactoryConfig(sslConfigs, hostname);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketFactory getDefault() {
        Class<ConfigurableSslSocketFactory> clazz = ConfigurableSslSocketFactory.class;
        synchronized (ConfigurableSslSocketFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return new ConfigurableSslSocketFactory(defaultSslFactoryConfig.getSslFactory(), defaultSslFactoryConfig.getPeerHost());
        }
    }

    private ConfigurableSslSocketFactory(SslFactory sslFactory, String hostname) {
        super(DefaultSslEngineFactory.castOrThrow((SslEngineFactory)sslFactory.sslEngineFactory()).sslContext().getSocketFactory(), hostname, true);
    }

    private static class DefaultSslFactoryConfig {
        private final SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        private final String peerHost;

        public DefaultSslFactoryConfig(Map<String, ?> sslConfigs, String peerHost) {
            this.sslFactory.configure(sslConfigs);
            this.peerHost = peerHost;
        }

        public SslFactory getSslFactory() {
            return this.sslFactory;
        }

        public String getPeerHost() {
            return this.peerHost;
        }
    }
}

