/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generic;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.coordinator.group.generic.Protocol;

public class GenericGroupMember {
    public static final byte[] EMPTY_ASSIGNMENT = new byte[0];
    private final String memberId;
    private final Optional<String> groupInstanceId;
    private final String clientId;
    private final String clientHost;
    private int rebalanceTimeoutMs;
    private int sessionTimeoutMs;
    private final String protocolType;
    private List<Protocol> supportedProtocols;
    private byte[] assignment;
    private CompletableFuture<JoinGroupResponseData> awaitingJoinFuture = null;
    private CompletableFuture<SyncGroupResponseData> awaitingSyncFuture = null;
    private boolean isNew = false;
    private boolean heartbeatSatisfied = false;

    public GenericGroupMember(String memberId, Optional<String> groupInstanceId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, List<Protocol> supportedProtocols) {
        this(memberId, groupInstanceId, clientId, clientHost, rebalanceTimeoutMs, sessionTimeoutMs, protocolType, supportedProtocols, EMPTY_ASSIGNMENT);
    }

    public GenericGroupMember(String memberId, Optional<String> groupInstanceId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, List<Protocol> supportedProtocols, byte[] assignment) {
        this.memberId = memberId;
        this.groupInstanceId = groupInstanceId;
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.protocolType = protocolType;
        this.supportedProtocols = supportedProtocols;
        this.assignment = assignment;
    }

    public boolean isStaticMember() {
        return this.groupInstanceId.isPresent();
    }

    public boolean isAwaitingJoin() {
        return this.awaitingJoinFuture != null;
    }

    public boolean isAwaitingSync() {
        return this.awaitingSyncFuture != null;
    }

    public byte[] metadata(String protocolName) {
        Optional<Protocol> match = this.supportedProtocols.stream().filter(protocol -> protocol.name().equals(protocolName)).findFirst();
        if (match.isPresent()) {
            return match.get().metadata();
        }
        throw new IllegalArgumentException("Member does not support protocol " + protocolName);
    }

    public boolean hasSatisfiedHeartbeat() {
        if (this.isNew) {
            return this.heartbeatSatisfied;
        }
        if (this.isAwaitingJoin() || this.isAwaitingSync()) {
            return true;
        }
        return this.heartbeatSatisfied;
    }

    public boolean matches(List<Protocol> protocols) {
        return protocols.equals(this.supportedProtocols);
    }

    public String vote(Set<String> candidates) {
        Optional<Protocol> match = this.supportedProtocols.stream().filter(protocol -> candidates.contains(protocol.name())).findFirst();
        if (match.isPresent()) {
            return match.get().name();
        }
        throw new IllegalArgumentException("Member does not support any of the candidate protocols");
    }

    public static Set<String> plainProtocolSet(List<Protocol> supportedProtocols) {
        return supportedProtocols.stream().map(Protocol::name).collect(Collectors.toSet());
    }

    public String memberId() {
        return this.memberId;
    }

    public Optional<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public List<Protocol> supportedProtocols() {
        return this.supportedProtocols;
    }

    public byte[] assignment() {
        return this.assignment;
    }

    public CompletableFuture<JoinGroupResponseData> awaitingJoinFuture() {
        return this.awaitingJoinFuture;
    }

    public CompletableFuture<SyncGroupResponseData> awaitingSyncFuture() {
        return this.awaitingSyncFuture;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean heartBeatSatisfied() {
        return this.heartbeatSatisfied;
    }

    public void setRebalanceTimeoutMs(int value) {
        this.rebalanceTimeoutMs = value;
    }

    public void setSessionTimeoutMs(int value) {
        this.sessionTimeoutMs = value;
    }

    public void setSupportedProtocols(List<Protocol> value) {
        this.supportedProtocols = value;
    }

    public void setAssignment(byte[] value) {
        this.assignment = value;
    }

    public void setAwaitingJoinFuture(CompletableFuture<JoinGroupResponseData> value) {
        this.awaitingJoinFuture = value;
    }

    public void setAwaitingSyncFuture(CompletableFuture<SyncGroupResponseData> value) {
        this.awaitingSyncFuture = value;
    }

    public void setIsNew(boolean value) {
        this.isNew = value;
    }

    public void setHeartBeatSatisfied(boolean value) {
        this.heartbeatSatisfied = value;
    }

    public String toString() {
        return "GenericGroupMember(memberId='" + this.memberId + '\'' + ", groupInstanceId='" + this.groupInstanceId + '\'' + ", clientId='" + this.clientId + '\'' + ", clientHost='" + this.clientHost + '\'' + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", protocolType='" + this.protocolType + '\'' + ", supportedProtocols=" + this.supportedProtocols + ')';
    }
}

