/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.PermissionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Operation {
    public static final Operation ALL = new Operation("All");
    private static final Map<Operation, Collection<Operation>> IMPLICIT_ALLOWED_OPS = new HashMap<Operation, Collection<Operation>>();
    private final String name;

    public Operation(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Collection<Operation> allowOps() {
        return IMPLICIT_ALLOWED_OPS.getOrDefault(this, Collections.emptySet());
    }

    public boolean matches(Operation requestedOp, PermissionType permissionType) {
        return this.equals(ALL) || this.equals(requestedOp) || permissionType == PermissionType.ALLOW && requestedOp.allowOps().contains(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation that = (Operation)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }

    static {
        IMPLICIT_ALLOWED_OPS.put(new Operation("Describe"), Stream.of("Read", "Write", "Delete", "Alter").map(Operation::new).collect(Collectors.toSet()));
        IMPLICIT_ALLOWED_OPS.put(new Operation("DescribeConfigs"), Collections.singleton(new Operation("AlterConfigs")));
    }
}

