/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProviderFactory;
import io.confluent.schema.exporter.client.rest.ExporterRestService;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.client.rest.entities.ExporterStatus;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;

public class ExporterCommand {
    private static final String AUTHORIZATION_HEADER_CONFIG = "Authorization";
    private static final String SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    private static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "basic.auth.credentials.source";
    private static final String BASIC_USER_INFO_CONFIG = "basic.auth.user.info";
    private static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "bearer.auth.credentials.source";
    private static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    private static OptionParser parser;
    private static OptionSet options;
    private static OptionSpecBuilder helpOpt;
    private static OptionSpecBuilder listOpt;
    private static OptionSpecBuilder describeOpt;
    private static OptionSpecBuilder createOpt;
    private static OptionSpecBuilder statusOpt;
    private static OptionSpecBuilder getConfigOpt;
    private static OptionSpecBuilder updateOpt;
    private static OptionSpecBuilder pauseOpt;
    private static OptionSpecBuilder resumeOpt;
    private static OptionSpecBuilder resetOpt;
    private static OptionSpecBuilder deleteOpt;
    private static ArgumentAcceptingOptionSpec<String> schemaRegistryUrlOpt;
    private static ArgumentAcceptingOptionSpec<String> basicAuthCredSourceOpt;
    private static ArgumentAcceptingOptionSpec<String> basicAuthUserInfoOpt;
    private static ArgumentAcceptingOptionSpec<String> bearerAuthCredSourceOpt;
    private static ArgumentAcceptingOptionSpec<String> bearerAuthTokenOpt;
    private static ArgumentAcceptingOptionSpec<String> nameOpt;
    private static ArgumentAcceptingOptionSpec<String> subjectsOpt;
    private static ArgumentAcceptingOptionSpec<String> contextTypeOpt;
    private static ArgumentAcceptingOptionSpec<String> contextOpt;
    private static ArgumentAcceptingOptionSpec<String> kekRenameFormatOpt;
    private static ArgumentAcceptingOptionSpec<String> subjectRenameFormatOpt;
    private static ArgumentAcceptingOptionSpec<String> configFileOpt;
    private static ExporterRestService client;

    public static void main(String[] args) {
        try {
            parser = new OptionParser();
            options = ExporterCommand.exporterCommandOptions(args);
            if (args.length == 0) {
                System.err.println("You must specify at least one action.");
                parser.printHelpOn((OutputStream)System.out);
                System.exit(1);
            }
            if (options.has((OptionSpec)helpOpt)) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            ExporterCommand.verifyArgs();
            Map<String, String> props = ExporterCommand.createRequestProps();
            String schemaRegistryUrl = (String)options.valueOf(schemaRegistryUrlOpt);
            client = new ExporterRestService(new UrlList(schemaRegistryUrl));
            ExporterCommand.executeCommand(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static OptionSet exporterCommandOptions(String[] args) {
        listOpt = parser.accepts("list", "List all schema exporters");
        describeOpt = parser.accepts("describe", "Describe the information of the schema exporter");
        createOpt = parser.accepts("create", "Create new schema exporter");
        statusOpt = parser.accepts("get-status", "Get the status of the schema exporter");
        getConfigOpt = parser.accepts("get-config", "Get the configurations of the schema exporter");
        updateOpt = parser.accepts("update", "Update configs or information of the schema exporter");
        pauseOpt = parser.accepts("pause", "Pause schema exporter");
        resumeOpt = parser.accepts("resume", "Resume schema exporter");
        resetOpt = parser.accepts("reset", "Reset schema exporter");
        deleteOpt = parser.accepts("delete", "Delete schema exporter");
        helpOpt = parser.accepts("help", "Print help info");
        schemaRegistryUrlOpt = parser.accepts(SCHEMA_REGISTRY_URL_CONFIG, "Url for schema registry endpoint").withRequiredArg().describedAs("schema registry url").ofType(String.class);
        basicAuthCredSourceOpt = parser.accepts(BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG, "Credential source for basic authentication").withRequiredArg().describedAs("basic authentication credential source").ofType(String.class);
        basicAuthUserInfoOpt = parser.accepts(BASIC_USER_INFO_CONFIG, "User info for basic authentication").withRequiredArg().describedAs("basic auth user info").ofType(String.class);
        bearerAuthCredSourceOpt = parser.accepts(BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG, "Credential source for bearer authentication").withRequiredArg().describedAs("bearer authentication credential source").ofType(String.class);
        bearerAuthTokenOpt = parser.accepts(BEARER_AUTH_TOKEN_CONFIG, "Token for bearer authentication").withRequiredArg().describedAs("bearer auth token").ofType(String.class);
        nameOpt = parser.accepts("name", "The name of the exporter").withRequiredArg().describedAs("exporter name").ofType(String.class);
        subjectsOpt = parser.accepts("subjects", "The subjects of the exporter").withRequiredArg().describedAs("exporter subjects").ofType(String.class);
        contextTypeOpt = parser.accepts("context-type", "The context type of the exporter. Can be \"AUTO\", \"CUSTOM\", \"DEFAULT\", or \"NONE\"").withRequiredArg().describedAs("type of context").ofType(String.class);
        contextOpt = parser.accepts("context-name", "The context name of the exporter").withRequiredArg().describedAs("exporter context").ofType(String.class);
        kekRenameFormatOpt = parser.accepts("kek-format", "The kek rename format of the exporter").withRequiredArg().describedAs("exporter kek rename format").ofType(String.class);
        subjectRenameFormatOpt = parser.accepts("subject-format", "The subject rename format of the exporter").withRequiredArg().describedAs("exporter subject rename format").ofType(String.class);
        configFileOpt = parser.accepts("config-file", "The file containing configurations of the exporter").withRequiredArg().describedAs("remote schema registry configs").ofType(String.class);
        return parser.parse(args);
    }

    private static void executeCommand(Map<String, String> props) throws IOException, RestClientException, IllegalArgumentException {
        ExporterCommand.maybeListExporters(props);
        ExporterCommand.maybeCreateExporter(props);
        ExporterCommand.maybeDescribeExporter(props);
        ExporterCommand.maybeGetExporterStatus(props);
        ExporterCommand.maybeGetExporterConfig(props);
        ExporterCommand.maybeUpdateExporter(props);
        ExporterCommand.maybePauseExporter(props);
        ExporterCommand.maybeResumeExporter(props);
        ExporterCommand.maybeResetExporter(props);
        ExporterCommand.maybeDeleteExporter(props);
    }

    private static void maybeListExporters(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)listOpt)) {
            return;
        }
        List<String> exporters = client.listExporters(props);
        System.out.println(exporters);
    }

    private static void maybeCreateExporter(Map<String, String> props) throws IOException, RestClientException, IllegalArgumentException {
        if (!options.has((OptionSpec)createOpt)) {
            return;
        }
        List<String> subjects = Collections.singletonList("*");
        if (options.has(subjectsOpt)) {
            subjects = Arrays.asList(((String)options.valueOf(subjectsOpt)).split(","));
        }
        ExporterInfo.ContextType contextType = ExporterInfo.ContextType.AUTO;
        if (options.has(contextTypeOpt)) {
            contextType = ExporterInfo.ContextType.valueOf((String)options.valueOf(contextTypeOpt));
        }
        String context = ".";
        if (contextType.equals((Object)ExporterInfo.ContextType.CUSTOM)) {
            context = (String)options.valueOf(contextOpt);
        } else if (options.has(contextOpt)) {
            throw new IllegalArgumentException("Can only set context-name if context-type is CUSTOM.");
        }
        String kekRenameFormat = null;
        if (options.has(kekRenameFormatOpt)) {
            kekRenameFormat = (String)options.valueOf(kekRenameFormatOpt);
        }
        String subjectRenameFormat = null;
        if (options.has(subjectRenameFormatOpt)) {
            subjectRenameFormat = (String)options.valueOf(subjectRenameFormatOpt);
        }
        String name = (String)options.valueOf(nameOpt);
        Map<String, String> configs = ExporterCommand.readConfigFromFile((String)options.valueOf(configFileOpt));
        client.createExporter(props, name, subjects, contextType, context, kekRenameFormat, subjectRenameFormat, configs);
        System.out.println("Successfully created exporter " + name);
    }

    private static void maybeDescribeExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)describeOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        ExporterInfo info = client.getExporter(props, name);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString((Object)info));
    }

    private static void maybeGetExporterStatus(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)statusOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        ExporterStatus status = client.getExporterStatus(props, name);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString((Object)status));
    }

    private static void maybeGetExporterConfig(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)getConfigOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        Map<String, String> configs = client.getExporterConfig(props, name);
        System.out.println(configs);
    }

    private static void maybeUpdateExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)updateOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        ExporterInfo info = client.getExporter(props, name);
        List<String> subjects = options.has(subjectsOpt) ? Arrays.asList(((String)options.valueOf(subjectsOpt)).split(",")) : info.getSubjects();
        ExporterInfo.ContextType contextType = options.has(contextTypeOpt) ? ExporterInfo.ContextType.valueOf((String)options.valueOf(contextTypeOpt)) : info.getContextType();
        String context = options.has(contextOpt) ? (String)options.valueOf(contextOpt) : info.getContext();
        String kekRenameFormat = null;
        if (options.has(kekRenameFormatOpt)) {
            kekRenameFormat = (String)options.valueOf(kekRenameFormatOpt);
        }
        String subjectRenameFormat = null;
        if (options.has(subjectRenameFormatOpt)) {
            subjectRenameFormat = (String)options.valueOf(subjectRenameFormatOpt);
        }
        Map<String, String> configs = options.has(configFileOpt) ? ExporterCommand.readConfigFromFile((String)options.valueOf(configFileOpt)) : null;
        client.putExporter(props, name, subjects, contextType, context, kekRenameFormat, subjectRenameFormat, configs);
        System.out.println("Successfully updated exporter " + name);
    }

    private static void maybePauseExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)pauseOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        client.pauseExporter(props, name);
        System.out.println("Successfully paused exporter " + name);
    }

    private static void maybeResumeExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)resumeOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        client.resumeExporter(props, name);
        System.out.println("Successfully resumed exporter " + name);
    }

    private static void maybeResetExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)resetOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        client.resetExporter(props, name);
        System.out.println("Successfully reset exporter " + name);
    }

    private static void maybeDeleteExporter(Map<String, String> props) throws IOException, RestClientException {
        if (!options.has((OptionSpec)deleteOpt)) {
            return;
        }
        String name = (String)options.valueOf(nameOpt);
        client.deleteExporter(props, name);
        System.out.println("Successfully deleted exporter " + name);
    }

    private static void verifyRequiredArgs(OptionSet options, OptionSpec ... spec) {
        for (OptionSpec arg : spec) {
            if (options.has(arg)) continue;
            throw new IllegalArgumentException(String.format("Missing required argument %s", arg));
        }
    }

    private static void verifyArgs() {
        if (Stream.of(listOpt, describeOpt, createOpt, statusOpt, updateOpt, pauseOpt, resumeOpt, getConfigOpt, resetOpt, deleteOpt).filter(opt -> options.has((OptionSpec)opt)).count() != 1L) {
            throw new IllegalArgumentException("Command must include exactly one action.");
        }
        ExporterCommand.verifyRequiredArgs(options, new OptionSpec[]{schemaRegistryUrlOpt});
        if (!options.has((OptionSpec)listOpt)) {
            ExporterCommand.verifyRequiredArgs(options, new OptionSpec[]{nameOpt});
        }
        if (options.has((OptionSpec)createOpt)) {
            ExporterCommand.verifyRequiredArgs(options, new OptionSpec[]{configFileOpt});
            if (options.has(contextTypeOpt) && ((String)options.valueOf(contextTypeOpt)).equals("CUSTOM")) {
                ExporterCommand.verifyRequiredArgs(options, new OptionSpec[]{contextOpt});
            }
        }
        if (options.has((OptionSpec)updateOpt) && Stream.of(subjectsOpt, contextTypeOpt, contextOpt, kekRenameFormatOpt, subjectRenameFormatOpt, configFileOpt).filter(opt -> options.has((OptionSpec)opt)).count() < 1L) {
            throw new IllegalArgumentException("At least one of context-type, context, kek-format, subject-format, subjects and config-file has to be specified for update command.");
        }
    }

    private static Map<String, String> createRequestProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/vnd.schemaregistry.v1+json");
        if (options.has(basicAuthCredSourceOpt) && options.has(bearerAuthCredSourceOpt)) {
            throw new IllegalArgumentException(String.format("You can only specify one of %s and %s", BASIC_USER_INFO_CONFIG, BEARER_AUTH_TOKEN_CONFIG));
        }
        if (options.has(basicAuthCredSourceOpt)) {
            String basicCredSource = (String)options.valueOf(basicAuthCredSourceOpt);
            props.put(BASIC_USER_INFO_CONFIG, (String)options.valueOf(basicAuthUserInfoOpt));
            BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)basicCredSource, props);
            if (basicAuthCredentialProvider != null) {
                String userInfo = basicAuthCredentialProvider.getUserInfo(null);
                String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
                props.put(AUTHORIZATION_HEADER_CONFIG, "Basic " + authHeader);
            }
        } else if (options.has(bearerAuthCredSourceOpt)) {
            String bearerCredSource = (String)options.valueOf(bearerAuthCredSourceOpt);
            props.put(BEARER_AUTH_TOKEN_CONFIG, (String)options.valueOf(bearerAuthTokenOpt));
            BearerAuthCredentialProvider bearerAuthCredentialProvider = BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider((String)bearerCredSource, props);
            if (bearerAuthCredentialProvider != null) {
                String bearerToken = bearerAuthCredentialProvider.getBearerToken(null);
                props.put(AUTHORIZATION_HEADER_CONFIG, "Bearer " + bearerToken);
            }
        }
        return props;
    }

    private static Map<String, String> readConfigFromFile(String configPath) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(configPath);){
            props.load(fis);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + configPath);
        }
        catch (IOException e) {
            System.out.println("Unable to read from config file: " + configPath);
        }
        for (String key : props.stringPropertyNames()) {
            configMap.put(key, props.getProperty(key));
        }
        return configMap;
    }
}

