/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.confluent.dekregistry.client.CachedDekRegistryClient;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import io.confluent.dekregistry.web.rest.exceptions.RestConflictException;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RetryExecutor;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.client.LocalSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterClientConfig;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.confluent.schema.exporter.storage.utils.LocalDekRegistryClient;
import io.confluent.schema.exporter.util.StripedRunnable;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaExporterTask
implements StripedRunnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaExporterTask.class);
    public static final int DEFAULT_MAX_DEKS = 1000;
    public static final int DEFAULT_MAX_SCHEMAS_PER_SUBJECT = 1000;
    public static final String MAX_SCHEMAS_PER_SUBJECT = "max.schemas.per.subject";
    public static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    public static final String ENCRYPT = "ENCRYPT";
    public static final String ENCRYPT_KEK_NAME = "encrypt.kek.name";
    private static final String AWS_MULTI_REGION_KEY_PREFIX = "key/mrk-";
    private static final String KEK_VAR = "${kek}";
    private static final String SUBJECT_VAR = "${subject}";
    private final SchemaExporterService exporterService;
    private final KafkaSchemaRegistry schemaRegistry;
    private final DekRegistry dekRegistry;
    private final SchemaExporter exporter;
    private final RetryExecutor retryExecutor;

    public AbstractSchemaExporterTask(SchemaExporterService exporterService, SchemaExporter exporter) {
        this.exporterService = exporterService;
        this.schemaRegistry = exporterService.getSchemaRegistry();
        this.dekRegistry = (DekRegistry)this.schemaRegistry.properties().get("dekRegistry");
        this.exporter = exporter;
        this.retryExecutor = new RetryExecutor(exporterService.config().exporterMaxRetries(), exporterService.config().exporterRetriesWaitMs(), exporterService.config().exporterRetriesMaxWaitMs());
    }

    public SchemaExporterService exporterService() {
        return this.exporterService;
    }

    public KafkaSchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }

    public DekRegistry dekRegistry() {
        return this.dekRegistry;
    }

    public SchemaExporter exporter() {
        return this.exporter;
    }

    public String tenant() {
        return this.exporter.getTenant();
    }

    @Override
    public Object getStripe() {
        return this.tenant();
    }

    @Override
    public abstract void run();

    protected SchemaRegistryClient getSchemaRegistryClient(Map<String, String> config) {
        SchemaExporterClientConfig clientConfig = this.exporterService().encoder().clientConfig(config);
        Map properties = clientConfig.originals();
        Object urls = properties.get(SCHEMA_REGISTRY_URL);
        if (urls == null) {
            throw new ConfigException("Missing exporter property: schema.registry.url");
        }
        List<String> urlList = Arrays.asList(urls.toString().split("\\s*,\\s*"));
        int maxSchemasPerSubject = 1000;
        Object maxSchemasPerSubjectObj = properties.get(MAX_SCHEMAS_PER_SUBJECT);
        if (maxSchemasPerSubjectObj != null) {
            try {
                maxSchemasPerSubject = Integer.parseInt(maxSchemasPerSubjectObj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        List<SchemaProvider> providers = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
        if (urlList.size() == 1 && urlList.get(0).startsWith("local:///")) {
            return new LocalSchemaRegistryClient(this.schemaRegistry(), providers);
        }
        return new CachedSchemaRegistryClient(urlList, maxSchemasPerSubject, providers, properties);
    }

    protected static boolean isLocal(SchemaRegistryClient client) {
        return client instanceof LocalSchemaRegistryClient;
    }

    protected static boolean isLocal(DekRegistryClient client) {
        return client instanceof LocalDekRegistryClient;
    }

    protected DekRegistryClient getDekRegistryClient(Map<String, String> config) {
        SchemaExporterClientConfig clientConfig = this.exporterService().encoder().clientConfig(config);
        Map properties = clientConfig.originals();
        Object urls = properties.get(SCHEMA_REGISTRY_URL);
        if (urls == null) {
            throw new ConfigException("Missing exporter property: schema.registry.url");
        }
        List<String> urlList = Arrays.asList(urls.toString().split("\\s*,\\s*"));
        if (urlList.size() == 1 && urlList.get(0).startsWith("local:///")) {
            return new LocalDekRegistryClient(this.dekRegistry());
        }
        return new CachedDekRegistryClient(urlList, 1000, -1, properties, null);
    }

    protected boolean matches(List<String> subjects, String subject) {
        for (String subjectOrPrefix : subjects) {
            if (!this.matches(subjectOrPrefix, subject)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(String subjectOrPrefix, String subject) {
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        if (isPrefix) {
            String prefix = subjectOrPrefix.substring(0, subjectOrPrefix.length() - 1);
            boolean isDefaultContextPrefix = prefix.equals(":.:");
            if (isDefaultContextPrefix) {
                return !subject.startsWith(":.");
            }
            return subject.startsWith(this.removeDefaultContext(prefix));
        }
        if (subjectOrPrefix.equals(":*:")) {
            return true;
        }
        return subject.equals(this.removeDefaultContext(subjectOrPrefix));
    }

    private String removeDefaultContext(String subjectOrPrefix) {
        String ctx = ":.:";
        return subjectOrPrefix.startsWith(ctx) ? subjectOrPrefix.substring(ctx.length()) : subjectOrPrefix;
    }

    protected String trace(Throwable t) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            t.printStackTrace(new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name()));
            return output.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected SubjectValue exportValues(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String subjectOrPrefix, long exclusiveStartOffset, long exclusiveEndOffset, boolean checkMode) throws SchemaRegistryException, IOException, RestClientException {
        String tenantPrefix = this.tenant().equals("default") ? "" : this.tenant() + "_";
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        KeyValue<String, String> range = this.getRange(subjectOrPrefix, tenantPrefix, isPrefix);
        String start = (String)range.key;
        String end = (String)range.value;
        List<SchemaRegistryValue> prevValues = this.getValuesWithSubjectPrefix(start, end, exclusiveStartOffset, exclusiveEndOffset);
        SubjectValue subjectValue = null;
        for (SchemaRegistryValue prevValue : prevValues) {
            subjectValue = (SubjectValue)prevValue;
            String subject = subjectValue.getSubject();
            boolean doExport = false;
            if (!tenantPrefix.isEmpty()) {
                if (subject.startsWith(tenantPrefix)) {
                    subject = subject.substring(tenantPrefix.length());
                    doExport = true;
                }
            } else {
                doExport = true;
            }
            if (!doExport || !this.matches(subjectOrPrefix, subject)) continue;
            this.exportValue(exporter, client, info, status, subjectValue, checkMode);
        }
        return subjectValue;
    }

    private KeyValue<String, String> getRange(String subjectOrPrefix, String tenantPrefix, boolean isPrefix) {
        String end;
        String start;
        if (isPrefix) {
            String prefix = subjectOrPrefix.substring(0, subjectOrPrefix.length() - 1);
            boolean isDefaultContextPrefix = prefix.equals(":.:");
            if (isDefaultContextPrefix) {
                start = tenantPrefix;
                end = tenantPrefix + '\uffff';
            } else {
                start = tenantPrefix + this.removeDefaultContext(prefix);
                end = start + '\uffff';
            }
        } else if (subjectOrPrefix.equals(":*:")) {
            start = tenantPrefix + ":." + ":";
            end = tenantPrefix + ":." + '\uffff' + ":";
        } else {
            end = start = tenantPrefix + this.removeDefaultContext(subjectOrPrefix);
        }
        return new KeyValue((Object)start, (Object)end);
    }

    private void exportValue(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, SubjectValue prevValue, boolean checkMode) throws IOException, RestClientException {
        SubjectKey key = prevValue.toKey();
        this.export(exporter, client, info, status, this.tenant(), key, prevValue, checkMode);
    }

    protected void export(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, SubjectKey key, SubjectValue value, boolean checkMode) throws IOException, RestClientException {
        QualifiedSubject qs = QualifiedSubject.create((String)tenant, (String)key.getSubject());
        String contextWithoutTenant = ":" + qs.getContext() + ":" + qs.getSubject();
        String newSubject = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, contextWithoutTenant);
        if (newSubject == null) {
            log.debug("Skipping subject " + key.getSubject());
            return;
        }
        switch (key.getKeyType()) {
            case SCHEMA: {
                if (checkMode) {
                    this.setMode(exporter, client, info, tenant, key);
                }
                this.exportSchema(exporter, client, info, status, tenant, newSubject, (SchemaKey)key, (SchemaValue)value);
                if (value == null || !((SchemaValue)value).isDeleted()) break;
                this.setMode(exporter, client, info, tenant, key);
                break;
            }
            case CONFIG: {
                this.exportConfig(exporter, client, info, status, tenant, newSubject, (ConfigKey)key, (ConfigValue)value);
                break;
            }
            case DELETE_SUBJECT: {
                this.exportDeleteSubject(exporter, client, info, status, tenant, newSubject, (DeleteSubjectKey)key, (DeleteSubjectValue)value);
                this.setMode(exporter, client, info, tenant, key);
                break;
            }
            default: {
                log.debug("Ignoring key type " + key.getKeyType());
            }
        }
    }

    protected EncryptionKey exportKeys(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String subjectOrPrefix, long exclusiveStartOffset, long exclusiveEndOffset) throws IOException, RestClientException {
        String tenantPrefix = "";
        boolean isPrefix = subjectOrPrefix.endsWith("*");
        KeyValue<String, String> range = this.getRange(subjectOrPrefix, tenantPrefix, isPrefix);
        String start = (String)range.key;
        String end = (String)range.value;
        List<DataEncryptionKey> prevKeys = this.getKeysWithSubjectPrefix(start, end, exclusiveStartOffset, exclusiveEndOffset);
        DataEncryptionKey key = null;
        Iterator<DataEncryptionKey> iterator = prevKeys.iterator();
        while (iterator.hasNext()) {
            DataEncryptionKey dek;
            key = dek = iterator.next();
            if (!this.matches(subjectOrPrefix, dek.getSubject())) continue;
            KeyEncryptionKey kek = this.dekRegistry().getKek(dek.getKekName(), true);
            this.exportKek(exporter, client, info, status, kek);
            this.exportDek(exporter, client, info, status, dek);
        }
        return key;
    }

    private void exportKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, KeyEncryptionKey kek) throws IOException, RestClientException {
        this.exportKek(exporter, client, info, status, this.tenant(), kek.toKey(this.tenant()), kek);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exportKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, KeyEncryptionKeyId kekId, KeyEncryptionKey kek) throws IOException, RestClientException {
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekId.getName());
        if (kek == null) {
            try {
                log.debug("Hard-deleting kek for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> {
                    client.deleteKek(newKekName, true);
                    return true;
                });
                return;
            }
            catch (RestNotFoundException restNotFoundException) {
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                throw e;
            }
        }
        if (!newKekName.equals(kekId.getName())) {
            kek = new KeyEncryptionKey(newKekName, kek.getKmsType(), kek.getKmsKeyId(), kek.getKmsProps(), kek.getDoc(), kek.isShared(), kek.isDeleted());
        }
        try {
            this.registerKek(exporter, client, kek);
            return;
        }
        catch (RestConflictException e) {
            this.maybeUpdateKek(exporter, client, kek, (Exception)((Object)e));
            return;
        }
        catch (RestClientException e) {
            if (e.getStatus() != Response.Status.CONFLICT.getStatusCode()) {
                throw e;
            }
            this.maybeUpdateKek(exporter, client, kek, (Exception)((Object)e));
        }
    }

    private void registerKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek) throws IOException, RestClientException {
        log.debug("Registering kek for exporter " + exporter.getName());
        this.retryExecutor.retry(() -> client.createKek(kek.getName(), kek.getKmsType(), kek.getKmsKeyId(), (Map)kek.getKmsProps(), kek.getDoc(), kek.isShared(), kek.isDeleted()));
    }

    private void maybeUpdateKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek, Exception e) throws IOException, RestClientException {
        Kek oldKek = (Kek)this.retryExecutor.retry(() -> client.getKek(kek.getName(), true));
        if (AbstractSchemaExporterTask.areKeyIdsEquivalent(kek.getKmsKeyId(), oldKek.getKmsKeyId()) && kek.getKmsType().equals(oldKek.getKmsType())) {
            if (!(Objects.equals(kek.getKmsProps(), oldKek.getKmsProps()) && Objects.equals(kek.getDoc(), oldKek.getDoc()) && Objects.equals(kek.isShared(), oldKek.isShared()))) {
                this.updateKek(exporter, client, kek);
            }
        } else {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RestClientException) {
                throw (RestClientException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static boolean areKeyIdsEquivalent(String kmsKeyId1, String kmsKeyId2) {
        if (kmsKeyId1.startsWith("arn:") && kmsKeyId2.startsWith("arn:")) {
            List tokens1 = Splitter.on((char)':').splitToList((CharSequence)kmsKeyId1);
            List tokens2 = Splitter.on((char)':').splitToList((CharSequence)kmsKeyId2);
            if (tokens1.size() == 6 && tokens2.size() == 6) {
                String accountId1 = (String)tokens1.get(4);
                String accountId2 = (String)tokens2.get(4);
                String keyName1 = (String)tokens1.get(5);
                String keyName2 = (String)tokens2.get(5);
                if (keyName1.startsWith(AWS_MULTI_REGION_KEY_PREFIX) && keyName2.startsWith(AWS_MULTI_REGION_KEY_PREFIX)) {
                    return accountId1.equals(accountId2) && keyName1.equals(keyName2);
                }
            }
        }
        return kmsKeyId1.equals(kmsKeyId2);
    }

    private void updateKek(SchemaExporter exporter, DekRegistryClient client, KeyEncryptionKey kek) throws IOException, RestClientException {
        log.debug("Updating kek for exporter " + exporter.getName());
        this.retryExecutor.retry(() -> client.updateKek(kek.getName(), (Map)kek.getKmsProps(), kek.getDoc(), Boolean.valueOf(kek.isShared())));
    }

    protected void deleteKek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, KeyEncryptionKeyId kekId, KeyEncryptionKey kek) throws IOException, RestClientException {
        block3: {
            String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekId.getName());
            try {
                log.debug("Soft-deleting kek for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> {
                    client.deleteKek(newKekName, false);
                    return true;
                });
            }
            catch (RestNotFoundException restNotFoundException) {
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block3;
                throw e;
            }
        }
    }

    private void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, DataEncryptionKey dek) throws IOException, RestClientException {
        this.exportDek(exporter, client, info, status, this.tenant(), dek.toKey(this.tenant()), dek);
    }

    protected void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, DataEncryptionKeyId dekId, DataEncryptionKey dek) throws IOException, RestClientException {
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, dekId.getKekName());
        String subject = dekId.getSubject();
        String newSubject = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, subject);
        if (newSubject == null) {
            log.debug("Skipping subject " + subject);
            return;
        }
        if (!newKekName.equals(dekId.getKekName()) || !newSubject.equals(dekId.getSubject())) {
            dekId = new DataEncryptionKeyId(dekId.getTenant(), newKekName, newSubject, dekId.getAlgorithm(), dekId.getVersion());
            if (dek != null) {
                dek = new DataEncryptionKey(newKekName, newSubject, dek.getAlgorithm(), dek.getVersion(), dek.getEncryptedKeyMaterial(), dek.isDeleted());
            }
        }
        this.exportDek(exporter, client, status, dekId, dek);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportDek(SchemaExporter exporter, DekRegistryClient client, SchemaExporterStatus status, DataEncryptionKeyId dekId, DataEncryptionKey dek) throws IOException, RestClientException {
        if (dek == null) {
            try {
                log.debug("Hard-deleting dek for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> {
                    client.deleteDekVersion(dekId.getKekName(), dekId.getSubject(), dekId.getVersion(), dekId.getAlgorithm(), true);
                    return true;
                });
                return;
            }
            catch (RestNotFoundException restNotFoundException) {
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                throw e;
            }
        }
        try {
            this.registerDek(exporter, client, dek);
            return;
        }
        catch (RestConflictException e) {
            return;
        }
        catch (RestClientException e) {
            if (e.getStatus() == Response.Status.CONFLICT.getStatusCode()) return;
            throw e;
        }
    }

    private void registerDek(SchemaExporter exporter, DekRegistryClient client, DataEncryptionKey dek) throws IOException, RestClientException {
        log.debug("Registering dek for exporter " + exporter.getName());
        this.retryExecutor.retry(() -> client.createDek(dek.getKekName(), dek.getSubject(), dek.getVersion(), dek.getAlgorithm(), dek.getEncryptedKeyMaterial(), dek.isDeleted()));
    }

    private void setMode(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, String tenant, SubjectKey key) throws IOException, RestClientException {
        QualifiedSubject qs = QualifiedSubject.create((String)tenant, (String)key.getSubject());
        String contextWithoutTenant = ":" + qs.getContext() + ":" + qs.getSubject();
        String newContext = AbstractSchemaExporterTask.translateSubject(this.schemaRegistry(), AbstractSchemaExporterTask.isLocal(client), info, tenant, contextWithoutTenant);
        if (newContext != null) {
            this.setMode(exporter, client, newContext, true);
        }
    }

    protected void setMode(SchemaExporter exporter, SchemaRegistryClient client, String context, boolean force) throws IOException, RestClientException {
        String mode;
        block4: {
            mode = null;
            try {
                mode = (String)this.retryExecutor.retry(() -> client.getMode(context));
            }
            catch (RestNotFoundException restNotFoundException) {
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block4;
                throw e;
            }
        }
        boolean isReady = Mode.IMPORT.name().equalsIgnoreCase(mode);
        if (!isReady) {
            log.debug("Setting mode for exporter " + exporter.getName() + ", context " + context);
            this.retryExecutor.retry(() -> client.setMode(Mode.IMPORT.name(), context, force));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportSchema(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, SchemaKey key, SchemaValue value) throws IOException, RestClientException {
        if (value == null) {
            try {
                log.debug("Hard-deleting schema for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> client.deleteSchemaVersion(subject, String.valueOf(key.getVersion()), true));
                return;
            }
            catch (RestNotFoundException restNotFoundException) {
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                throw e;
            }
        }
        if (value.isDeleted()) {
            block11: {
                if (status.getState() == SchemaExporterStatus.State.STARTING) {
                    try {
                        this.retryExecutor.retry(() -> client.getByVersion(subject, key.getVersion(), true));
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof RestClientException) || ((RestClientException)cause).getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break block11;
                        this.registerSchema(exporter, info, client, subject, value);
                    }
                }
            }
            try {
                log.debug("Deleting schema for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> client.deleteSchemaVersion(subject, String.valueOf(key.getVersion())));
                return;
            }
            catch (RestNotFoundException e) {
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                throw e;
            }
        }
        this.registerSchema(exporter, info, client, subject, value);
    }

    private void registerSchema(SchemaExporter exporter, SchemaExporterInfo info, SchemaRegistryClient client, String subject, SchemaValue value) throws IOException, RestClientException {
        Optional schema = null;
        try {
            schema = client.parseSchema(this.schemaRegistry.toSchemaEntity(value));
        }
        catch (SchemaRegistryStoreException schemaRegistryStoreException) {
            // empty catch block
        }
        if (schema == null || !schema.isPresent()) {
            throw new IOException("Could not parse schema " + value.getSchema() + " with type " + value.getSchemaType() + " with references " + value.getReferences());
        }
        ParsedSchema parsedSchema = (ParsedSchema)schema.get();
        if (info.getKekRenameFormat() != null && !info.getKekRenameFormat().isEmpty() && parsedSchema.ruleSet() != null && parsedSchema.ruleSet().hasRulesWithType(ENCRYPT)) {
            Metadata metadata = parsedSchema.metadata();
            Metadata newMetadata = this.renameKekInMetadata(info, metadata);
            RuleSet ruleSet = parsedSchema.ruleSet();
            RuleSet newRuleSet = this.renameKekInRules(info, ruleSet);
            parsedSchema = parsedSchema.copy(newMetadata, newRuleSet);
        }
        ParsedSchema finalSchema = parsedSchema;
        log.debug("Registering schema for exporter " + exporter.getName());
        this.retryExecutor.retry(() -> client.register(subject, finalSchema, value.getVersion().intValue(), value.getId().intValue()));
    }

    private Metadata renameKekInMetadata(SchemaExporterInfo info, Metadata metadata) {
        if (metadata == null || metadata.getProperties() == null || metadata.getProperties().isEmpty()) {
            return metadata;
        }
        return new Metadata((Map)metadata.getTags(), metadata.getProperties().entrySet().stream().map(e -> this.renameKekInProp(info, (Map.Entry<String, String>)e)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (Set)metadata.getSensitive());
    }

    private Map.Entry<String, String> renameKekInProp(SchemaExporterInfo info, Map.Entry<String, String> entry) {
        if (!entry.getKey().equals(ENCRYPT_KEK_NAME)) {
            return entry;
        }
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, entry.getValue());
        return new AbstractMap.SimpleEntry<String, String>(entry.getKey(), newKekName);
    }

    private RuleSet renameKekInRules(SchemaExporterInfo info, RuleSet ruleSet) {
        if (ruleSet == null || ruleSet.getDomainRules() == null || ruleSet.getDomainRules().isEmpty()) {
            return ruleSet;
        }
        return new RuleSet(ruleSet.getMigrationRules(), ruleSet.getDomainRules().stream().map(r -> this.renameKekInRule(info, (Rule)r)).collect(Collectors.toList()));
    }

    private Rule renameKekInRule(SchemaExporterInfo info, Rule rule) {
        if (rule.getParams() == null || rule.getParams().isEmpty()) {
            return rule;
        }
        SortedMap params = rule.getParams();
        String kekName = (String)params.get(ENCRYPT_KEK_NAME);
        if (kekName == null) {
            return rule;
        }
        HashMap<String, String> newParams = new HashMap<String, String>(params);
        String newKekName = AbstractSchemaExporterTask.rename(info.getKekRenameFormat(), KEK_VAR, kekName);
        newParams.put(ENCRYPT_KEK_NAME, newKekName);
        return new Rule(rule.getName(), rule.getDoc(), rule.getKind(), rule.getMode(), rule.getType(), (Set)rule.getTags(), newParams, rule.getExpr(), rule.getOnSuccess(), rule.getOnFailure(), rule.isDisabled());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportConfig(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, ConfigKey key, ConfigValue value) throws IOException, RestClientException {
        if (value == null) {
            try {
                log.debug("Deleting config for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> {
                    client.deleteConfig(subject);
                    return true;
                });
                return;
            }
            catch (RestNotFoundException restNotFoundException) {
                return;
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) return;
                throw e;
            }
        } else {
            log.debug("Updating config for exporter " + exporter.getName());
            this.retryExecutor.retry(() -> client.updateConfig(subject, value.toConfigEntity()));
        }
    }

    private void exportDeleteSubject(SchemaExporter exporter, SchemaRegistryClient client, SchemaExporterInfo info, SchemaExporterStatus status, String tenant, String subject, DeleteSubjectKey key, DeleteSubjectValue value) throws IOException, RestClientException {
        block3: {
            try {
                log.debug("Deleting subject for exporter " + exporter.getName());
                this.retryExecutor.retry(() -> client.deleteSubject(subject));
            }
            catch (RestNotFoundException restNotFoundException) {
            }
            catch (RestClientException e) {
                if (e.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block3;
                throw e;
            }
        }
    }

    public static String translateSubject(KafkaSchemaRegistry schemaRegistry, boolean isLocal, SchemaExporterInfo info, String tenant, String subjectWithoutTenant) {
        String relativeContext;
        String newContext;
        QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)subjectWithoutTenant);
        String newSubject = AbstractSchemaExporterTask.rename(info.getSubjectRenameFormat(), SUBJECT_VAR, qs.getSubject());
        if (CharMatcher.javaIsoControl().matchesAnyOf((CharSequence)newSubject)) {
            return null;
        }
        ExporterInfo.ContextType contextType = info.getContextType();
        if (contextType == null) {
            contextType = ExporterInfo.ContextType.AUTO;
        }
        String oldContext = qs.getContext();
        switch (contextType) {
            case NONE: {
                if (".".equals(oldContext)) {
                    return newSubject;
                }
                return ":" + oldContext + ":" + newSubject;
            }
            case AUTO: {
                newContext = SchemaExporterService.getAutoContext(schemaRegistry, tenant);
                break;
            }
            case CUSTOM: {
                newContext = info.getContext();
                break;
            }
            case DEFAULT: {
                if (isLocal && subjectWithoutTenant.equals(newSubject)) {
                    log.warn("Subject already in default context: " + newSubject);
                    return null;
                }
                return newSubject;
            }
            default: {
                throw new IllegalArgumentException("Unsupported context type " + (Object)((Object)contextType));
            }
        }
        if (newContext.startsWith(".")) {
            relativeContext = newContext.substring(1);
        } else {
            relativeContext = newContext;
            newContext = "." + relativeContext;
        }
        if (!".".equals(oldContext)) {
            newContext = newContext + oldContext;
            String[] parts = oldContext.split("\\.");
            if (Arrays.asList(parts).contains(relativeContext)) {
                log.warn("Avoiding cyclic context path: " + newContext);
                return null;
            }
        }
        return ".".equals(newContext) ? newSubject : ":" + newContext + ":" + newSubject;
    }

    private static String rename(String renameFormat, String pattern, String oldName) {
        if (renameFormat == null || renameFormat.isEmpty()) {
            return oldName;
        }
        return renameFormat.replace(pattern, oldName);
    }

    private List<SchemaRegistryValue> getValuesWithSubjectPrefix(String start, String end, long exclusiveStartOffset, long exclusiveEndOffset) throws SchemaRegistryException {
        ArrayList<SchemaRegistryValue> values = new ArrayList<SchemaRegistryValue>();
        long maxOffset1 = this.getValues(this.configsWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        long maxOffset2 = this.getValues(this.deletesWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        long maxOffset3 = this.getValues(this.schemasWithSubjectPrefix(start, end), exclusiveStartOffset, exclusiveEndOffset, values);
        if (exclusiveEndOffset == Long.MAX_VALUE) {
            if (Math.max(maxOffset2, maxOffset3) > maxOffset1) {
                this.getValues(this.configsWithSubjectPrefix(start, end), Math.max(maxOffset1, exclusiveStartOffset), Math.max(maxOffset2, maxOffset3), values);
            }
            if (maxOffset3 > maxOffset2) {
                this.getValues(this.deletesWithSubjectPrefix(start, end), Math.max(maxOffset2, exclusiveStartOffset), maxOffset3, values);
            }
        }
        values.sort(Comparator.comparingLong(SchemaRegistryValue::getOffset));
        return values;
    }

    private long getValues(CloseableIterator<SchemaRegistryValue> iter, long exclusiveStartOffset, long exclusiveEndOffset, List<SchemaRegistryValue> values) throws SchemaRegistryException {
        long maxOffset = -1L;
        try (CloseableIterator<SchemaRegistryValue> schemas = iter;){
            while (schemas.hasNext()) {
                SchemaRegistryValue value = (SchemaRegistryValue)schemas.next();
                if (value.getOffset() <= exclusiveStartOffset || value.getOffset() >= exclusiveEndOffset) continue;
                values.add(value);
                if (value.getOffset() <= maxOffset) continue;
                maxOffset = value.getOffset();
            }
        }
        return maxOffset;
    }

    private CloseableIterator<SchemaRegistryValue> schemasWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            SchemaKey key1 = new SchemaKey(start, 1);
            SchemaKey key2 = new SchemaKey(end, Integer.MAX_VALUE);
            return this.schemaRegistry().getLookupCache().getAll((Object)key1, (Object)key2);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> deletesWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            LookupCache cache = this.schemaRegistry().getLookupCache();
            if (!start.equals(end)) {
                DeleteSubjectKey key1 = new DeleteSubjectKey(start);
                DeleteSubjectKey key2 = new DeleteSubjectKey(end);
                return cache.getAll((Object)key1, (Object)key2);
            }
            return new DelegatingIterator<Object>(cache.get((Object)new DeleteSubjectKey(start)));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> configsWithSubjectPrefix(String start, String end) throws SchemaRegistryException {
        try {
            LookupCache cache = this.schemaRegistry().getLookupCache();
            if (!start.equals(end)) {
                ConfigKey key1 = new ConfigKey(start);
                ConfigKey key2 = new ConfigKey(end);
                return cache.getAll((Object)key1, (Object)key2);
            }
            return new DelegatingIterator<Object>(cache.get((Object)new ConfigKey(start)));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", (Throwable)e);
        }
    }

    private List<DataEncryptionKey> getKeysWithSubjectPrefix(String start, String end, long exclusiveStartOffset, long exclusiveEndOffset) {
        if (this.dekRegistry() == null) {
            return Collections.emptyList();
        }
        ArrayList<DataEncryptionKey> deks = new ArrayList<DataEncryptionKey>();
        List kekNames = this.dekRegistry().getKekNames(true);
        for (String kekName : kekNames) {
            List<DataEncryptionKey> dekValues = this.getDekValues(this.deksWithSubjectPrefix(this.dekRegistry(), kekName, start, end), exclusiveStartOffset, exclusiveEndOffset);
            deks.addAll(dekValues);
        }
        deks.sort(Comparator.comparingLong(EncryptionKey::getOffset));
        return deks;
    }

    private List<DataEncryptionKey> getDekValues(KeyValueIterator<EncryptionKeyId, EncryptionKey> iter, long exclusiveStartOffset, long exclusiveEndOffset) {
        ArrayList<DataEncryptionKey> values = new ArrayList<DataEncryptionKey>();
        try (KeyValueIterator<EncryptionKeyId, EncryptionKey> deks = iter;){
            while (deks.hasNext()) {
                KeyValue value = (KeyValue)deks.next();
                long offset = ((EncryptionKey)value.value).getOffset();
                if (offset <= exclusiveStartOffset || offset >= exclusiveEndOffset) continue;
                values.add((DataEncryptionKey)value.value);
            }
        }
        return values;
    }

    private KeyValueIterator<EncryptionKeyId, EncryptionKey> deksWithSubjectPrefix(DekRegistry dekRegistry, String kekName, String start, String end) {
        DataEncryptionKeyId key1 = new DataEncryptionKeyId(this.tenant(), kekName, start, DekFormat.AES128_GCM, 1);
        DataEncryptionKeyId key2 = new DataEncryptionKeyId(this.tenant(), kekName, end, DekFormat.AES256_SIV, Integer.MAX_VALUE);
        return dekRegistry.keys().range((Object)key1, true, (Object)key2, false);
    }

    static class OffsetTimestamp {
        private final long offset;
        private final long timestamp;

        public OffsetTimestamp(long offset, long timestamp) {
            this.offset = offset;
            this.timestamp = timestamp;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetTimestamp that = (OffsetTimestamp)o;
            return this.offset == that.offset && this.timestamp == that.timestamp;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.timestamp);
        }

        public String toString() {
            return "OffsetTimestamp{offset=" + this.offset + ", timestamp=" + this.timestamp + '}';
        }
    }

    static class DelegatingIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;

        public DelegatingIterator(T value) {
            List coll = value != null ? Collections.singletonList(value) : Collections.emptyList();
            this.iterator = coll.iterator();
        }

        public DelegatingIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void close() {
        }
    }
}

