/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.KeyEncryptionKeyId;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterRunningTaskForKeys
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterRunningTaskForKeys.class);
    private final EncryptionKeyId key;
    private final EncryptionKey value;
    private final long offset;
    private final long timestamp;
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues;

    public SchemaExporterRunningTaskForKeys(SchemaExporterService exporterService, SchemaExporter exporter, EncryptionKeyId key, EncryptionKey value, long offset, long timestamp, Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues) {
        super(exporterService, exporter);
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
        this.latestValues = latestValues;
    }

    @Override
    public void run() {
        block17: {
            SchemaExporterStatus status;
            if (!this.exporterService().isLeader()) {
                return;
            }
            if (!"default".equals(this.tenant())) {
                this.schemaRegistry().setTenant(this.tenant());
            }
            if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.RUNNING || status.getDeksOffset() >= this.offset) {
                return;
            }
            try {
                SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
                if (info == null) {
                    return;
                }
                List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
                DekRegistryClient client = this.getDekRegistryClient(info.getConfig());
                long lastOffset = status.getDeksOffset();
                AbstractSchemaExporterTask.OffsetTimestamp latestValue = this.latestValues.get(this.exporter());
                if (latestValue != null && latestValue.getOffset() > lastOffset) {
                    lastOffset = latestValue.getOffset();
                }
                if (lastOffset < this.offset - 1L) {
                    for (String subjectOrPrefix : subjects) {
                        this.exportKeys(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, this.offset);
                    }
                }
                if (this.key.getTenant().equals(this.tenant())) {
                    if (this.key instanceof KeyEncryptionKeyId) {
                        KeyEncryptionKeyId kekId = (KeyEncryptionKeyId)this.key;
                        KeyEncryptionKey kek = (KeyEncryptionKey)this.value;
                        List dekSubjects = this.dekRegistry().getDekSubjects(kekId.getName(), true);
                        if (this.value == null || dekSubjects.stream().anyMatch(s -> this.matches(subjects, (String)s))) {
                            this.exportKek(this.exporter(), client, info, status, this.tenant(), kekId, kek);
                        } else if (this.value.isDeleted() && dekSubjects.isEmpty()) {
                            this.deleteKek(this.exporter(), client, info, kekId, kek);
                        }
                    } else {
                        DataEncryptionKeyId dekId = (DataEncryptionKeyId)this.key;
                        DataEncryptionKey dek = (DataEncryptionKey)this.value;
                        if (this.matches(subjects, dekId.getSubject())) {
                            KeyEncryptionKey kek = this.dekRegistry().getKek(dekId.getKekName(), true);
                            if (kek != null) {
                                this.exportKek(this.exporter(), client, info, status, this.tenant(), kek.toKey(this.tenant()), kek);
                            }
                            this.exportDek(this.exporter(), client, info, status, this.tenant(), dekId, dek);
                        }
                    }
                }
                this.latestValues.put(this.exporter(), new AbstractSchemaExporterTask.OffsetTimestamp(this.offset, this.timestamp));
            }
            catch (Throwable t) {
                String trace = this.trace(t);
                log.error("Error during export: " + trace);
                status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
                if (status == null) break block17;
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                this.exporterService().exporterStatuses().put((Object)this.exporter(), (Object)status);
            }
        }
    }
}

