/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterStartingTask
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterStartingTask.class);

    public SchemaExporterStartingTask(SchemaExporterService exporterService, SchemaExporter exporter) {
        super(exporterService, exporter);
    }

    @Override
    public void run() {
        block6: {
            SchemaExporterStatus status;
            if (!this.exporterService().isLeader()) {
                return;
            }
            if (!"default".equals(this.tenant())) {
                this.schemaRegistry().setTenant(this.tenant());
            }
            if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.STARTING) {
                return;
            }
            try {
                SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
                if (info == null) {
                    return;
                }
                List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
                SchemaRegistryClient client = this.getSchemaRegistryClient(info.getConfig());
                this.setModes(info, client, subjects);
                SubjectValue lastSubjectValue = this.exportSchemas(client, subjects, info, status);
                DekRegistryClient dekRegistryClient = this.getDekRegistryClient(info.getConfig());
                EncryptionKey lastEncryptionKey = this.exportKeys(dekRegistryClient, subjects, info, status);
                this.saveStatus(lastSubjectValue, lastEncryptionKey);
            }
            catch (Throwable t) {
                String trace = this.trace(t);
                log.error("Error during export: " + trace);
                status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
                if (status == null) break block6;
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                this.exporterService().exporterStatuses().put((Object)this.exporter(), (Object)status);
            }
        }
    }

    private SubjectValue exportSchemas(SchemaRegistryClient client, List<String> subjects, SchemaExporterInfo info, SchemaExporterStatus status) throws SchemaRegistryException, IOException, RestClientException {
        long lastOffset = status.getOffset();
        SubjectValue subjectValue = null;
        boolean checkMode = subjects.contains(":*:");
        for (String subjectOrPrefix : subjects) {
            subjectValue = this.exportValues(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, Long.MAX_VALUE, checkMode);
        }
        return subjectValue;
    }

    private EncryptionKey exportKeys(DekRegistryClient client, List<String> subjects, SchemaExporterInfo info, SchemaExporterStatus status) throws IOException, RestClientException {
        long lastOffset = status.getDeksOffset();
        EncryptionKey key = null;
        for (String subjectOrPrefix : subjects) {
            key = this.exportKeys(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, Long.MAX_VALUE);
        }
        return key;
    }

    private void saveStatus(SubjectValue lastSubjectValue, EncryptionKey lastEncryptionKey) {
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
        if (status != null && status.getState() == SchemaExporterStatus.State.STARTING) {
            status.setState(SchemaExporterStatus.State.RUNNING);
            status.setTrace(null);
            if (lastSubjectValue != null && lastSubjectValue.getOffset() > status.getOffset()) {
                status.setOffset(lastSubjectValue.getOffset());
                status.setTimestamp(lastSubjectValue.getTimestamp());
            }
            if (lastEncryptionKey != null && lastEncryptionKey.getOffset() > status.getDeksOffset()) {
                status.setDeksOffset(lastEncryptionKey.getOffset());
                status.setDeksTimestamp(lastEncryptionKey.getTimestamp());
            }
            this.exporterService().exporterStatuses().put((Object)this.exporter(), (Object)status);
        }
    }

    private void setModes(SchemaExporterInfo info, SchemaRegistryClient client, List<String> subjects) throws IOException, RestClientException, SchemaRegistryException {
        block5: {
            block4: {
                boolean hasPrefix = subjects.stream().anyMatch(s -> s.endsWith("*"));
                if (!hasPrefix) break block4;
                String subjectWithoutTenant = subjects.get(0);
                QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)subjectWithoutTenant);
                String context = SchemaExporterStartingTask.translateSubject(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), qs.toQualifiedContext());
                if (context == null) break block5;
                this.setMode(this.exporter(), client, context, false);
                break block5;
            }
            if (subjects.contains(":*:")) {
                for (String ctx : this.schemaRegistry().listContexts()) {
                    QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)(":" + ctx + ":"));
                    String context = SchemaExporterStartingTask.translateSubject(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), qs.toQualifiedContext());
                    if (context == null) continue;
                    this.setMode(this.exporter(), client, context, false);
                }
            } else {
                for (String subjectWithoutTenant : subjects) {
                    String context = SchemaExporterStartingTask.translateSubject(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), subjectWithoutTenant);
                    if (context == null) continue;
                    this.setMode(this.exporter(), client, context, false);
                }
            }
        }
    }
}

