/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterUpdateTask
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterUpdateTask.class);
    private final AbstractSchemaExporterTask.OffsetTimestamp latestValue;

    public SchemaExporterUpdateTask(SchemaExporterService exporterService, SchemaExporter exporter, AbstractSchemaExporterTask.OffsetTimestamp latestValue) {
        super(exporterService, exporter);
        this.latestValue = latestValue;
    }

    @Override
    public void run() {
        SchemaExporterStatus status;
        if (!this.exporterService().isLeader()) {
            return;
        }
        if (!"default".equals(this.tenant())) {
            this.schemaRegistry().setTenant(this.tenant());
        }
        if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) != null && status.getState() == SchemaExporterStatus.State.RUNNING && this.latestValue.getOffset() > status.getOffset()) {
            status.setOffset(this.latestValue.getOffset());
            status.setTimestamp(this.latestValue.getTimestamp());
            this.exporterService().exporterStatuses().put((Object)this.exporter(), (Object)status);
        }
    }
}

