/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage.utils;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.entities.CreateDekRequest;
import io.confluent.dekregistry.client.rest.entities.CreateKekRequest;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.client.rest.entities.UpdateKekRequest;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.exceptions.AlreadyExistsException;
import io.confluent.dekregistry.storage.exceptions.DekGenerationException;
import io.confluent.dekregistry.storage.exceptions.InvalidKeyException;
import io.confluent.dekregistry.storage.exceptions.KeyNotSoftDeletedException;
import io.confluent.dekregistry.storage.exceptions.KeyReferenceExistsException;
import io.confluent.dekregistry.storage.exceptions.TooManyKeysException;
import io.confluent.dekregistry.web.rest.exceptions.DekRegistryErrors;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LocalDekRegistryClient
implements DekRegistryClient {
    private final DekRegistry dekRegistry;

    public LocalDekRegistryClient(DekRegistry dekRegistry) {
        this.dekRegistry = dekRegistry;
    }

    public List<String> listKeks(boolean lookupDeleted) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public List<Integer> listDekVersions(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Kek getKek(String name, boolean lookupDeleted) throws IOException, RestClientException {
        KeyEncryptionKey key = this.dekRegistry.getKek(name, lookupDeleted);
        if (key == null) {
            throw DekRegistryErrors.keyNotFoundException((String)name);
        }
        return this.dekRegistry.toKekEntity(key);
    }

    public List<String> listDeks(String kekName, boolean lookupDeleted) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Dek getDek(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        return this.getDekVersion(kekName, subject, 1, algorithm, lookupDeleted);
    }

    public Dek getDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        VersionId versionId;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException((String)e.getMessage());
        }
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, lookupDeleted);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException((String)kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, versionId.getVersionId(), algorithm, lookupDeleted);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException((String)subject);
            }
            return key.toDekEntity();
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException((String)e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while retrieving key", (Throwable)e);
        }
    }

    public Dek getDekLatestVersion(String kekName, String subject, DekFormat algorithm, boolean lookupDeleted) throws IOException, RestClientException {
        return this.getDekVersion(kekName, subject, -1, algorithm, lookupDeleted);
    }

    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared) throws IOException, RestClientException {
        return this.createKek(name, kmsType, kmsKeyId, kmsProps, doc, shared, false);
    }

    public Kek createKek(String name, String kmsType, String kmsKeyId, Map<String, String> kmsProps, String doc, boolean shared, boolean deleted) throws IOException, RestClientException {
        CreateKekRequest request = new CreateKekRequest();
        request.setName(name);
        request.setKmsType(kmsType);
        request.setKmsKeyId(kmsKeyId);
        request.setKmsProps(kmsProps);
        request.setDoc(doc);
        request.setShared(shared);
        request.setDeleted(deleted);
        try {
            KeyEncryptionKey kek = this.dekRegistry.createKek(request);
            return this.dekRegistry.toKekEntity(kek);
        }
        catch (AlreadyExistsException e) {
            throw DekRegistryErrors.alreadyExistsException((String)e.getMessage());
        }
        catch (TooManyKeysException e) {
            throw DekRegistryErrors.tooManyKeysException((int)this.dekRegistry.config().maxKeys());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating key", (Throwable)e);
        }
    }

    public Dek createDek(String kekName, String subject, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(kekName, subject, 1, algorithm, encryptedKeyMaterial);
    }

    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial) throws IOException, RestClientException {
        return this.createDek(kekName, subject, version, algorithm, encryptedKeyMaterial, false);
    }

    public Dek createDek(String kekName, String subject, int version, DekFormat algorithm, String encryptedKeyMaterial, boolean deleted) throws IOException, RestClientException {
        KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, deleted);
        if (kek == null) {
            throw DekRegistryErrors.keyNotFoundException((String)kekName);
        }
        CreateDekRequest request = new CreateDekRequest();
        request.setSubject(subject);
        request.setVersion(Integer.valueOf(version));
        request.setAlgorithm(algorithm);
        request.setEncryptedKeyMaterial(encryptedKeyMaterial);
        request.setDeleted(deleted);
        try {
            return this.dekRegistry.createDek(kekName, request).toDekEntity();
        }
        catch (AlreadyExistsException e) {
            throw DekRegistryErrors.alreadyExistsException((String)e.getMessage());
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException((String)e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo((String)e.getMessage());
        }
        catch (TooManyKeysException e) {
            throw DekRegistryErrors.tooManyKeysException((int)this.dekRegistry.config().maxKeys());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating key", (Throwable)e);
        }
    }

    public Kek updateKek(String name, Map<String, String> kmsProps, String doc, Boolean shared) throws IOException, RestClientException {
        UpdateKekRequest request = new UpdateKekRequest();
        request.setKmsProps(kmsProps);
        request.setDoc(doc);
        request.setShared(shared);
        try {
            KeyEncryptionKey kek = this.dekRegistry.putKek(name, request);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException((String)name);
            }
            return this.dekRegistry.toKekEntity(kek);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating key", (Throwable)e);
        }
    }

    public void deleteKek(String kekName, boolean permanentDelete) throws IOException, RestClientException {
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException((String)kekName);
            }
            this.dekRegistry.deleteKek(kekName, permanentDelete);
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException((String)e.getName());
        }
        catch (KeyReferenceExistsException e) {
            throw DekRegistryErrors.referenceExistsException((String)e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    public void deleteDek(String kekName, String subject, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException((String)kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getLatestDek(kekName, subject, algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException((String)subject);
            }
            this.dekRegistry.deleteDek(kekName, subject, algorithm, permanentDelete);
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException((String)e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    public void deleteDekVersion(String kekName, String subject, int version, DekFormat algorithm, boolean permanentDelete) throws IOException, RestClientException {
        VersionId versionId;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException((String)e.getMessage());
        }
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException((String)kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, versionId.getVersionId(), algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException((String)subject);
            }
            this.dekRegistry.deleteDekVersion(kekName, subject, versionId.getVersionId(), algorithm, permanentDelete);
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException((String)e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    public void undeleteKek(String kekName) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public void undeleteDek(String kekName, String subject, DekFormat algorithm) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public void undeleteDekVersion(String kekName, String subject, int version, DekFormat algorithm) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
    }
}

