/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.web.rest.resources;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.schema.exporter.client.rest.entities.CreateExporterRequest;
import io.confluent.schema.exporter.client.rest.entities.CreateExporterResponse;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.client.rest.entities.ExporterStatus;
import io.confluent.schema.exporter.client.rest.entities.UpdateExporterRequest;
import io.confluent.schema.exporter.client.rest.entities.UpdateExporterResponse;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.exceptions.AlreadyExistsException;
import io.confluent.schema.exporter.storage.exceptions.AlreadyRunningException;
import io.confluent.schema.exporter.storage.exceptions.AlreadyStartingException;
import io.confluent.schema.exporter.storage.exceptions.NotPausedException;
import io.confluent.schema.exporter.storage.exceptions.TooManyExportersException;
import io.confluent.schema.exporter.web.rest.exceptions.ExporterErrors;
import io.confluent.schema.exporter.web.rest.resources.SchemaRegistryResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/exporters")
@Singleton
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemaExporterResource
extends SchemaRegistryResource {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterResource.class);
    private final SchemaExporterService exporterService;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    @Inject
    public SchemaExporterResource(SchemaRegistry schemaRegistry, SchemaExporterService exporterService) {
        super(schemaRegistry);
        this.exporterService = exporterService;
    }

    @GET
    @Operation(summary="Get a list of exporter names.")
    @PerformanceMetric(value="exporters.list")
    @DocumentedName(value="getExporters")
    public List<String> getExporters() {
        return this.exporterService.getExporterNames();
    }

    @GET
    @Path(value="/{name}")
    @Operation(summary="Get the info for an exporter.", responses={@ApiResponse(responseCode="200", description="The exporter info", content={@Content(schema=@Schema(implementation=ExporterInfo.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.get-info")
    @DocumentedName(value="getExporterInfo")
    public ExporterInfo getExporterInfo(@PathParam(value="name") String name) {
        ExporterInfo info = this.exporterService.getExporterInfo(name);
        if (info == null) {
            throw ExporterErrors.exporterNotFoundException(name);
        }
        return info;
    }

    @GET
    @Path(value="/{name}/config")
    @Operation(summary="Get the config for an exporter.", responses={@ApiResponse(responseCode="200", description="The exporter info", content={@Content(schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.get-config")
    @DocumentedName(value="getExporterConfig")
    public Map<String, String> getExporterConfig(@PathParam(value="name") String name) {
        ExporterInfo info = this.exporterService.getExporterInfo(name);
        if (info == null) {
            throw ExporterErrors.exporterNotFoundException(name);
        }
        return info.getConfig();
    }

    @GET
    @Path(value="/{name}/status")
    @Operation(summary="Get the status for an exporter.", responses={@ApiResponse(responseCode="200", description="The exporter status", content={@Content(schema=@Schema(implementation=ExporterStatus.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.get-status")
    @DocumentedName(value="getExporterStatus")
    public ExporterStatus getExporterStatus(@PathParam(value="name") String name) {
        ExporterStatus status = this.exporterService.getExporterStatus(name);
        if (status == null) {
            throw ExporterErrors.exporterNotFoundException(name);
        }
        return status;
    }

    @POST
    @Operation(summary="Create an exporter.", responses={@ApiResponse(responseCode="200", description="The create response", content={@Content(schema=@Schema(implementation=CreateExporterResponse.class))})})
    @PerformanceMetric(value="exporters.create")
    @DocumentedName(value="createExporter")
    public void createExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The create request", required=true) @NotNull CreateExporterRequest request) {
        log.debug("Creating exporter {}", (Object)request.getName());
        if (request.getName() == null || request.getName().isEmpty()) {
            throw ExporterErrors.invalidOrMissingExporterName(request.getName());
        }
        if (request.getConfig() == null || request.getConfig().isEmpty()) {
            throw ExporterErrors.invalidOrMissingExporterConfig(request.getName());
        }
        if (request.getSubjects() != null && request.getSubjects().size() > 1 && request.getSubjects().stream().anyMatch(s -> s.equals(":*:") || s.endsWith("*"))) {
            throw ExporterErrors.invalidExporterSubjects(request.getName());
        }
        request.setContext(this.validateContext(request.getName(), request.getContextType(), request.getContext()));
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.createExporterOrForward(request, headerProperties);
            CreateExporterResponse response = new CreateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (AlreadyExistsException e) {
            throw ExporterErrors.alreadyExistsException(request.getName());
        }
        catch (TooManyExportersException e) {
            throw ExporterErrors.tooManyExportersException(this.exporterService.config().exporterMaxExporters());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating exporter", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}")
    @Operation(summary="Alters an exporter.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=UpdateExporterResponse.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.put-info")
    @DocumentedName(value="updateExporter")
    public void putExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name, @Parameter(description="The update request", required=true) @NotNull UpdateExporterRequest request) {
        log.debug("Setting info for exporter {}", (Object)name);
        if (request.getSubjects() != null && request.getSubjects().size() > 1 && request.getSubjects().stream().anyMatch(s -> s.equals(":*:") || s.endsWith("*"))) {
            throw ExporterErrors.invalidExporterSubjects(name);
        }
        request.setContext(this.validateContext(name, request.getContextType(), request.getContext()));
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.putExporterOrForward(name, request, headerProperties);
            if (exporter == null) {
                throw ExporterErrors.exporterNotFoundException(name);
            }
            UpdateExporterResponse response = new UpdateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (NotPausedException e) {
            throw ExporterErrors.notPausedException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating exporter", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}/config")
    @Operation(summary="Alters the config of an exporter.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=UpdateExporterResponse.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.put-config")
    @DocumentedName(value="updateExporterConfig")
    public void putExporterConfig(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name, @Parameter(description="The exporter config", required=true) Map<String, String> config) {
        log.debug("Setting config for exporter {}", (Object)name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.putExporterConfigOrForward(name, config, headerProperties);
            if (exporter == null) {
                throw ExporterErrors.exporterNotFoundException(name);
            }
            UpdateExporterResponse response = new UpdateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (NotPausedException e) {
            throw ExporterErrors.notPausedException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating exporter", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}/pause")
    @Operation(summary="Pause an exporter.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=UpdateExporterResponse.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.pause")
    @DocumentedName(value="pauseExporter")
    public void pauseExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name) {
        log.debug("Pausing exporter {}", (Object)name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.pauseExporterOrForward(name, headerProperties);
            if (exporter == null) {
                throw ExporterErrors.exporterNotFoundException(name);
            }
            UpdateExporterResponse response = new UpdateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (AlreadyStartingException e) {
            throw ExporterErrors.alreadyStartingException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating exporter", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}/resume")
    @Operation(summary="Resume an exporter.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=UpdateExporterResponse.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.resume")
    @DocumentedName(value="resumeExporter")
    public void resumeExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name) {
        log.debug("Resuming exporter {}", (Object)name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.resumeExporterOrForward(name, headerProperties);
            if (exporter == null) {
                throw ExporterErrors.exporterNotFoundException(name);
            }
            UpdateExporterResponse response = new UpdateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (AlreadyRunningException e) {
            throw ExporterErrors.alreadyRunningException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while pausing exporter", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}/reset")
    @Operation(summary="Reset an exporter.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=UpdateExporterResponse.class))}), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.reset")
    @DocumentedName(value="resetExporter")
    public void resetExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name) {
        log.debug("Resetting exporter {}", (Object)name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            SchemaExporter exporter = this.exporterService.resetExporterOrForward(name, headerProperties);
            if (exporter == null) {
                throw ExporterErrors.exporterNotFoundException(name);
            }
            UpdateExporterResponse response = new UpdateExporterResponse();
            response.setName(exporter.getName());
            asyncResponse.resume((Object)response);
        }
        catch (NotPausedException e) {
            throw ExporterErrors.notPausedException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while resetting exporter", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{name}")
    @Operation(summary="Delete an exporter.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Error code 40450 -- Exporter not found")})
    @PerformanceMetric(value="exporters.delete")
    @DocumentedName(value="deleteExporter")
    public void deleteExporter(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the exporter", required=true) @PathParam(value="name") String name) {
        log.debug("Deleting exporter {}", (Object)name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            this.exporterService.deleteExporterOrForward(name, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (NotPausedException e) {
            throw ExporterErrors.notPausedException(name);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while resetting exporter", (Throwable)e);
        }
    }

    private String validateContext(String name, ExporterInfo.ContextType contextType, String context) {
        if (context == null) {
            if (contextType == ExporterInfo.ContextType.CUSTOM) {
                throw ExporterErrors.invalidOrMissingContext(name);
            }
            return context;
        }
        if (context.startsWith(":")) {
            context = context.substring(1);
        }
        if (context.endsWith(":")) {
            context = context.substring(0, context.length() - 1);
        }
        if (context.contains(":")) {
            throw ExporterErrors.invalidOrMissingContext(name);
        }
        if (context.equals("*")) {
            throw ExporterErrors.invalidOrMissingContext(name);
        }
        return context;
    }
}

