/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.confluent.security.authentication.http.HttpClientAuthFilter;
import io.confluent.security.authentication.utils.JacksonSerde;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;

public class ConfigurableHttpClient
implements AutoCloseable {
    private final Client client;
    private final HttpClientAuthFilter defaultAuthFilter;

    private ConfigurableHttpClient(int connectTimeoutMillis, int readTimeoutMillis, SSLContext sslContext, HostnameVerifier hostnameVerifier, ClientConfig clientConfig) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (Objects.nonNull(clientConfig)) {
            builder.withConfig((Configuration)clientConfig);
        }
        builder.connectTimeout((long)connectTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS).register((Object)new JacksonJaxbJsonProvider(JacksonSerde.jsonMapper(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
        this.defaultAuthFilter = new HttpClientAuthFilter(null);
        if (Objects.nonNull(sslContext)) {
            builder.sslContext(sslContext).hostnameVerifier(hostnameVerifier);
        }
        this.client = builder.build();
    }

    public WebTarget target(URI targetUri) {
        return (WebTarget)this.client.target(targetUri).register((Object)this.defaultAuthFilter);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static class Builder {
        private int connectTimeoutMillis = 18000;
        private int readTimeoutMillis = 30000;
        private HostnameVerifier hostnameVerifier;
        private SSLContext sslContext;
        private ClientConfig clientConfig;

        private Builder() {
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder readTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder hostNameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public ConfigurableHttpClient build() {
            return new ConfigurableHttpClient(this.connectTimeoutMillis, this.readTimeoutMillis, this.sslContext, this.hostnameVerifier, this.clientConfig);
        }
    }
}

