/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Action;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AuthorizeRequest {
    public final String userPrincipal;
    public final Set<String> groups;
    public final String host;
    public final List<Action> actions;

    public AuthorizeRequest(String userPrincipal, List<Action> actions) {
        this(userPrincipal, Collections.emptySet(), "", actions);
    }

    public AuthorizeRequest(String userPrincipal, String host, List<Action> actions) {
        this(userPrincipal, Collections.emptySet(), host, actions);
    }

    @JsonCreator
    public AuthorizeRequest(@JsonProperty(value="userPrincipal") String userPrincipal, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="host") String host, @JsonProperty(value="actions") List<Action> actions) {
        this.userPrincipal = userPrincipal;
        this.groups = groups;
        this.host = Objects.toString(host, "");
        this.actions = actions;
    }

    public String toString() {
        return "AuthorizeRequest{userPrincipal='" + this.userPrincipal + '\'' + ", groups=" + this.groups + ", host='" + this.host + '\'' + ", actions=" + this.actions + '}';
    }
}

