/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.comparators.MdsResourcePatternComparator;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ScopeRoleBindingMapping;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.rbacapi.utils.RoleUtilsBase;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class LookupResource {
    private final AuthCache authCache;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final MdsScopeConverter mdsScopeConverter;
    private final Map<String, String> displayNamesByName;

    public LookupResource(AuthCache authCache, SecurityMetadataAuthorizer metadataAuthorizer, MdsScopeConverter mdsScopeConverter) {
        this.authCache = authCache;
        this.metadataAuthorizer = metadataAuthorizer;
        this.mdsScopeConverter = mdsScopeConverter;
        this.displayNamesByName = RoleUtilsBase.mapRoleDisplayNamesByName(authCache.rbacRoles().roles());
    }

    public List<String> lookupPrincipalsWithRole(SecurityContext context, String roleName, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.DESCRIBE);
        return this.authCache.rbacRoleBindings(scope).stream().filter(rb -> rb.role().equals(roleName) || this.displayNamesByName.get(rb.role()).equals(roleName)).map(rb -> rb.principal().toString()).distinct().sorted().collect(Collectors.toList());
    }

    public List<String> lookupPrincipalsWithRoleOnResource(SecurityContext context, String roleName, String resourceType, String resourceName, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        try {
            this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.DESCRIBE, false);
        }
        catch (AuthorizationException e) {
            Set<ResourcePattern> resourcePatterns = Collections.singleton(new ResourcePattern(resourceType, resourceName, PatternType.LITERAL));
            this.metadataAuthorizer.authorizeResourceAccess(context, scope, resourcePatterns, SecurityMetadataAuthorizer.DESCRIBE_ACCESS);
        }
        ResourceType type = new ResourceType(resourceType);
        ResourcePatternFilter patternFilter = new ResourcePatternFilter(type, resourceName, PatternType.MATCH);
        RoleBindingFilter filter = new RoleBindingFilter(null, roleName, scope, patternFilter);
        return this.principals(filter);
    }

    private List<String> principals(RoleBindingFilter filter) {
        Set bindings = this.authCache.rbacRoleBindings(filter);
        return bindings.stream().map(b -> b.principal().toString()).distinct().sorted().collect(Collectors.toList());
    }

    public List<String> getScopedRoleNames(SecurityContext context, KafkaPrincipal targetPrincipal, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.DESCRIBE);
        Set roleAssignments = this.authCache.rbacRoleBindings(scope);
        HashSet<KafkaPrincipal> principalsToLookFor = new HashSet<KafkaPrincipal>();
        principalsToLookFor.add(targetPrincipal);
        if (StringUtils.equals((CharSequence)"User", (CharSequence)targetPrincipal.getPrincipalType())) {
            principalsToLookFor.addAll(this.authCache.groups(targetPrincipal));
        }
        return roleAssignments.stream().filter(roleAssignment -> principalsToLookFor.contains(roleAssignment.principal())).map(RoleBinding::role).map(this.displayNamesByName::get).distinct().sorted().collect(Collectors.toList());
    }

    public Map<String, Map<String, List<ResourcePattern>>> lookupResourcesForPrincipal(SecurityContext context, KafkaPrincipal targetPrincipal, MdsScope mdsScope) {
        Set<KafkaPrincipal> matchingPrincipals;
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        String principalType = targetPrincipal.getPrincipalType();
        if ("User".equals(principalType)) {
            this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, scope, targetPrincipal, SecurityMetadataAuthorizer.DESCRIBE);
            matchingPrincipals = new HashSet<KafkaPrincipal>(this.authCache.groups(targetPrincipal));
            matchingPrincipals.add(targetPrincipal);
        } else if ("Group".equals(principalType)) {
            this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.DESCRIBE);
            matchingPrincipals = Collections.singleton(targetPrincipal);
        } else {
            throw new RuntimeException("Invalid principal type. Should be 'User' or 'Group'");
        }
        Map<String, Map<String, List<ResourcePattern>>> response = this.authCache.rbacRoleBindings(scope).stream().filter(rb -> matchingPrincipals.contains(rb.principal())).collect(Collectors.toMap(rb -> rb.principal().toString(), rb -> {
            HashMap map = new HashMap();
            ArrayList<ResourcePattern> resourcePatterns = new ArrayList<ResourcePattern>(rb.resources());
            resourcePatterns.sort(MdsResourcePatternComparator.getInstance());
            map.put(this.displayNamesByName.get(rb.role()), resourcePatterns);
            return map;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }));
        return response;
    }

    public List<ScopeRoleBindingMapping> rolebindingsForAllKnownClusters(SecurityContext context, KafkaPrincipal targetPrincipal, ClusterType clusterType) {
        Set roleBindings;
        this.metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, targetPrincipal, SecurityMetadataAuthorizer.DESCRIBE);
        if (clusterType != null) {
            Set scopes = this.authCache.knownScopes().stream().filter(ClusterType.filterScopeBy(clusterType)).collect(Collectors.toSet());
            roleBindings = this.authCache.rbacRoleBindings(targetPrincipal, scopes);
        } else {
            roleBindings = this.authCache.rbacRoleBindings(targetPrincipal);
        }
        return this.toScopesAndRolesBindingsMapping(roleBindings, targetPrincipal);
    }

    private ScopeRoleBindingMapping getNamedScopeRoleBindingMapping(Scope scope, KafkaPrincipal principal) {
        MdsScope mdsScope = this.mdsScopeConverter.getMdsScope(principal, scope);
        return new ScopeRoleBindingMapping(mdsScope);
    }

    private List<ScopeRoleBindingMapping> toScopesAndRolesBindingsMapping(Set<RoleBinding> roleBindings, KafkaPrincipal principal) {
        HashMap<Scope, ScopeRoleBindingMapping> scopeRoleBindingMappings = new HashMap<Scope, ScopeRoleBindingMapping>();
        for (RoleBinding roleBinding : roleBindings) {
            ScopeRoleBindingMapping scopeRoleBinding = scopeRoleBindingMappings.getOrDefault(roleBinding.scope(), this.getNamedScopeRoleBindingMapping(roleBinding.scope(), principal));
            scopeRoleBinding.addRoleBinding(roleBinding);
            scopeRoleBindingMappings.put(roleBinding.scope(), scopeRoleBinding);
        }
        return scopeRoleBindingMappings.values().stream().sorted().collect(Collectors.toList());
    }
}

