/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import io.confluent.rbacapi.comparators.MdsResourcePatternComparator;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RoleBindingProcessing {
    private final Authorizer authorizer;
    private final AuthCache authCache;

    public RoleBindingProcessing(Authorizer authorizer, AuthCache authCache) {
        this.authorizer = authorizer;
        this.authCache = authCache;
    }

    public OperationGuidelines guidelines(KafkaPrincipal targetPrincipal, ResourceType resourceType, Scope scope, Operation operation) {
        Action allAction = new Action(scope, resourceType, "*", operation);
        AuthorizeResult result = (AuthorizeResult)this.authorizer.authorize(targetPrincipal, "", Collections.singletonList(allAction)).get(0);
        if (result == AuthorizeResult.ALLOWED) {
            return new OperationGuidelines(OperationsResult.ANY, Collections.emptyList());
        }
        HashSet<KafkaPrincipal> targetPrincipals = new HashSet<KafkaPrincipal>();
        targetPrincipals.add(targetPrincipal);
        if (StringUtils.equals((CharSequence)"User", (CharSequence)targetPrincipal.getPrincipalType())) {
            targetPrincipals.addAll(this.authCache.groups(targetPrincipal));
        }
        Set targetResourceRoles = this.authCache.rbacRoles().roles().stream().filter(role -> role.flatAccessPolicies().stream().anyMatch(ap -> ap.bindWithResource() && ap.allowedOperations(resourceType).contains(operation))).map(Role::name).collect(Collectors.toSet());
        Set allRoleBindingsAtScope = this.authCache.rbacRoleBindings(scope);
        List<ResourcePattern> resourcePatterns = allRoleBindingsAtScope.stream().filter(roleBinding -> targetResourceRoles.contains(roleBinding.role())).filter(roleBinding -> targetPrincipals.contains(roleBinding.principal())).flatMap(roleBinding -> roleBinding.resources().stream()).filter(resourcePattern -> resourceType.equals((Object)resourcePattern.resourceType())).distinct().collect(Collectors.toList());
        if (resourcePatterns.size() == 0) {
            return new OperationGuidelines(OperationsResult.NONE, Collections.emptyList());
        }
        List<ResourcePattern> squashedResults = RoleBindingProcessing.squashPatterns(resourcePatterns);
        squashedResults.sort(MdsResourcePatternComparator.getInstance());
        return new OperationGuidelines(OperationsResult.SOME, squashedResults);
    }

    @VisibleForTesting
    public static List<ResourcePattern> squashPatterns(List<ResourcePattern> patterns) {
        if (patterns.size() <= 1) {
            return patterns;
        }
        ArrayList<ResourcePattern> prefixPatterns = new ArrayList<ResourcePattern>();
        ArrayList<ResourcePattern> literalPatterns = new ArrayList<ResourcePattern>();
        for (ResourcePattern pattern : patterns) {
            if (PatternType.LITERAL.equals((Object)pattern.patternType())) {
                literalPatterns.add(pattern);
                continue;
            }
            if (!PatternType.PREFIXED.equals((Object)pattern.patternType())) continue;
            prefixPatterns.add(pattern);
        }
        if (literalPatterns.size() == 0 || prefixPatterns.size() == 0) {
            return patterns;
        }
        ConcurrentInvertedRadixTree prefixTree = new ConcurrentInvertedRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
        prefixPatterns.forEach(arg_0 -> RoleBindingProcessing.lambda$squashPatterns$6((InvertedRadixTree)prefixTree, arg_0));
        List<ResourcePattern> squashedResults = RoleBindingProcessing.squashPrefixes((InvertedRadixTree<ResourcePattern>)prefixTree, prefixPatterns);
        squashedResults.addAll(RoleBindingProcessing.squashLiterals((InvertedRadixTree<ResourcePattern>)prefixTree, literalPatterns));
        return squashedResults;
    }

    private static List<ResourcePattern> squashPrefixes(InvertedRadixTree<ResourcePattern> prefixTree, List<ResourcePattern> prefixPatterns) {
        return prefixPatterns.stream().filter(prefixPattern -> RoleBindingProcessing.findPattern(prefixTree, prefixPattern)).collect(Collectors.toList());
    }

    private static boolean findPattern(InvertedRadixTree<ResourcePattern> prefixTree, ResourcePattern targetPattern) {
        Iterator iter = prefixTree.getValuesForKeysPrefixing((CharSequence)targetPattern.name()).iterator();
        if (!iter.hasNext()) {
            return false;
        }
        ResourcePattern pattern = (ResourcePattern)iter.next();
        return !iter.hasNext() && targetPattern.equals((Object)pattern);
    }

    private static List<ResourcePattern> squashLiterals(InvertedRadixTree<ResourcePattern> prefixTree, List<ResourcePattern> literalPatterns) {
        return literalPatterns.stream().filter(literalPattern -> !prefixTree.getKeysPrefixing((CharSequence)literalPattern.name()).iterator().hasNext()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$squashPatterns$6(InvertedRadixTree prefixTree, ResourcePattern pattern) {
        ResourcePattern cfr_ignored_0 = (ResourcePattern)prefixTree.put((CharSequence)pattern.name(), (Object)pattern);
    }

    public static class OperationGuidelines {
        @JsonProperty
        public final OperationsResult operationsResult;
        @JsonProperty
        public final List<ResourcePattern> resourcePatterns;

        @JsonCreator
        public OperationGuidelines(@JsonProperty(value="result") OperationsResult operationsResult, @JsonProperty(value="resourcePatterns") List<ResourcePattern> resourcePatterns) {
            this.operationsResult = operationsResult;
            this.resourcePatterns = resourcePatterns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationGuidelines that = (OperationGuidelines)o;
            return this.operationsResult == that.operationsResult && Objects.equals(this.resourcePatterns, that.resourcePatterns);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operationsResult, this.resourcePatterns});
        }
    }

    public static enum OperationsResult {
        ANY,
        SOME,
        NONE;

    }
}

