/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.utils;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.cloud.rbac.CloudRoleBinding;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import io.confluent.security.rbac.RoleBinding;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoleUtilsBase {
    private static final Logger log = LoggerFactory.getLogger(RoleUtilsBase.class);

    public static Map<String, Role> mapRolesByName(Collection<Role> roles) {
        return RoleUtilsBase.mapRolesByName(roles, role -> true);
    }

    public static Map<String, Role> mapRolesByName(Collection<Role> roles, Predicate<Role> filter) {
        return roles.stream().filter(filter).collect(Collectors.toMap(role -> role.name(), role -> role));
    }

    public static Map<String, String> mapRoleDisplayNamesByName(Collection<Role> roles) {
        return roles.stream().collect(Collectors.toMap(Role::name, Role::displayName));
    }

    public static Map<String, Set<String>> mapRoleNamesByDisplayName(Collection<Role> roles) {
        return roles.stream().collect(Collectors.groupingBy(Role::displayName, Collectors.mapping(Role::name, Collectors.toSet())));
    }

    public Role resolveRoleByDisplayName(Collection<Role> roles, String name, Scope scope) {
        return roles.stream().filter(r -> r.displayName().equals(name) || r.name().equals(name)).filter(r -> r.mostSpecificBindingScope().equals(this.bindingScope(scope))).findFirst().orElse(null);
    }

    @VisibleForTesting
    public Role resolveRoleByDisplayNameAndResource(Collection<Role> roles, String name, Scope scope, List<ResourcePattern> resourcePatterns) {
        Set resourceTypes = resourcePatterns.stream().map(r -> r.resourceType().name()).collect(Collectors.toSet());
        log.debug("Resource types associated with resource pattern: {}", resourceTypes);
        return roles.stream().filter(r -> r.displayName().equals(name) || r.name().equals(name)).filter(r -> r.mostSpecificBindingScope().equals(this.bindingScope(scope))).filter(r -> r.flatAccessPolicies().stream().flatMap(ap -> ap.allowedOperations().stream().map(o -> o.resourceType())).anyMatch(resourceTypes::contains)).findFirst().orElse(null);
    }

    public RoleBinding roleBindingWithDisplayName(Map<String, String> displayNamesByName, RoleBinding binding) {
        return new RoleBinding(binding.principal(), displayNamesByName.get(binding.role()), binding.scope(), binding.resources());
    }

    public static CloudRoleBinding roleBindingWithDisplayName(Map<String, String> displayNamesByName, CloudRoleBinding binding) {
        return new CloudRoleBinding(binding.getResourceId(), binding.getPrincipal(), displayNamesByName.get(binding.getRole()), binding.getScope(), binding.getResourcePattern(), binding.getCreated(), binding.getModified(), binding.getDeleted(), binding.getLastChangeId());
    }

    public Set<RoleBinding> roleBindingsWithDisplayNames(Map<String, String> displayNamesByName, Set<RoleBinding> bindings) {
        return bindings.stream().map(rb -> this.roleBindingWithDisplayName(displayNamesByName, (RoleBinding)rb)).collect(Collectors.toSet());
    }

    public static List<CloudRoleBinding> roleBindingsWithDisplayNames(Map<String, String> displayNamesByName, List<CloudRoleBinding> bindings) {
        return bindings.stream().map(rb -> RoleUtilsBase.roleBindingWithDisplayName(displayNamesByName, rb)).collect(Collectors.toList());
    }

    public Role getNamedRoleByResourceType(Collection<Role> roles, String roleName, Scope scope, List<ResourcePattern> resourcePattern) {
        Role role = resourcePattern.isEmpty() ? this.resolveRoleByDisplayName(roles, roleName, scope) : this.resolveRoleByDisplayNameAndResource(roles, roleName, scope, resourcePattern);
        if (role == null) {
            throw new ClientErrorException(String.format("No role %s at scope %s", roleName, scope), 400);
        }
        return role;
    }

    public abstract String bindingScope(Scope var1);
}

