/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.common;

import io.confluent.security.rbac.RbacRoles;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={OperationValidator.class})
public @interface ValidOperation {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Operation. Found: ${validatedValue}";

    public static class OperationValidator
    implements ConstraintValidator<ValidOperation, String> {
        private static final Set<String> VALID_OPERATIONS = new HashSet<String>();

        public static void loadOperations(RbacRoles rbacRoles) {
            rbacRoles.roles().stream().flatMap(r -> r.flatAccessPolicies().stream()).flatMap(ap -> ap.allowedOperations().stream()).flatMap(ro -> ro.operations().stream()).forEach(VALID_OPERATIONS::add);
        }

        public void initialize(ValidOperation constraintAnnotation) {
        }

        public boolean isValid(String operation, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (!VALID_OPERATIONS.contains(operation)) {
                context.buildConstraintViolationWithTemplate("Invalid operation : " + operation).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

