/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.entities.AuthorizeRequest;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.security.authorizer.Action;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PrincipalValidator.class})
public @interface V1ValidAuthorizeRequest {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid AuthorizeRequest";

    public static class PrincipalValidator
    implements ConstraintValidator<V1ValidAuthorizeRequest, AuthorizeRequest> {
        private static final V1ValidationUtil validationUtil = new V1ValidationUtil();

        public void initialize(V1ValidAuthorizeRequest constraintAnnotation) {
        }

        public boolean isValid(AuthorizeRequest authorizeRequest, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (StringUtils.isEmpty((CharSequence)authorizeRequest.userPrincipal)) {
                context.buildConstraintViolationWithTemplate("No userPrincipal defined.").addConstraintViolation();
                return false;
            }
            if (authorizeRequest.actions == null) {
                context.buildConstraintViolationWithTemplate("No actions defined.").addConstraintViolation();
                return false;
            }
            for (Action action : authorizeRequest.actions) {
                try {
                    validationUtil.verifyScope(action.scope());
                }
                catch (ConstraintViolationException cve) {
                    String message = cve.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
                    context.buildConstraintViolationWithTemplate("Invalid Scope in AuthorizeRequest => " + message).addConstraintViolation();
                    return false;
                }
            }
            return true;
        }
    }
}

