/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.security.authorizer.Scope;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Payload;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ClusterInfoListValidator.class})
public @interface V1ValidClusterInfoList {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid ClusterInfo List";

    public static class ClusterInfoListValidator
    implements ConstraintValidator<V1ValidClusterInfoList, List<ClusterInfo>> {
        private static final V1ValidationUtil validationUtil = new V1ValidationUtil();

        public void initialize(V1ValidClusterInfoList constraintAnnotation) {
        }

        public boolean isValid(List<ClusterInfo> clusterInfoList, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (clusterInfoList == null) {
                context.buildConstraintViolationWithTemplate("ClusterInfo List should be included in the request body").addConstraintViolation();
                return false;
            }
            HashSet<String> clusterNames = new HashSet<String>();
            HashSet<Scope> clusterScopes = new HashSet<Scope>();
            for (ClusterInfo clusterInfo : clusterInfoList) {
                try {
                    validationUtil.verifyClusterInfo(clusterInfo);
                }
                catch (ConstraintViolationException cve) {
                    String message = cve.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(","));
                    context.buildConstraintViolationWithTemplate("Invalid ClusterInfo List => " + message).addConstraintViolation();
                    return false;
                }
                if (!clusterNames.add(clusterInfo.getClusterName())) {
                    context.buildConstraintViolationWithTemplate(String.format("Duplicate cluster name %s", clusterInfo.getClusterName())).addConstraintViolation();
                    return false;
                }
                if (clusterScopes.add(clusterInfo.getScope())) continue;
                context.buildConstraintViolationWithTemplate(String.format("Duplicate cluster scope %s", clusterInfo.getScope())).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

