/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.confluent.auditlog.emitter.utils.CloudResourceBuilder;
import io.confluent.auditlog.emitter.utils.CloudResourceUtils;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.AuthenticationInfo;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Principal;
import io.confluent.protobuf.events.auditlog.v2.Request;
import io.confluent.protobuf.events.auditlog.v2.RequestMetadata;
import io.confluent.protobuf.events.auditlog.v2.ResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.rbacapi.entities.ResourcesRequest;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AuditLogUtils {
    public static final String REQUEST_ID = "X-B3-Traceid";
    public static final String CLIENT_IP = "X-Real-IP";

    private static FullyQualifiedCloudResourceRef getCloudResource(Scope scope) {
        CloudResourceBuilder builder = new CloudResourceBuilder();
        List path = scope.path();
        if (path != null) {
            for (String each : path) {
                String[] split = each.split("=");
                TypedCloudResourceRef typeCloudResourceRef = CloudResourceUtils.getTypedCloudResourceRef((String)split[0], (String)split[1]);
                builder.addResource(typeCloudResourceRef.getType(), typeCloudResourceRef.getResourceId(), "");
            }
        }
        if (scope.clusters() != null) {
            scope.clusters().forEach((k, v) -> {
                TypedCloudResourceRef typeCloudResourceRef = CloudResourceUtils.getTypedCloudResourceRef((String)k, (String)v);
                builder.addResource(typeCloudResourceRef.getType(), typeCloudResourceRef.getResourceId(), "");
            });
        }
        return builder.build();
    }

    private static AuthenticationInfo getAuthenticationInfo(String principalResourceId) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.newBuilder().setPrincipal(Principal.newBuilder().setConfluentUser(ResourceRef.newBuilder().setResourceId(principalResourceId))).setResult(AuthenticationInfo.Result.SUCCESS).setExposure(AuthenticationInfo.Exposure.CUSTOMER).build();
        return authenticationInfo;
    }

    private static RequestMetadata getRequestMetadata(String requestId, String clientIp) {
        requestId = requestId == null ? "" : requestId;
        clientIp = clientIp == null ? "" : clientIp;
        RequestMetadata requestMetadata = RequestMetadata.newBuilder().addRequestId(requestId).addClientAddress(RequestMetadata.Address.newBuilder().setIp(clientIp)).build();
        return requestMetadata;
    }

    private static Request.AccessType getAccessType(String kind) {
        if ((kind = kind.toLowerCase()).startsWith("add") || kind.startsWith("remove") || kind.startsWith("bind") || kind.startsWith("unbind") || kind.startsWith("grant") || kind.startsWith("revoke")) {
            return Request.AccessType.MODIFICATION;
        }
        if (kind.startsWith("list") || kind.startsWith("get")) {
            return Request.AccessType.READ_ONLY;
        }
        return Request.AccessType.UNKNOWN;
    }

    private static Request getRequest(String version, String displayName, String kind, String targetPrincipalResourceId, String roleName, ResourcesRequest resourcesRequest) {
        Struct.Builder builder = AuditLogUtils.structBuilder(null, "api_version", version);
        AuditLogUtils.structBuilder(builder, "display_name", displayName);
        if (roleName == null) {
            AuditLogUtils.structBuilder(builder, "role_name", "null");
        } else {
            AuditLogUtils.structBuilder(builder, "role_name", roleName);
        }
        AuditLogUtils.structBuilder(builder, "target_principal", targetPrincipalResourceId);
        List<Object> resourcesPatterns = new ArrayList<Value>();
        if (resourcesRequest != null && resourcesRequest.resourcePatterns != null) {
            resourcesPatterns = resourcesRequest.resourcePatterns.stream().map(resourcePattern -> Value.newBuilder().setStructValue(Struct.newBuilder().putFields("resource_type", Value.newBuilder().setStringValue(resourcePattern.resourceType().toString()).build()).putFields("name", Value.newBuilder().setStringValue(resourcePattern.name()).build()).putFields("pattern_type", Value.newBuilder().setStringValue(resourcePattern.patternType().toString()).build()).build()).build()).collect(Collectors.toList());
        }
        if (resourcesRequest != null) {
            AuditLogUtils.structBuilder(builder, "resource_patterns", resourcesPatterns);
        }
        Request request = Request.newBuilder().setAccessType(AuditLogUtils.getAccessType(kind)).setData(builder).build();
        return request;
    }

    public static Result getResult(Result.Status status) {
        Result result = Result.newBuilder().setStatus(status).build();
        return result;
    }

    private static Struct.Builder structBuilder(Struct.Builder builder, String key, String value) {
        if (builder == null) {
            return Struct.newBuilder().putFields(key, Value.newBuilder().setStringValue(value).build());
        }
        return builder.putFields(key, Value.newBuilder().setStringValue(value).build());
    }

    private static Struct.Builder structBuilder(Struct.Builder builder, String key, List<Value> value) {
        if (builder == null) {
            return Struct.newBuilder().putFields(key, Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(value)).build());
        }
        return builder.putFields(key, Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(value)).build());
    }

    public static AuditLog.Builder auditLogBuilder(String methodName, String callingPrincipalResourceId, Scope scope, String requestId, String clientIp, String apiVersion, String apiPrefix, String targetPrincipal, String roleName, ResourcesRequest resourcesRequest) {
        return AuditLog.newBuilder().setMethodName(methodName).setAuthenticationInfo(AuditLogUtils.getAuthenticationInfo(callingPrincipalResourceId)).addCloudResources(AuditLogUtils.getCloudResource(scope)).setRequestMetadata(AuditLogUtils.getRequestMetadata(requestId, clientIp)).setRequest(AuditLogUtils.getRequest(apiVersion, apiPrefix, methodName, targetPrincipal.split(":")[1], roleName, resourcesRequest));
    }
}

