/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.HashSet;
import org.apache.kafka.common.Uuid;

public class ProduceConsumeAuditLogTracker {
    private HashSet<TopicDetails> produceAuditLogTopicTracker;
    private HashSet<TopicDetails> consumeAuditLogTopicTracker;

    public Boolean hasProduceTopic(TopicDetails topicDetails) {
        this.initializeProduceAuditLogTopicTracker();
        return this.produceAuditLogTopicTracker.contains(topicDetails);
    }

    public int produceAuditLogTopicTrackerSize() {
        this.initializeProduceAuditLogTopicTracker();
        return this.produceAuditLogTopicTracker.size();
    }

    public Boolean hasConsumeTopic(TopicDetails topicDetails) {
        this.initializeConsumeAuditLogTopicTracker();
        return this.consumeAuditLogTopicTracker.contains(topicDetails);
    }

    public int consumeAuditLogTopicTrackerSize() {
        this.initializeConsumeAuditLogTopicTracker();
        return this.consumeAuditLogTopicTracker.size();
    }

    public void addProduceTopic(TopicDetails topicDetails) {
        this.initializeProduceAuditLogTopicTracker();
        this.produceAuditLogTopicTracker.add(topicDetails);
    }

    public void addConsumeTopic(TopicDetails topicDetails) {
        this.initializeConsumeAuditLogTopicTracker();
        this.consumeAuditLogTopicTracker.add(topicDetails);
    }

    private void initializeProduceAuditLogTopicTracker() {
        if (this.produceAuditLogTopicTracker == null) {
            this.produceAuditLogTopicTracker = new HashSet();
        }
    }

    private void initializeConsumeAuditLogTopicTracker() {
        if (this.consumeAuditLogTopicTracker == null) {
            this.consumeAuditLogTopicTracker = new HashSet();
        }
    }

    public static class TopicDetails {
        private final Uuid topicId;
        private final String topicName;

        public TopicDetails(Uuid topicId, String topicName) {
            this.topicId = topicId;
            this.topicName = topicName;
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicDetails that = (TopicDetails)o;
            return this.topicId.equals(that.topicId) && this.topicName.equals(that.topicName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.topicId.hashCode();
            result = 31 * result + this.topicName.hashCode();
            return result;
        }
    }
}

