/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeClientQuotasResponse
extends AbstractResponse {
    private final DescribeClientQuotasResponseData data;

    public DescribeClientQuotasResponse(DescribeClientQuotasResponseData data) {
        super(ApiKeys.DESCRIBE_CLIENT_QUOTAS);
        this.data = data;
    }

    public void complete(KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>> future) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            future.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        HashMap result = new HashMap(this.data.entries().size());
        for (DescribeClientQuotasResponseData.EntryData entries : this.data.entries()) {
            HashMap<String, String> entity = new HashMap<String, String>(entries.entity().size());
            for (DescribeClientQuotasResponseData.EntityData entityData : entries.entity()) {
                entity.put(entityData.entityType(), entityData.entityName());
            }
            HashMap<String, Double> values = new HashMap<String, Double>(entries.values().size());
            for (DescribeClientQuotasResponseData.ValueData valueData : entries.values()) {
                values.put(valueData.key(), valueData.value());
            }
            result.put(new ClientQuotaEntity(entity), values);
        }
        future.complete(result);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public DescribeClientQuotasResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public static DescribeClientQuotasResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClientQuotasResponse(new DescribeClientQuotasResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    public static DescribeClientQuotasResponse fromQuotaEntities(Map<ClientQuotaEntity, Map<String, Double>> entities, int throttleTimeMs) {
        ArrayList<DescribeClientQuotasResponseData.EntryData> entries = new ArrayList<DescribeClientQuotasResponseData.EntryData>(entities.size());
        for (Map.Entry<ClientQuotaEntity, Map<String, Double>> entry : entities.entrySet()) {
            ClientQuotaEntity quotaEntity = entry.getKey();
            ArrayList<DescribeClientQuotasResponseData.EntityData> entityData = new ArrayList<DescribeClientQuotasResponseData.EntityData>(quotaEntity.entries().size());
            for (Map.Entry<String, String> entityEntry : quotaEntity.entries().entrySet()) {
                entityData.add(new DescribeClientQuotasResponseData.EntityData().setEntityType(entityEntry.getKey()).setEntityName(entityEntry.getValue()));
            }
            Map<String, Double> quotaValues = entry.getValue();
            ArrayList<DescribeClientQuotasResponseData.ValueData> valueData = new ArrayList<DescribeClientQuotasResponseData.ValueData>(quotaValues.size());
            for (Map.Entry<String, Double> valuesEntry : entry.getValue().entrySet()) {
                valueData.add(new DescribeClientQuotasResponseData.ValueData().setKey(valuesEntry.getKey()).setValue(valuesEntry.getValue()));
            }
            entries.add(new DescribeClientQuotasResponseData.EntryData().setEntity(entityData).setValues(valueData));
        }
        return new DescribeClientQuotasResponse(new DescribeClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode((short)0).setErrorMessage(null).setEntries(entries));
    }
}

