/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.WindowIndexedArrays;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricSampleAggregatorState<E extends Entity>
extends WindowIndexedArrays {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSampleAggregatorState.class);
    private final Map<AggregationOptions<E>, MetricSampleCompleteness<E>> completenessCache;
    private final ConcurrentNavigableMap<Long, WindowState<E>> windowStates;
    private final MyAtomicLong[] windowGenerations;
    private final long windowMs;

    @Override
    protected int length() {
        return this.windowGenerations.length;
    }

    MetricSampleAggregatorState(int numWindows, long windowMs, final int completenessCacheSize) {
        this.completenessCache = new LinkedHashMap<AggregationOptions<E>, MetricSampleCompleteness<E>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<AggregationOptions<E>, MetricSampleCompleteness<E>> eldest) {
                return this.size() > completenessCacheSize;
            }
        };
        this.windowStates = new ConcurrentSkipListMap(Comparator.reverseOrder());
        this.windowGenerations = new MyAtomicLong[numWindows];
        for (int arrayIndex = 0; arrayIndex < numWindows; ++arrayIndex) {
            this.windowGenerations[arrayIndex] = new MyAtomicLong(0L);
        }
        this.windowMs = windowMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWindowGeneration(long windowIndex, long generation) {
        int arrayIndex = this.arrayIndex(windowIndex);
        MyAtomicLong myAtomicLong = this.windowGenerations[arrayIndex];
        synchronized (myAtomicLong) {
            if (windowIndex >= this.oldestWindowIndex) {
                this.windowGenerations[arrayIndex].set(generation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated window {} generation to {}", (Object)(windowIndex * this.windowMs), (Object)generation);
                }
            }
        }
    }

    synchronized void updateWindowState(long windowIndex, WindowState<E> windowState) {
        if (windowIndex >= this.oldestWindowIndex) {
            this.windowStates.put(windowIndex, windowState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetWindowIndices(long startingWindowIndex, int numWindowIndicesToReset) {
        if (this.inValidWindowRange(startingWindowIndex) || this.inValidWindowRange(startingWindowIndex + (long)numWindowIndicesToReset - 1L)) {
            throw new IllegalStateException("Should never reset a window index that is in the valid range");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting window indices [{}, {}]", (Object)startingWindowIndex, (Object)(startingWindowIndex + (long)numWindowIndicesToReset - 1L));
        }
        for (long wi = startingWindowIndex; wi < startingWindowIndex + (long)numWindowIndicesToReset; ++wi) {
            int arrayIndex = this.arrayIndex(wi);
            MyAtomicLong myAtomicLong = this.windowGenerations[arrayIndex];
            synchronized (myAtomicLong) {
                this.windowGenerations[arrayIndex].set(0L);
                this.windowStates.remove(wi);
                continue;
            }
        }
    }

    synchronized List<Long> windowIndicesToUpdate(long oldestWindowIndex, long currentWindowIndex) {
        ArrayList<Long> windowIndicesToUpdate = new ArrayList<Long>();
        for (long windowIndex = oldestWindowIndex; windowIndex < currentWindowIndex; ++windowIndex) {
            WindowState windowState = (WindowState)this.windowStates.get(windowIndex);
            int arrayIndex = this.arrayIndex(windowIndex);
            if (windowState != null && this.windowGenerations[arrayIndex].get() <= windowState.generation()) continue;
            windowIndicesToUpdate.add(windowIndex);
        }
        while (!this.windowStates.isEmpty() && (Long)this.windowStates.lastKey() < oldestWindowIndex) {
            this.windowStates.remove(this.windowStates.lastKey());
        }
        return windowIndicesToUpdate;
    }

    synchronized MetricSampleCompleteness<E> completeness(long fromWindowIndex, long toWindowIndex, AggregationOptions<E> options, long currentGeneration, Set<Integer> failedBrokerIds) {
        MetricSampleCompleteness<E> completeness = this.completenessCache.get(options);
        if (completeness == null || completeness.generation() < currentGeneration || fromWindowIndex != completeness.firstWindowIndex() || toWindowIndex != completeness.lastWindowIndex() || failedBrokerIds != null && !failedBrokerIds.isEmpty()) {
            completeness = this.computeCompleteness(fromWindowIndex, toWindowIndex, options, currentGeneration, failedBrokerIds);
            if (((Long)this.windowStates.lastKey()).longValue() == completeness.firstWindowIndex() && ((Long)this.windowStates.firstKey()).longValue() == completeness.lastWindowIndex()) {
                this.completenessCache.put(options, completeness);
            }
        }
        return completeness;
    }

    synchronized MetricSampleCompleteness<E> completeness(long fromWindowIndex, long toWindowIndex, AggregationOptions<E> options, long currentGeneration) {
        return this.completeness(fromWindowIndex, toWindowIndex, options, currentGeneration, Collections.emptySet());
    }

    synchronized Map<Long, WindowState<E>> windowStates() {
        return this.windowStates;
    }

    synchronized Map<Long, Long> windowGenerations() {
        TreeMap<Long, Long> windowGenerations = new TreeMap<Long, Long>(Comparator.reverseOrder());
        for (long wi = this.oldestWindowIndex; wi < this.currentWindowIndex(); ++wi) {
            int arrayIndex = this.arrayIndex(wi);
            windowGenerations.put(wi, this.windowGenerations[arrayIndex].get());
        }
        return windowGenerations;
    }

    synchronized void clear() {
        this.oldestWindowIndex = 0L;
        this.completenessCache.clear();
        this.windowStates.clear();
        for (MyAtomicLong generation : this.windowGenerations) {
            generation.set(0L);
        }
    }

    private MetricSampleCompleteness<E> computeCompleteness(long fromWindowIndex, long toWindowIndex, AggregationOptions<E> options, long currentGeneration, Set<Integer> failedBrokerIds) {
        MetricSampleCompleteness<Object> completeness = new MetricSampleCompleteness<Object>(currentGeneration, this.windowMs);
        HashMap entityExtrapolations = new HashMap();
        completeness.addValidEntities(new HashSet<E>(options.interestedEntities()));
        completeness.addValidEntityGroups(new HashSet<String>(options.interestedEntityGroups()));
        for (Map.Entry entry : this.windowStates.entrySet()) {
            long windowIndex = (Long)entry.getKey();
            if (windowIndex > toWindowIndex) continue;
            if (windowIndex < fromWindowIndex) break;
            WindowState windowState = (WindowState)entry.getValue();
            windowState.maybeInclude(windowIndex, completeness, entityExtrapolations, options, failedBrokerIds);
        }
        if (completeness.validWindowIndices().isEmpty()) {
            completeness.retainAllValidEntities(Collections.emptySet());
            completeness.retainAllValidEntityGroups(Collections.emptySet());
        }
        completeness.setValidEntityRatio((float)completeness.validEntities().size() / (float)options.interestedEntities().size());
        completeness.setValidEntityGroupRatio((float)completeness.validEntityGroups().size() / (float)options.interestedEntityGroups().size());
        return completeness;
    }

    private static class MyAtomicLong
    extends AtomicLong {
        MyAtomicLong(long initialValue) {
            super(initialValue);
        }
    }
}

