/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KafkaCruiseControlOperationMetricsTracker {
    private static final String METRIC_NAME = "cruise-control-operations";
    private static final String METRIC_OPERATION_TAG = "operation";
    private final DataBalancerMetricsRegistry registry;
    private final Map<Operation, Integer> operationStates;

    public KafkaCruiseControlOperationMetricsTracker(DataBalancerMetricsRegistry registry) {
        this.registry = registry;
        this.operationStates = new ConcurrentHashMap<Operation, Integer>();
        this.init();
    }

    private void init() {
        Arrays.stream(Operation.values()).forEach(operation -> this.registry.newGauge(KafkaCruiseControlOperationMetricsTracker.class, METRIC_NAME, () -> this.operationStates.getOrDefault(operation, 0), Collections.singletonMap(METRIC_OPERATION_TAG, operation.toString())));
    }

    public void beginOperation(Operation operation) {
        this.operationStates.put(operation, 1);
    }

    public void completeOperation(Operation operation) {
        this.operationStates.put(operation, 0);
    }

    public static enum Operation {
        SELF_HEALING("self-healing"),
        BROKER_REMOVAL("broker-removal"),
        BROKER_ADDITION("broker-addition");

        private final String operationName;

        private Operation(String operationName) {
            this.operationName = operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

