/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CapacityGoal;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;

public class ConsumerOutboundCapacityGoal
extends CapacityGoal {
    public ConsumerOutboundCapacityGoal() {
    }

    ConsumerOutboundCapacityGoal(BalancingConstraint constraint) {
        super(constraint);
    }

    @Override
    protected boolean shouldExcludeForReplicaMove(Replica replica) {
        return !replica.isOriginalOffline() && !replica.isLeader();
    }

    @Override
    protected boolean skipUtilizationCheckForSaturatedBrokers() {
        return true;
    }

    @Override
    protected Resource resource() {
        return Resource.CONSUME_OUT;
    }

    @Override
    public String name() {
        return ConsumerOutboundCapacityGoal.class.getSimpleName();
    }
}

