/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.DistributionThresholdUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntraBrokerDiskUsageDistributionGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(IntraBrokerDiskUsageDistributionGoal.class);
    private static final long PER_DISK_SWAP_TIMEOUT_MS = 500L;
    private static final Resource RESOURCE = Resource.DISK;
    private final Map<Broker, Double> balanceUpperThresholdByBroker;
    private final Map<Broker, Double> balanceLowerThresholdByBroker;

    public IntraBrokerDiskUsageDistributionGoal() {
        this.balanceLowerThresholdByBroker = new HashMap<Broker, Double>();
        this.balanceUpperThresholdByBroker = new HashMap<Broker, Double>();
    }

    IntraBrokerDiskUsageDistributionGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
        this.balanceLowerThresholdByBroker = new HashMap<Broker, Double>();
        this.balanceUpperThresholdByBroker = new HashMap<Broker, Double>();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        double balancePercentage = DistributionThresholdUtils.balancePercentage(optimizationOptions, this.balancingConstraint, RESOURCE);
        for (Broker broker : this.brokersToBalance(clusterModel)) {
            double averageDiskUtilization = GoalUtils.averageDiskUtilizationPercentage(broker);
            this.balanceUpperThresholdByBroker.put(broker, averageDiskUtilization * (1.0 + balancePercentage));
            this.balanceLowerThresholdByBroker.put(broker, averageDiskUtilization * Math.max(0.0, 1.0 - balancePercentage));
        }
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) {
        ArrayList<String> disksAboveBalanceUpperLimit = new ArrayList<String>();
        ArrayList<String> disksBelowBalanceLowerLimit = new ArrayList<String>();
        for (Broker broker : this.brokersToBalance(clusterModel)) {
            double upperLimit = this.balanceUpperThresholdByBroker.get(broker);
            double lowerLimit = this.balanceLowerThresholdByBroker.get(broker);
            for (Disk disk : broker.disks()) {
                if (!disk.isAlive()) continue;
                if (GoalUtils.diskUtilizationPercentage(disk) > upperLimit) {
                    disksAboveBalanceUpperLimit.add(broker.id() + ":" + disk.logDir());
                }
                if (!(GoalUtils.diskUtilizationPercentage(disk) < lowerLimit)) continue;
                disksBelowBalanceLowerLimit.add(broker.id() + ":" + disk.logDir());
            }
        }
        if (!disksAboveBalanceUpperLimit.isEmpty()) {
            LOG.warn("Disks {} are above balance upper limit after optimization.", disksAboveBalanceUpperLimit);
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        if (!disksBelowBalanceLowerLimit.isEmpty()) {
            LOG.warn("Disks {} are below balance lower limit after optimization.", disksBelowBalanceLowerLimit);
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        this.finish();
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return new TreeSet<Broker>(clusterModel.aliveBrokers());
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        double sourceUtilizationDelta = this.sourceUtilizationDelta(action, clusterModel);
        Broker broker = clusterModel.broker(action.sourceBrokerId());
        Disk sourceDisk = broker.disk(action.sourceBrokerLogdir());
        Disk destinationDisk = broker.disk(action.destinationBrokerLogdir());
        if (sourceUtilizationDelta == 0.0) {
            return ActionAcceptance.ACCEPT;
        }
        if (this.isChangeViolatingLimit(sourceUtilizationDelta, sourceDisk, destinationDisk)) {
            return ActionAcceptance.REPLICA_REJECT;
        }
        return this.isGettingMoreBalanced(sourceDisk, destinationDisk, sourceUtilizationDelta) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        double sourceUtilizationDelta = this.sourceUtilizationDelta(action, clusterModel);
        return sourceUtilizationDelta != 0.0 && this.actionAcceptance(action, clusterModel) == ActionAcceptance.ACCEPT;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    private double sourceUtilizationDelta(ReplicaBalancingAction action, ClusterModel clusterModel) {
        if (action.sourceBrokerLogdir() == null || action.destinationBrokerLogdir() == null) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support balancing action not specifying logdir.");
        }
        Broker broker = clusterModel.broker(action.sourceBrokerId());
        Replica sourceReplica = broker.replica(action.topicPartition());
        switch (action.balancingAction()) {
            case INTRA_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = broker.replica(action.destinationTopicPartition());
                return destinationReplica.load().expectedUtilizationFor(RESOURCE) - sourceReplica.load().expectedUtilizationFor(RESOURCE);
            }
            case LEADERSHIP_MOVEMENT: {
                return 0.0;
            }
            case INTRA_BROKER_REPLICA_MOVEMENT: {
                return -sourceReplica.load().expectedUtilizationFor(RESOURCE);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    private boolean isChangeViolatingLimit(double sourceUtilizationDelta, Disk sourceDisk, Disk destinationDisk) {
        double destinationDiskAllowance;
        double balanceUpperThreshold = this.balanceUpperThresholdByBroker.get(sourceDisk.broker());
        double balanceLowerThreshold = this.balanceLowerThresholdByBroker.get(sourceDisk.broker());
        double sourceDiskAllowance = sourceUtilizationDelta > 0.0 ? sourceDisk.capacity() * balanceUpperThreshold - sourceDisk.utilization() : sourceDisk.utilization() - sourceDisk.capacity() * balanceLowerThreshold;
        double d = destinationDiskAllowance = sourceUtilizationDelta > 0.0 ? destinationDisk.utilization() - destinationDisk.capacity() * balanceLowerThreshold : destinationDisk.capacity() * balanceUpperThreshold - destinationDisk.utilization();
        return sourceDiskAllowance >= 0.0 && sourceDiskAllowance < Math.abs(sourceUtilizationDelta) || destinationDiskAllowance >= 0.0 && destinationDiskAllowance < Math.abs(sourceUtilizationDelta);
    }

    private boolean isGettingMoreBalanced(Disk sourceDisk, Disk destinationDisk, double sourceUtilizationDelta) {
        double prevDiff = GoalUtils.diskUtilizationPercentage(sourceDisk) - GoalUtils.diskUtilizationPercentage(destinationDisk);
        double nextDiff = prevDiff + sourceUtilizationDelta / sourceDisk.capacity() + sourceUtilizationDelta / destinationDisk.capacity();
        return Math.abs(nextDiff) < Math.abs(prevDiff);
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        double upperLimit = this.balanceUpperThresholdByBroker.get(broker);
        double lowerLimit = this.balanceLowerThresholdByBroker.get(broker);
        for (Disk disk : broker.disks()) {
            if (!disk.isAlive()) continue;
            if (GoalUtils.diskUtilizationPercentage(disk) > upperLimit && this.rebalanceByMovingLoadOut(disk, clusterModel, optimizedGoals, optimizationOptions)) {
                this.rebalanceBySwappingLoadOut(disk, clusterModel, optimizedGoals, optimizationOptions);
            }
            if (!(GoalUtils.diskUtilizationPercentage(disk) < lowerLimit) || !this.rebalanceByMovingLoadIn(disk, clusterModel, optimizedGoals, optimizationOptions)) continue;
            this.rebalanceBySwappingLoadIn(disk, clusterModel, optimizedGoals, optimizationOptions);
        }
    }

    private boolean rebalanceByMovingLoadIn(Disk disk, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        Broker broker = disk.broker();
        double brokerUtilization = GoalUtils.averageDiskUtilizationPercentage(broker);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        PriorityQueue<Disk> candidateDiskPQ = new PriorityQueue<Disk>((d1, d2) -> Double.compare(GoalUtils.diskUtilizationPercentage(d2), GoalUtils.diskUtilizationPercentage(d1)));
        for (Disk candidateDisk : broker.disks()) {
            if (!candidateDisk.isAlive() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) > brokerUtilization)) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        while (!candidateDiskPQ.isEmpty()) {
            Disk candidateDisk = (Disk)candidateDiskPQ.poll();
            candidateDisk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.deprioritizeDiskImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
            Iterator<Replica> iterator = candidateDisk.trackedSortedReplicas(this.name()).reverselySortedReplicas().iterator();
            while (iterator.hasNext()) {
                Disk d;
                Replica replica = iterator.next();
                if (excludedTopics.contains(replica.topicPartition().topic()) || (d = this.maybeMoveReplicaBetweenDisks(clusterModel, replica, Collections.singleton(disk), optimizedGoals)) == null) continue;
                if (GoalUtils.diskUtilizationPercentage(disk) > this.balanceLowerThresholdByBroker.get(broker)) {
                    candidateDisk.untrackSortedReplicas(this.name());
                    return false;
                }
                iterator.remove();
                if (candidateDiskPQ.isEmpty() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) < GoalUtils.diskUtilizationPercentage((Disk)candidateDiskPQ.peek()))) continue;
                candidateDiskPQ.add(candidateDisk);
                break;
            }
            candidateDisk.untrackSortedReplicas(this.name());
        }
        return true;
    }

    private boolean rebalanceByMovingLoadOut(Disk disk, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        Broker broker = disk.broker();
        double brokerUtilization = GoalUtils.averageDiskUtilizationPercentage(broker);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        disk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.deprioritizeDiskImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
        PriorityQueue<Disk> candidateDiskPQ = new PriorityQueue<Disk>((d1, d2) -> Double.compare(GoalUtils.diskUtilizationPercentage(d1), GoalUtils.diskUtilizationPercentage(d2)));
        for (Disk candidateDisk : broker.disks()) {
            if (!candidateDisk.isAlive() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) < brokerUtilization)) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        block1: while (!candidateDiskPQ.isEmpty()) {
            Disk candidateDisk = (Disk)candidateDiskPQ.poll();
            Iterator<Replica> iterator = disk.trackedSortedReplicas(this.name()).reverselySortedReplicas().iterator();
            while (iterator.hasNext()) {
                Disk d;
                Replica replica = iterator.next();
                if (excludedTopics.contains(replica.topicPartition().topic()) || (d = this.maybeMoveReplicaBetweenDisks(clusterModel, replica, Collections.singleton(candidateDisk), optimizedGoals)) == null) continue;
                if (GoalUtils.diskUtilizationPercentage(disk) < this.balanceUpperThresholdByBroker.get(broker)) {
                    disk.untrackSortedReplicas(this.name());
                    return false;
                }
                iterator.remove();
                if (candidateDiskPQ.isEmpty() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) > GoalUtils.diskUtilizationPercentage((Disk)candidateDiskPQ.peek()))) continue;
                candidateDiskPQ.add(candidateDisk);
                continue block1;
            }
        }
        disk.untrackSortedReplicas(this.name());
        return true;
    }

    private void rebalanceBySwappingLoadOut(Disk disk, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        long swapStartTimeMs = System.currentTimeMillis();
        Broker broker = disk.broker();
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        disk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
        PriorityQueue<Disk> candidateDiskPQ = new PriorityQueue<Disk>((d1, d2) -> Double.compare(GoalUtils.diskUtilizationPercentage(d1), GoalUtils.diskUtilizationPercentage(d2)));
        for (Disk candidateDisk : broker.disks()) {
            if (!candidateDisk.isAlive() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) < this.balanceUpperThresholdByBroker.get(broker))) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        while (!candidateDiskPQ.isEmpty()) {
            Disk candidateDisk = (Disk)candidateDiskPQ.poll();
            candidateDisk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
            for (Replica sourceReplica : disk.trackedSortedReplicas(this.name()).reverselySortedReplicas()) {
                Replica swappedIn;
                if (IntraBrokerDiskUsageDistributionGoal.shouldExclude(sourceReplica, excludedTopics) || (swappedIn = this.maybeSwapReplicaBetweenDisks(clusterModel, sourceReplica, candidateDisk.trackedSortedReplicas(this.name()).sortedReplicas(), optimizedGoals, excludedTopics)) == null) continue;
                if (!(GoalUtils.diskUtilizationPercentage(disk) < this.balanceUpperThresholdByBroker.get(broker))) break;
                disk.untrackSortedReplicas(this.name());
                candidateDisk.untrackSortedReplicas(this.name());
                return;
            }
            candidateDisk.untrackSortedReplicas(this.name());
            if (this.remainingPerDiskSwapTimeMs(swapStartTimeMs) <= 0L) {
                LOG.debug("Swap load out timeout for disk {}.", (Object)disk.logDir());
                break;
            }
            if (!(GoalUtils.diskUtilizationPercentage(candidateDisk) < this.balanceUpperThresholdByBroker.get(broker))) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        disk.untrackSortedReplicas(this.name());
    }

    private void rebalanceBySwappingLoadIn(Disk disk, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        long swapStartTimeMs = System.currentTimeMillis();
        Broker broker = disk.broker();
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        disk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
        PriorityQueue<Disk> candidateDiskPQ = new PriorityQueue<Disk>((d1, d2) -> Double.compare(GoalUtils.diskUtilizationPercentage(d2), GoalUtils.diskUtilizationPercentage(d1)));
        for (Disk candidateDisk : broker.disks()) {
            if (!candidateDisk.isAlive() || !(GoalUtils.diskUtilizationPercentage(candidateDisk) > this.balanceLowerThresholdByBroker.get(broker))) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        while (!candidateDiskPQ.isEmpty()) {
            Disk candidateDisk = (Disk)candidateDiskPQ.poll();
            candidateDisk.trackSortedReplicas(this.name(), ReplicaSortFunctionFactory.selectOnlineReplicas(), ReplicaSortFunctionFactory.sortByMetricResourceValue(RESOURCE));
            for (Replica sourceReplica : disk.trackedSortedReplicas(this.name()).sortedReplicas()) {
                Replica swappedIn;
                if (IntraBrokerDiskUsageDistributionGoal.shouldExclude(sourceReplica, excludedTopics) || (swappedIn = this.maybeSwapReplicaBetweenDisks(clusterModel, sourceReplica, candidateDisk.trackedSortedReplicas(this.name()).reverselySortedReplicas(), optimizedGoals, excludedTopics)) == null) continue;
                if (!(GoalUtils.diskUtilizationPercentage(disk) > this.balanceLowerThresholdByBroker.get(broker))) break;
                disk.untrackSortedReplicas(this.name());
                candidateDisk.untrackSortedReplicas(this.name());
                return;
            }
            candidateDisk.untrackSortedReplicas(this.name());
            if (this.remainingPerDiskSwapTimeMs(swapStartTimeMs) <= 0L) {
                LOG.debug("Swap load out timeout for disk {}.", (Object)disk.logDir());
                break;
            }
            if (!(GoalUtils.diskUtilizationPercentage(candidateDisk) > this.balanceLowerThresholdByBroker.get(broker))) continue;
            candidateDiskPQ.add(candidateDisk);
        }
        disk.untrackSortedReplicas(this.name());
    }

    private long remainingPerDiskSwapTimeMs(long swapStartTimeMs) {
        return 500L - (System.currentTimeMillis() - swapStartTimeMs);
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new ClusterModelStatsComparator(){

            @Override
            public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
                if (stats1.numUnbalancedDisks() > stats2.numUnbalancedDisks() || stats1.diskUtilizationStandardDeviation() > stats2.diskUtilizationStandardDeviation()) {
                    return -1;
                }
                return 1;
            }

            @Override
            public String explainLastComparison() {
                return null;
            }
        };
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(this.numWindows, this.minMonitoredPartitionPercentage, false);
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void finish() {
        this.finished = true;
    }
}

